#
# Script designed to be tested from inside the CamiTK Python interpreter using PythonManager::runScript
# See TestPythonScript.cpp
# 
# The requirements (if any) must defined in the the QRC file
#
import camitk
import numpy

camitk.Application.open(camitk.Core.getTestDataDir() + "/bassin.msh") 
# FIXME with (camitk.Core.getTestDataDir() + "bassin.msh") (no / before bassin.msh) should generate an error and create no top level... Instead it seems it is creating something called testdatabassin → did it opened a directory?
assert len(camitk.Application.getTopLevelComponents()) == 1

mesh = camitk.Application.getTopLevelComponents()[0]
assert mesh.getName() == "bassin"

points = mesh.getPointSetAsNumpy()
actual_barycenter = numpy.mean(points, axis=0)
expected_barycenter = numpy.array([1.8276852, -20.284256, 167.19714], dtype='f')
# same as assert np.array_equal(expected,barycenter)
assert numpy.all(actual_barycenter == expected_barycenter), f"Barycenter should be {expected_barycenter} not {actual_barycenter}"

assert camitk.Application.closeAll(), f"Close all should return true as no components have been modified"
