import numpy as np
import camitk

def init(self:camitk.Action):
    camitk.info("CamiTK version: " + camitk.__version__)
    camitk.info("Opened components before: " + str(len(camitk.Application.getTopLevelComponents())))
    camitk.Application.open(camitk.Core.getTestDataDir() + "/sinus_skin.vtk")
    camitk.info("Opened components after: " + str(len(camitk.Application.getTopLevelComponents())))
    for c in camitk.Application.getTopLevelComponents():
        print(c.getName()) # print will print to CamiTK console without timestamp, level and location in code    

def compute_barycenter(self):
    points = self.getTargets()[-1].getPointSetAsNumpy()
    barycenter = np.mean(points, axis=0)
    self.setParameterValue("Barycenter", "QVector3D(" + str(barycenter[0]) + "," + str(barycenter[1]) + "," + str(barycenter[2]) +")")
    return points, barycenter

def targetDefined(self:camitk.Action):
    compute_barycenter(self)

def process(self:camitk.Action):
    points, barycenter = compute_barycenter(self)

    return True