// Copyright (c) 2000-2001 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#ifndef   __mq3_h
#define   __mq3_h

// forward declarations
class MQ3;
class Buffer;
class Decoder;
class Output;

class Configuration;
class Controls;
class EqPreset;
class Equalizer;
class Organizer;
class Song;
class ScrollLabel;
class MainVisual;

class QFrame;
class QLabel;
class QIODevice;
class QSettings;
class QSlider;

#include <qwidget.h>
#include <qurloperator.h>


class MQ3 :  public QWidget {
    Q_OBJECT
public:
    MQ3();
    ~MQ3();

    void closeEvent(QCloseEvent *);
    void customEvent(QCustomEvent *);
    void showEvent(QShowEvent *);

    static MQ3 *instance();


public slots:
    void play();
    void pause();
    void stop();
    void previous();
    void next();
    void seek(int);
    void changeSong();
    void configChanged();


private slots:
    void startseek();
    void doneseek();
    void eqChanged(const EqPreset &);


private:
    void stopAll();

    QIODevice *input;
    Output *output;
    Decoder *decoder;

    Song *source;
    QString statusString, timeString, infoString;

    QFrame *mainframe;
    ScrollLabel *statusLabel, *songLabel;
    MainVisual *mainvisual;
    QLabel *timeLabel, *seeklabel;
    QSlider *seekbar;
    Configuration *config;
    Controls *controls;
    Equalizer *equalizer;
    Organizer *organizer;

    bool firstShow, playOnStartup, showOrganizerOnStartup, showEqualizerOnStartup,
	remainingTime, seeking, enableEq;
    int outputBufferSize;
};

#endif // __mq3_h

