// Copyright (c) 2000-2001 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#include "mq3.h"

#include <qapplication.h>
#include <qpalette.h>
#include <qbrush.h>

#ifdef __FreeBSD__
#  include <sys/types.h>
#  include <sys/rtprio.h>
#endif // __FreeBSD__

#include <stdio.h>
#if defined( _OS_UNIX_ ) || defined( Q_OS_UNIX )
#include <unistd.h>
#endif

int main(int argc, char **argv) {
    bool realtime = FALSE;
    for (int i = 1; i < argc; i++)
	if (! strcmp(argv[i], "-realtime"))
	    realtime = TRUE;

#if defined( _OS_UNIX_ ) || defined( Q_OS_UNIX )
    if (geteuid() == 0) {
	if (realtime) {

#ifdef __FreeBSD__
	    struct rtprio rtp;
            rtp.type = RTP_PRIO_REALTIME;
            rtp.prio = 1;
            if (rtprio(RTP_SET, 0, &rtp)) {
                qWarning("MQ3: error setting realtime priority:");
                perror  ("     rtprio");
            } else {
		qWarning("MQ3: using realtime priority");
            }
#else // !__FreeBSD__
	    qWarning("MQ3: realtime priority unsupported on this platform.");
#endif // __FreeBSD__

	}

	// drop root privledges
	setuid(getuid());
	setgid(getgid());
    } else if (realtime) {
	qWarning("MQ3: root privileges required for realtime playing.");
    }
#endif
    QApplication mq3app(argc, argv);

    MQ3 mq3;
    mq3app.setMainWidget(&mq3);
    mq3.show();

    return mq3app.exec();
}

