// Copyright (c) 2000-2001 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#ifndef EQUALIZER_H
#define EQUALIZER_H

#include "equalizerbase.h"

#include <qpixmap.h>

class EqPreset;

class QListViewItem;
class QSettings;


class Equalizer : public EqualizerBase
{
    Q_OBJECT

public:
    Equalizer(QWidget * = 0);
    ~Equalizer();

    bool isModified() const { return modified; }

    void load();
    void save();

    void configChanged(QSettings &);
    void deinit();

    QStringList presets() const;
    EqPreset preset(const QString &) const;

    static Equalizer *instance();


signals:
    void presetChanged(const EqPreset &);


private:
    void addPreset();
    void copyPreset();
    void removePreset();
    void bandChanged(int);
    void presetHighlighted(QListViewItem *);

    void setModified(bool m) { modified = m; }

    QPixmap drawArea;
    bool autosave, modified, ignorechange;

    friend class EqPresetItem;
};


#endif // EQUALIZER_H
