# ROCm 6.3.0 release notes

The release notes provide a summary of notable changes since the previous ROCm release.

- [Release highlights](#release-highlights)

- [Operating system and hardware support changes](#operating-system-and-hardware-support-changes)

- [ROCm components versioning](#rocm-components)

- [Detailed component changes](#detailed-component-changes)

- [ROCm known issues](#rocm-known-issues)

- [ROCm resolved issues](#rocm-resolved-issues)

- [ROCm upcoming changes](#rocm-upcoming-changes)

```{note}
If you’re using Radeon™ PRO or Radeon GPUs in a workstation setting with a
display connected, continue to use ROCm 6.2.3. See the [Use ROCm on Radeon
GPUs](https://rocm.docs.amd.com/projects/radeon/en/latest/index.html)
documentation to verify compatibility and system requirements.
```

## Release highlights

The following are notable new features and improvements in ROCm 6.3.0. For changes to individual components, see
[Detailed component changes](#detailed-component-changes).

### rocJPEG added

ROCm 6.3.0 introduces the rocJPEG library to the ROCm software stack. rocJPEG is a high performance
JPEG decode SDK for AMD GPUs. For more information, see the [rocJPEG
documentation](https://rocm.docs.amd.com/projects/rocJPEG/en/docs-6.3.0/index.html).

### ROCm Compute Profiler and ROCm Systems Profiler

These ROCm components have been renamed to reflect their new direction as part of the ROCm software
stack.

- **ROCm Compute Profiler**, formerly Omniperf. For more information, see the [ROCm Compute Profiler
  documentation](https://rocm.docs.amd.com/projects/rocprofiler-compute/en/docs-6.3.0/index.html) and
  [https://github.com/ROCm/rocprofiler-compute](https://github.com/ROCm/rocprofiler-compute) on GitHub.

- **ROCm Systems Profiler**, formerly Omnitrace. For more information, see the [ROCm Systems Profiler
  documentation](https://rocm.docs.amd.com/projects/rocprofiler-systems/en/docs-6.3.0/index.html) and
  [https://github.com/ROCm/rocprofiler-systems](https://github.com/ROCm/rocprofiler-systems) on GitHub.
  For future compatibility, the Omnitrace project is available at [https://github.com/ROCm/omnitrace](https://github.com/ROCm/omnitrace).
  See the [Omnitrace documentation](https://rocm.docs.amd.com/projects/omnitrace/en/latest/index.html).

  ```{note}
  Update any references to the old binary names `omniperf` and `omnitrace` to
  ensure compatibility with the new `rocprof-compute` and `rocprof-sys-*` binaries.
  This might include updating environment variables, commands, and paths as
  needed to avoid disruptions to your profiling or tracing workflows.

  See [ROCm Compute Profiler 3.0.0](#rocm-compute-profiler-3-0-0) and [ROCm Systems
  Profiler 0.1.0](#rocm-systems-profiler-0-1-0).
  ```

### SHARK AI toolkit for high-speed inferencing and serving introduced

SHARK is an open-source toolkit for high-performance serving of popular generative AI and large
language models. In its initial release, SHARK contains the [Shortfin high-performance serving
engine](https://github.com/nod-ai/shark-ai/tree/main/shortfin), which is the SHARK inferencing
library that includes example server applications for popular models.

This initial release includes support for serving the Stable Diffusion XL model on AMD Instinct™
MI300 devices using ROCm. See the SHARK [release
page](https://github.com/nod-ai/shark-ai/releases/tag/v3.0.0) on GitHub to get started.

### PyTorch 2.4 support added

ROCm 6.3.0 adds support for PyTorch 2.4. See the [Compatibility
matrix](https://rocm.docs.amd.com/en/docs-6.3.0/compatibility/compatibility-matrix.html#framework-support-compatibility-matrix)
for the complete list of PyTorch versions tested for compatibility with ROCm.

### Flash Attention kernels in Triton and Composable Kernel (CK) added to Transformer Engine

Composable Kernel-based and Triton-based Flash Attention kernels have been integrated into
Transformer Engine via the ROCm Composable Kernel and AOTriton libraries. The
Transformer Engine can now optionally select a flexible and optimized Attention
solution for AMD GPUs. For more information, see [Fused Attention Backends on
ROCm](https://github.com/ROCm/TransformerEngine/tree/dev?tab=readme-ov-file#fused-attention-backends-on-rocm)
on GitHub.

### HIP compatibility

HIP now includes the `hipStreamLegacy` API. It's equivalent to NVIDIA `cudaStreamLegacy`. For more
information, see [Global enum and
defines](https://rocm.docs.amd.com/projects/HIP/en/docs-6.3.0/reference/hip_runtime_api/global_defines_enums_structs_files/global_enum_and_defines.html#c.hipStreamLegacy)
in the HIP runtime API documentation.

### Unload active amdgpu-dkms module without a system reboot

On Instinct MI200 and MI300 systems, you can now unload the active `amdgpu-dkms` modules, and reinstall
and reload newer modules without a system reboot. If the new `dkms` package includes newer firmware
components, the driver will first reset the device and then load newer firmware components.

### ROCm Offline Installer Creator updates

The ROCm Offline Installer Creator 6.3 introduces a new feature to uninstall the previous version of
ROCm on the non-connected target system before installing a new version. This feature is only supported
on the Ubuntu distribution. See the [ROCm Offline Installer
Creator](https://rocm.docs.amd.com/projects/install-on-linux/en/docs-6.3.0/install/rocm-offline-installer.html)
documentation for more information.

### OpenCL ICD loader separated from ROCm

The OpenCL ICD loader is no longer delivered as part of ROCm, and must be installed separately
as part of the [ROCm installation
process](https://rocm.docs.amd.com/projects/install-on-linux/en/docs-6.3.0). For Ubuntu and RHEL
installations, the required package is installed as part of the setup described in
[Prerequisites](https://rocm.docs.amd.com/projects/install-on-linux/en/docs-6.3.0/install/prerequisites.html).
In other supported Linux distributions like SUSE, the required package must be installed in separate steps, which are included in the installation instructions.

Because the OpenCL path is now separate from the ROCm installation for versioned and multi-version
installations, you must manually define the `LD_LIBRARY_PATH` to point to the ROCm
installation library as described in the [Post-installation
instructions](https://rocm.docs.amd.com/projects/install-on-linux/en/docs-6.3.0/install/post-install.html).
If the `LD_LIBRARY_PATH` is not set as needed for versioned or multi-version installations, OpenCL
applications like `clinfo` will fail to run and return an error.

### ROCT Thunk Interface integrated into ROCr runtime

The ROCT Thunk Interface package is now integrated into the ROCr runtime. As a result, the ROCT package
is no longer included as a separate package in the ROCm software stack.

### ROCm documentation updates

ROCm documentation continues to be updated to provide clearer and more comprehensive guidance for a
wider variety of user needs and use cases.

- Documentation for Tensile is now available. Tensile is a library that creates
  benchmark-driven backend implementations for GEMMs, serving primarily as a
  backend component of rocBLAS. See the [Tensile
  documentation](https://rocm.docs.amd.com/projects/Tensile/en/docs-6.3.0/src/index.html).

- New documentation has been added to explain the advantages of enabling the IOMMU in passthrough
  mode for Instinct accelerators and Radeon GPUs. See [Input-Output Memory Management
  Unit](https://rocm.docs.amd.com/en/docs-6.3.0/conceptual/iommu.html).

- The HIP documentation has been updated and includes the following new topics:

  - [What is HIP?](https://rocm.docs.amd.com/projects/HIP/en/docs-6.3.0/what_is_hip.html)
  - [HIP environment variables](https://rocm.docs.amd.com/projects/HIP/en/docs-6.3.0/reference/env_variables.html)
  - [Initialization](https://rocm.docs.amd.com/projects/HIP/en/docs-6.3.0/how-to/hip_runtime_api/initialization.html)
    and [error handling](https://rocm.docs.amd.com/projects/HIP/en/docs-6.3.0/how-to/hip_runtime_api/error_handling.html)
  - [Hardware features](https://rocm.docs.amd.com/projects/HIP/en/docs-6.3.0/reference/hardware_features.html)
  - [Call stack](https://rocm.docs.amd.com/projects/HIP/en/docs-6.3.0/how-to/hip_runtime_api/call_stack.html)
  - [External resource interoperability](https://rocm.docs.amd.com/projects/HIP/en/docs-6.3.0/how-to/hip_runtime_api/external_interop.html)

- The following HIP documentation topics have been updated:

  - [HIP FAQ](https://rocm.docs.amd.com/projects/HIP/en/docs-6.3.0/faq.html)
  - [Deprecated APIs](https://rocm.docs.amd.com/projects/HIP/en/docs-6.3.0/reference/deprecated_api_list.html)
  - [Performance guidelines](https://rocm.docs.amd.com/projects/HIP/en/docs-6.3.0/how-to/performance_guidelines.html)

- The following HIP documentation topics have been reorganized to improve usability:

  - [HIP documentation landing page](https://rocm.docs.amd.com/projects/HIP/en/docs-6.3.0/index.html)
  - [HIP runtime API reference topics](https://rocm.docs.amd.com/projects/HIP/en/docs-6.3.0/reference/hip_runtime_api_reference.html)
  - [Programming guide](https://rocm.docs.amd.com/projects/HIP/en/docs-6.3.0/how-to/hip_runtime_api.html)
