% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recreg.R
\name{twostageREC}
\alias{twostageREC}
\title{Fittting of Two-stage recurrent events random effects model based on Cox/Cox or Cox/Ghosh-Lin marginals}
\usage{
twostageREC(
  margsurv,
  recurrent,
  data = parent.frame(),
  theta = NULL,
  model = c("full", "shared", "non-shared"),
  ghosh.lin = NULL,
  theta.des = NULL,
  var.link = 0,
  method = "NR",
  no.opt = FALSE,
  weights = NULL,
  se.cluster = NULL,
  fnu = NULL,
  nufix = 0,
  nu = NULL,
  numderiv = 1,
  derivmethod = c("simple", "Richardson"),
  ...
)
}
\arguments{
\item{margsurv}{marginal model for terminal event}

\item{recurrent}{marginal model for recurrent events}

\item{data}{used for fitting}

\item{theta}{starting value for total variance of gamma frailty}

\item{model}{can fully shared "full", partly shared "shared", or non-shared where the random effect acts only on recurrent events}

\item{ghosh.lin}{to force use ghosh.lin marginals based on recurrent (taking baseline and coefficients)}

\item{theta.des}{regression design for variance}

\item{var.link}{possible link  function 1 is exponential link}

\item{method}{NR}

\item{no.opt}{to not optimize}

\item{weights}{possible weights}

\item{se.cluster}{to combine influence functions for naive variance based on these clusters GEE style}

\item{fnu}{a function to make transformation for nu (amount shared)}

\item{nufix}{to fix the amount shared}

\item{nu}{starting value for amount shared}

\item{numderiv}{uses numerical derivatives for some derivatives}

\item{derivmethod}{method for numerical derivative}

\item{...}{arguments for}
}
\description{
Fittting of Two-stage recurrent events random effects model based on Cox/Cox or Cox/Ghosh-Lin marginals. Random
effects model fore recurrent events with terminal  event. Marginal models fitted first and given to twostageREC function.
}
\references{
Scheike (2026), Two-stage recurrent events random effects models, LIDA, to appear
}
