% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_AliquotSize.R
\name{calc_AliquotSize}
\alias{calc_AliquotSize}
\title{Estimate the amount of grains on an aliquot}
\usage{
calc_AliquotSize(
  grain.size,
  sample.diameter,
  packing.density = 0.65,
  MC = TRUE,
  grains.counted = NULL,
  sample_carrier.diameter = 9.8,
  plot = TRUE,
  ...
)
}
\arguments{
\item{grain.size}{\link{numeric} (\strong{required}):
mean grain size (microns) or a range of grain sizes from which the
mean grain size is computed (e.g. \code{c(100,200)}).}

\item{sample.diameter}{\link{numeric} (\strong{required}):
diameter (mm) of the targeted area on the sample carrier.}

\item{packing.density}{\link{numeric} (\emph{with default}):
empirical value for the mean packing density. \cr
If \code{packing.density = Inf}, a hexagonal structure on an infinite
plane with a packing density of \eqn{\pi / \sqrt{12} \approx 0.9069}
is assumed.}

\item{MC}{\link{logical} (\emph{optional}):
if \code{TRUE} the function performs a Monte Carlo simulation for estimating the
amount of grains on the sample carrier and assumes random errors in grain
size distribution and packing density. Requires \code{grain.size} to be specified
as a 2-element vector with the range (min and max) of grain sizes.
For more information see details.}

\item{grains.counted}{\link{numeric} (\emph{optional}):
grains counted on a sample carrier. If a non-zero positive integer is
provided, this function will calculate the packing density of the aliquot.
If more than one value is provided, the mean packing density and its
standard deviation are calculated.
Note that this overrides \code{packing.density}.}

\item{sample_carrier.diameter}{\link{numeric} (\emph{with default}):
diameter (mm) of the sample carrier.}

\item{plot}{\link{logical} (\emph{with default}):
enable/disable the plot output.}

\item{...}{further arguments and graphical parameters to be passed. In
particular, \code{MC.iter} to control the number of Monte Carlo iterations,
\code{main}, \code{xlab}, \code{col}, \code{line_col}, \code{line_lwd}, \code{cex}, \code{rug} (\code{TRUE/FALSE}),
\code{boxplot} (\code{TRUE/FALSE}), \code{summary} (\code{TRUE/FALSE}), \code{legend} (\code{TRUE/FALSE}).}
}
\value{
Returns a terminal output. In addition an
\linkS4class{RLum.Results} object is returned containing the
following element:

\item{.$summary}{\link{data.frame} summary of all relevant calculation results.}
\item{.$args}{\link{list} used arguments}
\item{.$call}{\link{call} the function call}
\item{.$MC}{\link{list} results of the Monte Carlo simulation}

The output should be accessed using the function \link{get_RLum}.
}
\description{
This function can be used to either estimate the number of grains on an
aliquot or to compute the packing density, depending on the arguments
provided.

The following formula is used to estimate the number of grains \code{n}:

\deqn{n = (\pi*x^2)/(\pi*y^2)*d}

where \code{x} is the radius of the aliquot size (microns), \code{y} is the mean
radius of the mineral grains (mm), and \code{d} is the packing density
(a value between 0 and 1).

\strong{Packing density}

The default value for \code{packing.density} is 0.65, which is the mean of
empirical values determined by Heer et al. (2012) and unpublished data from
the Cologne luminescence laboratory. If \code{packing.density = Inf}, a maximum
density of \eqn{\pi / \sqrt{12} \approx 0.9069} is used. However, note that
this value is not appropriate as the standard preparation procedure of
aliquots resembles a PECC (\emph{Packing Equal Circles in a Circle}) problem,
where the maximum packing density is asymptotic to about 0.87.

\strong{Monte Carlo simulation}

The number of grains on an aliquot can be estimated by Monte Carlo simulation
when setting \code{MC = TRUE}. All parameters necessary to calculate
\code{n} (\code{x}, \code{y}, \code{d}) are assumed to be normally distributed with means
\eqn{\mu_x, \mu_y, \mu_d} and standard deviations \eqn{\sigma_x, \sigma_y, \sigma_d}.

For the mean grain size, random samples are taken first from
\eqn{N(\mu_y, \sigma_y)}, where \eqn{\mu_y = mean.grain.size} and
\eqn{\sigma_y = (max.grain.size-min.grain.size)/4}, so that 95\% of all
grains are within the provided the grain size range. This effectively takes
into account that after sieving the sample there is still a small chance of
having grains smaller or larger than the used mesh sizes. For each random
sample the mean grain size is calculated, from which random subsamples are
drawn for the Monte Carlo simulation.

The packing density is assumed
to be normally distributed with an empirically determined \eqn{\mu = 0.65}
(or provided value) and \eqn{\sigma = 0.18}. The normal distribution is
truncated at \code{d = 0.87} as this is approximately the maximum packing
density that can be achieved in a PECC problem.

The sample diameter has
\eqn{\mu = sample.diameter} and \eqn{\sigma = 0.2} to take into account
variations in sample disc preparation (i.e. applying silicon spray to the
disc). A lower truncation point at \code{x = 0.5} is used, which assumes
that aliquots with sample diameter smaller than 0.5 mm are discarded.
Likewise, the normal distribution is truncated at the diameter of the
sample carrier (9.8 mm by default, but controllable via the
\code{sample_carrier.diameter} argument).

For each random sample drawn from the
normal distribution, the amount of grains on the aliquot is calculated. By
default, \code{10^4} iterations are used, but the can be controlled with
option \code{MC.iter} (see \code{...}). Results are visualised in a bar- and
boxplot together with a statistical summary.
}
\section{Function version}{
 0.33
}

\examples{

## Estimate the amount of grains on a small aliquot
calc_AliquotSize(grain.size = c(100,150), sample.diameter = 1, MC.iter = 100)

## Calculate the mean packing density of large aliquots
calc_AliquotSize(grain.size = c(100,200), sample.diameter = 8,
                 grains.counted = c(2525,2312,2880), MC.iter = 100)

} 

\section{How to cite}{
Burow, C., Colombo, M., 2025. calc_AliquotSize(): Estimate the amount of grains on an aliquot. Function version 0.33. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.2. https://r-lum.github.io/Luminescence/
}

\references{
Duller, G.A.T., 2008. Single-grain optical dating of Quaternary
sediments: why aliquot size matters in luminescence dating. Boreas 37,
589-612.

Heer, A.J., Adamiec, G., Moska, P., 2012. How many grains
are there on a single aliquot?. Ancient TL 30, 9-16.

\strong{Further reading}

Chang, H.-C., Wang, L.-C., 2010. A simple proof of Thue's
Theorem on Circle Packing. \url{https://arxiv.org/pdf/1009.4322v1},
2013-09-13.

Graham, R.L., Lubachevsky, B.D., Nurmela, K.J.,
Oestergard, P.R.J., 1998.  Dense packings of congruent circles in a circle.
Discrete Mathematics 181, 139-154.

Huang, W., Ye, T., 2011. Global
optimization method for finding dense packings of equal circles in a circle.
European Journal of Operational Research 210, 474-481.
}
\author{
Christoph Burow, University of Cologne (Germany) \cr
Marco Colombo, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
