# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
import json
from typing import Any, Callable, IO, Optional, TypeVar, Union, overload

from azure.core import AsyncPipelineClient, MatchConditions
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceModifiedError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._operations._operations import (
    build_text_translation_get_supported_languages_request,
    build_text_translation_translate_request,
    build_text_translation_transliterate_request,
)
from ..._utils.model_base import SdkJSONEncoder, _deserialize, _failsafe_deserialize
from ..._utils.utils import ClientMixinABC
from ..._validation import api_version_validation
from .._configuration import TextTranslationClientConfiguration

JSON = MutableMapping[str, Any]
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, dict[str, Any]], Any]]


class _TextTranslationClientOperationsMixin(
    ClientMixinABC[AsyncPipelineClient[HttpRequest, AsyncHttpResponse], TextTranslationClientConfiguration]
):

    @distributed_trace_async
    async def get_supported_languages(
        self,
        *,
        client_trace_id: Optional[str] = None,
        scope: Optional[str] = None,
        accept_language: Optional[str] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.GetSupportedLanguagesResult:
        """Gets the set of languages currently supported by other operations of the Translator.

        Gets the set of languages currently supported by other operations of the Translator.

        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword scope: A comma-separated list of names defining the group of languages to return.
         Allowed group names are: ``translation``, ``transliteration`` and ``dictionary``.
         If no scope is given, then all groups are returned, which is equivalent to passing
         ``scope=translation,transliteration,dictionary``. To decide which set of supported languages
         is appropriate for your scenario, see the description of the `response object
         <#response-body>`_. Default value is None.
        :paramtype scope: str
        :keyword accept_language: The language to use for user interface strings. Some of the fields in
         the response are names of languages or
         names of regions. Use this parameter to define the language in which these names are returned.
         The language is specified by providing a well-formed BCP 47 language tag. For instance, use
         the value ``fr``
         to request names in French or use the value ``zh-Hant`` to request names in Chinese
         Traditional.
         Names are provided in the English language when a target language is not specified or when
         localization
         is not available. Default value is None.
        :paramtype accept_language: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: GetSupportedLanguagesResult. The GetSupportedLanguagesResult is compatible with
         MutableMapping
        :rtype: ~azure.ai.translation.text.models.GetSupportedLanguagesResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.GetSupportedLanguagesResult] = kwargs.pop("cls", None)

        _request = build_text_translation_get_supported_languages_request(
            client_trace_id=client_trace_id,
            scope=scope,
            accept_language=accept_language,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["X-RequestId"] = self._deserialize("str", response.headers.get("X-RequestId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.GetSupportedLanguagesResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def translate(
        self,
        body: _models.TranslateBody,
        *,
        client_trace_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TranslationResult:
        """Translate Text.

        Translate Text.

        :param body: Defines the content of the request. Required.
        :type body: ~azure.ai.translation.text.models.TranslateBody
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TranslationResult. The TranslationResult is compatible with MutableMapping
        :rtype: ~azure.ai.translation.text.models.TranslationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def translate(
        self,
        body: JSON,
        *,
        client_trace_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TranslationResult:
        """Translate Text.

        Translate Text.

        :param body: Defines the content of the request. Required.
        :type body: JSON
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TranslationResult. The TranslationResult is compatible with MutableMapping
        :rtype: ~azure.ai.translation.text.models.TranslationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def translate(
        self,
        body: IO[bytes],
        *,
        client_trace_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TranslationResult:
        """Translate Text.

        Translate Text.

        :param body: Defines the content of the request. Required.
        :type body: IO[bytes]
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TranslationResult. The TranslationResult is compatible with MutableMapping
        :rtype: ~azure.ai.translation.text.models.TranslationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    @api_version_validation(
        method_added_on="2025-10-01-preview",
        params_added_on={"2025-10-01-preview": ["client_trace_id", "api_version", "content_type", "accept"]},
        api_versions_list=["2025-10-01-preview"],
    )
    async def translate(
        self,
        body: Union[_models.TranslateBody, JSON, IO[bytes]],
        *,
        client_trace_id: Optional[str] = None,
        **kwargs: Any
    ) -> _models.TranslationResult:
        """Translate Text.

        Translate Text.

        :param body: Defines the content of the request. Is one of the following types: TranslateBody,
         JSON, IO[bytes] Required.
        :type body: ~azure.ai.translation.text.models.TranslateBody or JSON or IO[bytes]
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :return: TranslationResult. The TranslationResult is compatible with MutableMapping
        :rtype: ~azure.ai.translation.text.models.TranslationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TranslationResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_text_translation_translate_request(
            client_trace_id=client_trace_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["X-RequestId"] = self._deserialize("str", response.headers.get("X-RequestId"))
        response_headers["x-mt-system"] = self._deserialize("str", response.headers.get("x-mt-system"))
        response_headers["x-metered-usage"] = self._deserialize("int", response.headers.get("x-metered-usage"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TranslationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def transliterate(
        self,
        body: _models.TransliterateBody,
        *,
        language: str,
        from_script: str,
        to_script: str,
        client_trace_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TransliterateResult:
        """Transliterate Text.

        Transliterate Text.

        :param body: Defines the content of the request. Required.
        :type body: ~azure.ai.translation.text.models.TransliterateBody
        :keyword language: Specifies the language of the text to convert from one script to another.
         Possible languages are listed in the transliteration scope obtained by querying the service
         for its supported languages. Required.
        :paramtype language: str
        :keyword from_script: Specifies the script used by the input text. Look up supported languages
         using the transliteration scope,
         to find input scripts available for the selected language. Required.
        :paramtype from_script: str
        :keyword to_script: Specifies the output script. Look up supported languages using the
         transliteration scope, to find output
         scripts available for the selected combination of input language and input script. Required.
        :paramtype to_script: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TransliterateResult. The TransliterateResult is compatible with MutableMapping
        :rtype: ~azure.ai.translation.text.models.TransliterateResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def transliterate(
        self,
        body: JSON,
        *,
        language: str,
        from_script: str,
        to_script: str,
        client_trace_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TransliterateResult:
        """Transliterate Text.

        Transliterate Text.

        :param body: Defines the content of the request. Required.
        :type body: JSON
        :keyword language: Specifies the language of the text to convert from one script to another.
         Possible languages are listed in the transliteration scope obtained by querying the service
         for its supported languages. Required.
        :paramtype language: str
        :keyword from_script: Specifies the script used by the input text. Look up supported languages
         using the transliteration scope,
         to find input scripts available for the selected language. Required.
        :paramtype from_script: str
        :keyword to_script: Specifies the output script. Look up supported languages using the
         transliteration scope, to find output
         scripts available for the selected combination of input language and input script. Required.
        :paramtype to_script: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TransliterateResult. The TransliterateResult is compatible with MutableMapping
        :rtype: ~azure.ai.translation.text.models.TransliterateResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def transliterate(
        self,
        body: IO[bytes],
        *,
        language: str,
        from_script: str,
        to_script: str,
        client_trace_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TransliterateResult:
        """Transliterate Text.

        Transliterate Text.

        :param body: Defines the content of the request. Required.
        :type body: IO[bytes]
        :keyword language: Specifies the language of the text to convert from one script to another.
         Possible languages are listed in the transliteration scope obtained by querying the service
         for its supported languages. Required.
        :paramtype language: str
        :keyword from_script: Specifies the script used by the input text. Look up supported languages
         using the transliteration scope,
         to find input scripts available for the selected language. Required.
        :paramtype from_script: str
        :keyword to_script: Specifies the output script. Look up supported languages using the
         transliteration scope, to find output
         scripts available for the selected combination of input language and input script. Required.
        :paramtype to_script: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TransliterateResult. The TransliterateResult is compatible with MutableMapping
        :rtype: ~azure.ai.translation.text.models.TransliterateResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    @api_version_validation(
        method_added_on="2025-10-01-preview",
        params_added_on={
            "2025-10-01-preview": [
                "client_trace_id",
                "language",
                "from_script",
                "to_script",
                "api_version",
                "content_type",
                "accept",
            ]
        },
        api_versions_list=["2025-10-01-preview"],
    )
    async def transliterate(
        self,
        body: Union[_models.TransliterateBody, JSON, IO[bytes]],
        *,
        language: str,
        from_script: str,
        to_script: str,
        client_trace_id: Optional[str] = None,
        **kwargs: Any
    ) -> _models.TransliterateResult:
        """Transliterate Text.

        Transliterate Text.

        :param body: Defines the content of the request. Is one of the following types:
         TransliterateBody, JSON, IO[bytes] Required.
        :type body: ~azure.ai.translation.text.models.TransliterateBody or JSON or IO[bytes]
        :keyword language: Specifies the language of the text to convert from one script to another.
         Possible languages are listed in the transliteration scope obtained by querying the service
         for its supported languages. Required.
        :paramtype language: str
        :keyword from_script: Specifies the script used by the input text. Look up supported languages
         using the transliteration scope,
         to find input scripts available for the selected language. Required.
        :paramtype from_script: str
        :keyword to_script: Specifies the output script. Look up supported languages using the
         transliteration scope, to find output
         scripts available for the selected combination of input language and input script. Required.
        :paramtype to_script: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :return: TransliterateResult. The TransliterateResult is compatible with MutableMapping
        :rtype: ~azure.ai.translation.text.models.TransliterateResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TransliterateResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_text_translation_transliterate_request(
            language=language,
            from_script=from_script,
            to_script=to_script,
            client_trace_id=client_trace_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["X-RequestId"] = self._deserialize("str", response.headers.get("X-RequestId"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TransliterateResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore
