/* Generated by wayland-scanner 1.23.1 */

#ifndef UKUI_SHELL_CLIENT_PROTOCOL_H
#define UKUI_SHELL_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_ukui_shell The ukui_shell protocol
 * @section page_ifaces_ukui_shell Interfaces
 * - @subpage page_iface_ukui_shell - create ukui shell windows and helpers
 * - @subpage page_iface_ukui_surface - metadata interface
 * @section page_copyright_ukui_shell Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 KylinSoft Co., Ltd.
 * SPDX-FileCopyrightText: 2024 Hongfei Shang
 *
 * SPDX-License-Identifier: MulanPSL-2.0
 *
 * </pre>
 */
struct ukui_shell;
struct ukui_surface;
struct wl_output;
struct wl_seat;
struct wl_surface;

#ifndef UKUI_SHELL_INTERFACE
#define UKUI_SHELL_INTERFACE
/**
 * @page page_iface_ukui_shell ukui_shell
 * @section page_iface_ukui_shell_desc Description
 *
 * This interface is used by kylin powered Wayland shells to communicate with the compositor and
 * can only be bound one time.
 * @section page_iface_ukui_shell_api API
 * See @ref iface_ukui_shell.
 */
/**
 * @defgroup iface_ukui_shell The ukui_shell interface
 *
 * This interface is used by kylin powered Wayland shells to communicate with the compositor and
 * can only be bound one time.
 */
extern const struct wl_interface ukui_shell_interface;
#endif
#ifndef UKUI_SURFACE_INTERFACE
#define UKUI_SURFACE_INTERFACE
/**
 * @page page_iface_ukui_surface ukui_surface
 * @section page_iface_ukui_surface_desc Description
 *
 * An interface that may be implemented by a wl_surface, for implementations that provide the
 * shell user interface.
 *
 * It provides requests to set surface roles, assign an output or set the position in output
 * coordinates.
 *
 * On the server side the object is automatically destroyed when the related wl_surface is
 * destroyed. On client side, ukui_surface.destroy() must be called before destroying the
 * wl_surface object.
 * @section page_iface_ukui_surface_api API
 * See @ref iface_ukui_surface.
 */
/**
 * @defgroup iface_ukui_surface The ukui_surface interface
 *
 * An interface that may be implemented by a wl_surface, for implementations that provide the
 * shell user interface.
 *
 * It provides requests to set surface roles, assign an output or set the position in output
 * coordinates.
 *
 * On the server side the object is automatically destroyed when the related wl_surface is
 * destroyed. On client side, ukui_surface.destroy() must be called before destroying the
 * wl_surface object.
 */
extern const struct wl_interface ukui_surface_interface;
#endif

/**
 * @ingroup iface_ukui_shell
 * @struct ukui_shell_listener
 */
struct ukui_shell_listener {
	/**
	 * send the output name under cursor
	 *
	 * Emitted after bind ukui_shell or receive get_current_output
	 * request.
	 * @param output_name name of current output
	 * @param seat_name seat name of cursor under output
	 * @since 2
	 */
	void (*current_output)(void *data,
			       struct ukui_shell *ukui_shell,
			       const char *output_name,
			       const char *seat_name);
	/**
	 * sent all output and seat info completely
	 *
	 * This event is sent after all information has been sent after
	 * binding to the ukui shell object.
	 * @since 2
	 */
	void (*done)(void *data,
		     struct ukui_shell *ukui_shell);
};

/**
 * @ingroup iface_ukui_shell
 */
static inline int
ukui_shell_add_listener(struct ukui_shell *ukui_shell,
			const struct ukui_shell_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ukui_shell,
				     (void (**)(void)) listener, data);
}

#define UKUI_SHELL_CREATE_SURFACE 0
#define UKUI_SHELL_GET_CURRENT_OUTPUT 1

/**
 * @ingroup iface_ukui_shell
 */
#define UKUI_SHELL_CURRENT_OUTPUT_SINCE_VERSION 2
/**
 * @ingroup iface_ukui_shell
 */
#define UKUI_SHELL_DONE_SINCE_VERSION 2

/**
 * @ingroup iface_ukui_shell
 */
#define UKUI_SHELL_CREATE_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_shell
 */
#define UKUI_SHELL_GET_CURRENT_OUTPUT_SINCE_VERSION 2

/** @ingroup iface_ukui_shell */
static inline void
ukui_shell_set_user_data(struct ukui_shell *ukui_shell, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ukui_shell, user_data);
}

/** @ingroup iface_ukui_shell */
static inline void *
ukui_shell_get_user_data(struct ukui_shell *ukui_shell)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ukui_shell);
}

static inline uint32_t
ukui_shell_get_version(struct ukui_shell *ukui_shell)
{
	return wl_proxy_get_version((struct wl_proxy *) ukui_shell);
}

/** @ingroup iface_ukui_shell */
static inline void
ukui_shell_destroy(struct ukui_shell *ukui_shell)
{
	wl_proxy_destroy((struct wl_proxy *) ukui_shell);
}

/**
 * @ingroup iface_ukui_shell
 *
 * Create a shell surface for an existing surface.
 *
 * Only one shell surface can be associated with a given surface.
 */
static inline struct ukui_surface *
ukui_shell_create_surface(struct ukui_shell *ukui_shell, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) ukui_shell,
			 UKUI_SHELL_CREATE_SURFACE, &ukui_surface_interface, wl_proxy_get_version((struct wl_proxy *) ukui_shell), 0, NULL, surface);

	return (struct ukui_surface *) id;
}

/**
 * @ingroup iface_ukui_shell
 *
 * Request get the output under cursor.
 *
 * Send current_output and done event after this request.
 */
static inline void
ukui_shell_get_current_output(struct ukui_shell *ukui_shell)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_shell,
			 UKUI_SHELL_GET_CURRENT_OUTPUT, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_shell), 0);
}

#ifndef UKUI_SURFACE_PROPERTY_ENUM
#define UKUI_SURFACE_PROPERTY_ENUM
enum ukui_surface_property {
	UKUI_SURFACE_PROPERTY_NO_TITLEBAR = 0,
	UKUI_SURFACE_PROPERTY_THEME = 1,
	UKUI_SURFACE_PROPERTY_WINDOW_RADIUS = 2,
	UKUI_SURFACE_PROPERTY_BORDER_WIDTH = 3,
	UKUI_SURFACE_PROPERTY_BORDER_COLOR = 4,
	UKUI_SURFACE_PROPERTY_SHADOW_RADIUS = 5,
	UKUI_SURFACE_PROPERTY_SHADOW_OFFSET = 6,
	UKUI_SURFACE_PROPERTY_SHADOW_COLOR = 7,
};
#endif /* UKUI_SURFACE_PROPERTY_ENUM */

#ifndef UKUI_SURFACE_ROLE_ENUM
#define UKUI_SURFACE_ROLE_ENUM
enum ukui_surface_role {
	UKUI_SURFACE_ROLE_NORMAL = 0,
	UKUI_SURFACE_ROLE_DESKTOP = 1,
	UKUI_SURFACE_ROLE_PANEL = 2,
	UKUI_SURFACE_ROLE_ONSCREENDISPLAY = 3,
	UKUI_SURFACE_ROLE_NOTIFICATION = 4,
	UKUI_SURFACE_ROLE_TOOLTIP = 5,
	UKUI_SURFACE_ROLE_CRITICALNOTIFICATION = 6,
	UKUI_SURFACE_ROLE_APPLETPOPUP = 7,
	UKUI_SURFACE_ROLE_SCREENLOCK = 8,
	UKUI_SURFACE_ROLE_WATERMARK = 9,
	UKUI_SURFACE_ROLE_SYSTEMWINDOW = 10,
	UKUI_SURFACE_ROLE_INPUTPANEL = 11,
	UKUI_SURFACE_ROLE_LOGOUT = 12,
	UKUI_SURFACE_ROLE_SCREENLOCKNOTIFICATION = 13,
	UKUI_SURFACE_ROLE_SWITCHER = 14,
	UKUI_SURFACE_ROLE_AUTHENTICATION = 15,
};
#endif /* UKUI_SURFACE_ROLE_ENUM */

/**
 * @ingroup iface_ukui_surface
 * @struct ukui_surface_listener
 */
struct ukui_surface_listener {
	/**
	 * informs of a new position for the window
	 *
	 * This event informs the client that the position of the window
	 * is about to change.
	 * @param x the horizontal position of the window
	 * @param y the vertical position of the window
	 * @since 3
	 */
	void (*position)(void *data,
			 struct ukui_surface *ukui_surface,
			 int32_t x,
			 int32_t y);
};

/**
 * @ingroup iface_ukui_surface
 */
static inline int
ukui_surface_add_listener(struct ukui_surface *ukui_surface,
			  const struct ukui_surface_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ukui_surface,
				     (void (**)(void)) listener, data);
}

#define UKUI_SURFACE_DESTROY 0
#define UKUI_SURFACE_SET_OUTPUT 1
#define UKUI_SURFACE_SET_POSITION 2
#define UKUI_SURFACE_SET_SKIP_TASKBAR 3
#define UKUI_SURFACE_SET_SKIP_SWITCHER 4
#define UKUI_SURFACE_SET_PROPERTY 5
#define UKUI_SURFACE_SET_ROLE 6
#define UKUI_SURFACE_SET_PANEL_AUTO_HIDE 7
#define UKUI_SURFACE_OPEN_UNDER_CURSOR 8
#define UKUI_SURFACE_SET_PANEL_TAKES_FOCUS 9
#define UKUI_SURFACE_GRAB_KEYBOARD 10
#define UKUI_SURFACE_SET_ICON 11
#define UKUI_SURFACE_ACTIVATE 12

/**
 * @ingroup iface_ukui_surface
 */
#define UKUI_SURFACE_POSITION_SINCE_VERSION 3

/**
 * @ingroup iface_ukui_surface
 */
#define UKUI_SURFACE_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface
 */
#define UKUI_SURFACE_SET_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface
 */
#define UKUI_SURFACE_SET_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface
 */
#define UKUI_SURFACE_SET_SKIP_TASKBAR_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface
 */
#define UKUI_SURFACE_SET_SKIP_SWITCHER_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface
 */
#define UKUI_SURFACE_SET_PROPERTY_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface
 */
#define UKUI_SURFACE_SET_ROLE_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface
 */
#define UKUI_SURFACE_SET_PANEL_AUTO_HIDE_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface
 */
#define UKUI_SURFACE_OPEN_UNDER_CURSOR_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface
 */
#define UKUI_SURFACE_SET_PANEL_TAKES_FOCUS_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface
 */
#define UKUI_SURFACE_GRAB_KEYBOARD_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface
 */
#define UKUI_SURFACE_SET_ICON_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_surface
 */
#define UKUI_SURFACE_ACTIVATE_SINCE_VERSION 4

/** @ingroup iface_ukui_surface */
static inline void
ukui_surface_set_user_data(struct ukui_surface *ukui_surface, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ukui_surface, user_data);
}

/** @ingroup iface_ukui_surface */
static inline void *
ukui_surface_get_user_data(struct ukui_surface *ukui_surface)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ukui_surface);
}

static inline uint32_t
ukui_surface_get_version(struct ukui_surface *ukui_surface)
{
	return wl_proxy_get_version((struct wl_proxy *) ukui_surface);
}

/**
 * @ingroup iface_ukui_surface
 *
 * The ukui_surface interface is removed from the wl_surface object that was turned into a
 * shell surface with the ukui_shell.get_surface request. The shell surface role is lost
 * and wl_surface is unmapped.
 */
static inline void
ukui_surface_destroy(struct ukui_surface *ukui_surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface,
			 UKUI_SURFACE_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_ukui_surface
 *
 * Assign an output to this shell surface. The compositor will use this information to set the
 * position when ukui_surface.set_position request is called.
 */
static inline void
ukui_surface_set_output(struct ukui_surface *ukui_surface, struct wl_output *output)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface,
			 UKUI_SURFACE_SET_OUTPUT, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface), 0, output);
}

/**
 * @ingroup iface_ukui_surface
 *
 * Move the surface to new coordinates.
 *
 * Coordinates are global, for example 50,50 for a 1920,0+1920x1080 output is 1970,50 in global
 * coordinates space.
 */
static inline void
ukui_surface_set_position(struct ukui_surface *ukui_surface, int32_t x, int32_t y)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface,
			 UKUI_SURFACE_SET_POSITION, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface), 0, x, y);
}

/**
 * @ingroup iface_ukui_surface
 *
 * Setting this bit to the window, will make it say it prefers to not be listed in the taskbar.
 * Taskbar implementations may or may not follow this hint.
 */
static inline void
ukui_surface_set_skip_taskbar(struct ukui_surface *ukui_surface, uint32_t skip)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface,
			 UKUI_SURFACE_SET_SKIP_TASKBAR, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface), 0, skip);
}

/**
 * @ingroup iface_ukui_surface
 *
 * Setting this bit will indicate that the window prefers not to be listed in a switcher.
 */
static inline void
ukui_surface_set_skip_switcher(struct ukui_surface *ukui_surface, uint32_t skip)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface,
			 UKUI_SURFACE_SET_SKIP_SWITCHER, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface), 0, skip);
}

/**
 * @ingroup iface_ukui_surface
 *
 * Set window property.
 *
 * Values for property argument are described by ukui_shell.property
 * and can be used together in a bitfield. The flags bitfield describes which property are
 * supposed to be set.
 */
static inline void
ukui_surface_set_property(struct ukui_surface *ukui_surface, uint32_t property, uint32_t value)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface,
			 UKUI_SURFACE_SET_PROPERTY, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface), 0, property, value);
}

/**
 * @ingroup iface_ukui_surface
 *
 * Assign a role to a shell surface.
 *
 * The compositor handles surfaces depending on their role. See the explanation below.
 *
 * This request fails if the surface already has a role, this means the surface role may be
 * assigned only once.
 */
static inline void
ukui_surface_set_role(struct ukui_surface *ukui_surface, uint32_t role)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface,
			 UKUI_SURFACE_SET_ROLE, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface), 0, role);
}

/**
 * @ingroup iface_ukui_surface
 *
 * Setting this bit will indicate that the panel area not to be calculate in output usable area.
 */
static inline void
ukui_surface_set_panel_auto_hide(struct ukui_surface *ukui_surface, uint32_t hide)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface,
			 UKUI_SURFACE_SET_PANEL_AUTO_HIDE, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface), 0, hide);
}

/**
 * @ingroup iface_ukui_surface
 *
 * Request the initial position of this surface to be under the current cursor position. Has to
 * be called before attaching any buffer to this surface.
 */
static inline void
ukui_surface_open_under_cursor(struct ukui_surface *ukui_surface, int32_t x, int32_t y)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface,
			 UKUI_SURFACE_OPEN_UNDER_CURSOR, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface), 0, x, y);
}

/**
 * @ingroup iface_ukui_surface
 *
 * By default various ukui_surface roles do not take focus and cannot be activated.
 * With this request the compositor can be instructed to pass focus also to this ukui_surface.
 */
static inline void
ukui_surface_set_panel_takes_focus(struct ukui_surface *ukui_surface, uint32_t takes_focus)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface,
			 UKUI_SURFACE_SET_PANEL_TAKES_FOCUS, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface), 0, takes_focus);
}

/**
 * @ingroup iface_ukui_surface
 *
 * This request makes the created surface take an explicit keyboard grab.
 * This keyboard grab will be dismissed when the client destroys the surface.
 * Grab all keyboard when seat is set to null.
 */
static inline void
ukui_surface_grab_keyboard(struct ukui_surface *ukui_surface, struct wl_seat *seat)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface,
			 UKUI_SURFACE_GRAB_KEYBOARD, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface), 0, seat);
}

/**
 * @ingroup iface_ukui_surface
 *
 * Setting server decoration icon by icon name.
 * Set icon name to null will use app_id to find icon.
 */
static inline void
ukui_surface_set_icon(struct ukui_surface *ukui_surface, const char *icon_name)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface,
			 UKUI_SURFACE_SET_ICON, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface), 0, icon_name);
}

/**
 * @ingroup iface_ukui_surface
 *
 * This request makes the created surface to be activated.
 * There is no guarantee the surface will be actually activated, and behaviour
 * may be compositor-dependentption.
 */
static inline void
ukui_surface_activate(struct ukui_surface *ukui_surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_surface,
			 UKUI_SURFACE_ACTIVATE, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_surface), 0);
}

#ifdef  __cplusplus
}
#endif

#endif
