/* SPDX-FileCopyrightText: 2013 - Sébastien Wilmet <swilmet@gnome.org>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#include <gtk/gtk.h>
#include <gtksourceview/gtksource.h>
#include "gtksourceview/completion-providers/words/gtksourcecompletionwordslibrary.h"

static void
library_add_words (GtkSourceCompletionWordsLibrary *library)
{
	gtk_source_completion_words_library_add_word (library, "bb");
	gtk_source_completion_words_library_add_word (library, "bbc");
	gtk_source_completion_words_library_add_word (library, "bbd");
	gtk_source_completion_words_library_add_word (library, "dd");
	gtk_source_completion_words_library_add_word (library, "dde");
	gtk_source_completion_words_library_add_word (library, "ddf");
}

static void
test_library_find (void)
{
	GtkSourceCompletionWordsLibrary *library = gtk_source_completion_words_library_new ();
	GtkSourceCompletionWordsProposal *proposal;
	GSequenceIter *iter;
	const gchar *word;

	library_add_words (library);

	iter = gtk_source_completion_words_library_find_first (library, "a", -1);
	g_assert (iter == NULL);

	iter = gtk_source_completion_words_library_find_first (library, "bba", -1);
	g_assert (iter == NULL);

	iter = gtk_source_completion_words_library_find_first (library, "b", -1);
	g_assert (iter != NULL);

	proposal = gtk_source_completion_words_library_get_proposal (iter);
	word = gtk_source_completion_words_proposal_get_word (proposal);
	g_assert_cmpstr (word, ==, "bb");

	iter = gtk_source_completion_words_library_find_first (library, "dd", -1);
	g_assert (iter != NULL);

	proposal = gtk_source_completion_words_library_get_proposal (iter);
	word = gtk_source_completion_words_proposal_get_word (proposal);
	g_assert_cmpstr (word, ==, "dd");

	g_object_unref (library);
}

int
main (int    argc,
      char **argv)
{
	gint ret;

	gtk_test_init (&argc, &argv);
	gtk_source_init ();

	g_test_add_func ("/CompletionWords/library/find",
			 test_library_find);

	ret = g_test_run ();
	gtk_source_finalize ();

	return ret;
}
