/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2019 - 2021
 *
 * Richard van Schagen <vschagen@icloud.com>
 * Christian Marangi <ansuelsmth@gmail.com
 */
#ifndef REG_EIP93_H
#define REG_EIP93_H

#define EIP93_REG_PE_CTRL_STAT			0x0
#define   EIP93_PE_CTRL_PE_PAD_CTRL_STAT	GENMASK(31, 24)
#define   EIP93_PE_CTRL_PE_EXT_ERR_CODE		GENMASK(23, 20)
#define   EIP93_PE_CTRL_PE_EXT_ERR_PROCESSING	0x8
#define   EIP93_PE_CTRL_PE_EXT_ERR_BLOCK_SIZE_ERR 0x7
#define   EIP93_PE_CTRL_PE_EXT_ERR_INVALID_PK_LENGTH 0x6
#define   EIP93_PE_CTRL_PE_EXT_ERR_ZERO_LENGTH	0x5
#define   EIP93_PE_CTRL_PE_EXT_ERR_SPI		0x4
#define   EIP93_PE_CTRL_PE_EXT_ERR_INVALID_CRYPTO_ALGO 0x3
#define   EIP93_PE_CTRL_PE_EXT_ERR_INVALID_CRYPTO_OP 0x2
#define   EIP93_PE_CTRL_PE_EXT_ERR_DESC_OWNER	0x1
#define   EIP93_PE_CTRL_PE_EXT_ERR_BUS		0x0
#define   EIP93_PE_CTRL_PE_EXT_ERR		BIT(19)
#define   EIP93_PE_CTRL_PE_SEQNUM_ERR		BIT(18)
#define   EIP93_PE_CTRL_PE_PAD_ERR		BIT(17)
#define   EIP93_PE_CTRL_PE_AUTH_ERR		BIT(16)
#define   EIP93_PE_CTRL_PE_PAD_VALUE		GENMASK(15, 8)
#define   EIP93_PE_CTRL_PE_PRNG_MODE		GENMASK(7, 6)
#define   EIP93_PE_CTRL_PE_HASH_FINAL		BIT(4)
#define   EIP93_PE_CTRL_PE_INIT_ARC4		BIT(3)
#define   EIP93_PE_CTRL_PE_READY_DES_TRING_OWN	GENMASK(1, 0)
#define   EIP93_PE_CTRL_PE_READY		0x2
#define   EIP93_PE_CTRL_HOST_READY		0x1
#define EIP93_REG_PE_SOURCE_ADDR		0x4
#define EIP93_REG_PE_DEST_ADDR			0x8
#define EIP93_REG_PE_SA_ADDR			0xc
#define EIP93_REG_PE_ADDR			0x10 /* STATE_ADDR */
/*
 * Special implementation for user ID
 * user_id in eip93_descriptor is used to identify the
 * descriptor and is opaque and can be used by the driver
 * in custom way.
 *
 * The usage of this should be to put an address to the crypto
 * request struct from the kernel but this can't work in 64bit
 * world.
 *
 * Also it's required to put some flags to identify the last
 * descriptor.
 *
 * To handle this, split the u32 in 2 part:
 * - 31:16 descriptor flags
 * - 15:0 IDR to connect the crypto request address
 */
#define EIP93_REG_PE_USER_ID			0x18
#define   EIP93_PE_USER_ID_DESC_FLAGS		GENMASK(31, 16)
#define   EIP93_PE_USER_ID_CRYPTO_IDR		GENMASK(15, 0)
#define EIP93_REG_PE_LENGTH			0x1c
#define   EIP93_PE_LENGTH_BYPASS		GENMASK(31, 24)
#define   EIP93_PE_LENGTH_HOST_PE_READY		GENMASK(23, 22)
#define   EIP93_PE_LENGTH_PE_READY		0x2
#define   EIP93_PE_LENGTH_HOST_READY		0x1
#define   EIP93_PE_LENGTH_LENGTH		GENMASK(19, 0)

/* PACKET ENGINE RING configuration registers */
#define EIP93_REG_PE_CDR_BASE			0x80
#define EIP93_REG_PE_RDR_BASE			0x84
#define EIP93_REG_PE_RING_CONFIG		0x88
#define   EIP93_PE_EN_EXT_TRIG			BIT(31)
/* Absent in later revision of eip93 */
/* #define   EIP93_PE_RING_OFFSET		GENMASK(23, 15) */
#define   EIP93_PE_RING_SIZE			GENMASK(9, 0)
#define EIP93_REG_PE_RING_THRESH		0x8c
#define   EIPR93_PE_TIMEROUT_EN			BIT(31)
#define   EIPR93_PE_RD_TIMEOUT			GENMASK(29, 26)
#define   EIPR93_PE_RDR_THRESH			GENMASK(25, 16)
#define   EIPR93_PE_CDR_THRESH			GENMASK(9, 0)
#define EIP93_REG_PE_CD_COUNT			0x90
#define   EIP93_PE_CD_COUNT			GENMASK(10, 0)
/*
 * In the same register, writing a value in GENMASK(7, 0) will
 * increment the descriptor count and start DMA action.
 */
#define   EIP93_PE_CD_COUNT_INCR		GENMASK(7, 0)
#define EIP93_REG_PE_RD_COUNT			0x94
#define   EIP93_PE_RD_COUNT			GENMASK(10, 0)
/*
 * In the same register, writing a value in GENMASK(7, 0) will
 * increment the descriptor count and start DMA action.
 */
#define   EIP93_PE_RD_COUNT_INCR		GENMASK(7, 0)
#define EIP93_REG_PE_RING_RW_PNTR		0x98 /* RING_PNTR */

/* PACKET ENGINE  configuration registers */
#define EIP93_REG_PE_CONFIG			0x100
#define   EIP93_PE_CONFIG_SWAP_TARGET		BIT(20)
#define   EIP93_PE_CONFIG_SWAP_DATA		BIT(18)
#define   EIP93_PE_CONFIG_SWAP_SA		BIT(17)
#define   EIP93_PE_CONFIG_SWAP_CDRD		BIT(16)
#define   EIP93_PE_CONFIG_EN_CDR_UPDATE		BIT(10)
#define   EIP93_PE_CONFIG_PE_MODE		GENMASK(9, 8)
#define   EIP93_PE_TARGET_AUTO_RING_MODE	FIELD_PREP(EIP93_PE_CONFIG_PE_MODE, 0x3)
#define   EIP93_PE_TARGET_COMMAND_NO_RDR_MODE	FIELD_PREP(EIP93_PE_CONFIG_PE_MODE, 0x2)
#define   EIP93_PE_TARGET_COMMAND_WITH_RDR_MODE	FIELD_PREP(EIP93_PE_CONFIG_PE_MODE, 0x1)
#define   EIP93_PE_DIRECT_HOST_MODE		FIELD_PREP(EIP93_PE_CONFIG_PE_MODE, 0x0)
#define   EIP93_PE_CONFIG_RST_RING		BIT(2)
#define   EIP93_PE_CONFIG_RST_PE		BIT(0)
#define EIP93_REG_PE_STATUS			0x104
#define EIP93_REG_PE_BUF_THRESH			0x10c
#define   EIP93_PE_OUTBUF_THRESH		GENMASK(23, 16)
#define   EIP93_PE_INBUF_THRESH			GENMASK(7, 0)
#define EIP93_REG_PE_INBUF_COUNT		0x100
#define EIP93_REG_PE_OUTBUF_COUNT		0x114
#define EIP93_REG_PE_BUF_RW_PNTR		0x118 /* BUF_PNTR */

/* PACKET ENGINE endian config */
#define EIP93_REG_PE_ENDIAN_CONFIG		0x1cc
#define EIP93_AIROHA_REG_PE_ENDIAN_CONFIG	0x1d0
#define   EIP93_PE_ENDIAN_TARGET_BYTE_SWAP	GENMASK(23, 16)
#define   EIP93_PE_ENDIAN_MASTER_BYTE_SWAP	GENMASK(7, 0)
/*
 * Byte goes 2 and 2 and are referenced by ID
 * Split GENMASK(7, 0) in 4 part, one for each byte.
 * Example LITTLE ENDIAN: Example BIG ENDIAN
 * GENMASK(7, 6) 0x3	  GENMASK(7, 6) 0x0
 * GENMASK(5, 4) 0x2	  GENMASK(7, 6) 0x1
 * GENMASK(3, 2) 0x1	  GENMASK(3, 2) 0x2
 * GENMASK(1, 0) 0x0	  GENMASK(1, 0) 0x3
 */
#define   EIP93_PE_ENDIAN_BYTE0			0x0
#define   EIP93_PE_ENDIAN_BYTE1			0x1
#define   EIP93_PE_ENDIAN_BYTE2			0x2
#define   EIP93_PE_ENDIAN_BYTE3			0x3

/* EIP93 CLOCK control registers */
#define EIP93_REG_PE_CLOCK_CTRL			0x1e8
#define   EIP93_PE_CLOCK_EN_HASH_CLK		BIT(4)
#define   EIP93_PE_CLOCK_EN_ARC4_CLK		BIT(3)
#define   EIP93_PE_CLOCK_EN_AES_CLK		BIT(2)
#define   EIP93_PE_CLOCK_EN_DES_CLK		BIT(1)
#define   EIP93_PE_CLOCK_EN_PE_CLK		BIT(0)

/* EIP93 Device Option and Revision Register */
#define EIP93_REG_PE_OPTION_1			0x1f4
#define   EIP93_PE_OPTION_MAC_KEY256		BIT(31)
#define   EIP93_PE_OPTION_MAC_KEY192		BIT(30)
#define   EIP93_PE_OPTION_MAC_KEY128		BIT(29)
#define   EIP93_PE_OPTION_AES_CBC_MAC		BIT(28)
#define   EIP93_PE_OPTION_AES_XCBX		BIT(23)
#define   EIP93_PE_OPTION_SHA_256		BIT(19)
#define   EIP93_PE_OPTION_SHA_224		BIT(18)
#define   EIP93_PE_OPTION_SHA_1			BIT(17)
#define   EIP93_PE_OPTION_MD5			BIT(16)
#define   EIP93_PE_OPTION_AES_KEY256		BIT(15)
#define   EIP93_PE_OPTION_AES_KEY192		BIT(14)
#define   EIP93_PE_OPTION_AES_KEY128		BIT(13)
#define   EIP93_PE_OPTION_AES			BIT(2)
#define   EIP93_PE_OPTION_ARC4			BIT(1)
#define   EIP93_PE_OPTION_TDES			BIT(0) /* DES and TDES */
#define EIP93_REG_PE_OPTION_0			0x1f8
#define EIP93_REG_PE_REVISION			0x1fc
#define   EIP93_PE_REVISION_MAJ_HW_REV		GENMASK(27, 24)
#define   EIP93_PE_REVISION_MIN_HW_REV		GENMASK(23, 20)
#define   EIP93_PE_REVISION_HW_PATCH		GENMASK(19, 16)
#define   EIP93_PE_REVISION_EIP_NO		GENMASK(7, 0)

/* EIP93 Interrupt Control Register */
#define EIP93_REG_INT_UNMASK_STAT		0x200
#define EIP93_REG_INT_MASK_STAT			0x204
#define EIP93_REG_INT_CLR			0x204
#define EIP93_REG_INT_MASK			0x208 /* INT_EN */
/* Each int reg have the same bitmap */
#define   EIP93_INT_INTERFACE_ERR		BIT(18)
#define   EIP93_INT_RPOC_ERR			BIT(17)
#define   EIP93_INT_PE_RING_ERR			BIT(16)
#define   EIP93_INT_HALT			BIT(15)
#define   EIP93_INT_OUTBUF_THRESH		BIT(11)
#define   EIP93_INT_INBUF_THRESH		BIT(10)
#define   EIP93_INT_OPERATION_DONE		BIT(9)
#define   EIP93_INT_RDR_THRESH			BIT(1)
#define   EIP93_INT_CDR_THRESH			BIT(0)
#define   EIP93_INT_ALL				(EIP93_INT_INTERFACE_ERR | \
						 EIP93_INT_RPOC_ERR | \
						 EIP93_INT_PE_RING_ERR | \
						 EIP93_INT_HALT | \
						 EIP93_INT_OUTBUF_THRESH | \
						 EIP93_INT_INBUF_THRESH | \
						 EIP93_INT_OPERATION_DONE | \
						 EIP93_INT_RDR_THRESH | \
						 EIP93_INT_CDR_THRESH)

#define EIP93_REG_INT_CFG			0x20c
#define   EIP93_INT_TYPE_PULSE			BIT(0)
#define EIP93_REG_MASK_ENABLE			0x210
#define EIP93_REG_MASK_DISABLE			0x214

/* EIP93 SA Record register */
#define EIP93_REG_SA_CMD_0			0x400
#define   EIP93_SA_CMD_SAVE_HASH		BIT(29)
#define   EIP93_SA_CMD_SAVE_IV			BIT(28)
#define   EIP93_SA_CMD_HASH_SOURCE		GENMASK(27, 26)
#define   EIP93_SA_CMD_HASH_NO_LOAD		FIELD_PREP(EIP93_SA_CMD_HASH_SOURCE, 0x3)
#define   EIP93_SA_CMD_HASH_FROM_STATE		FIELD_PREP(EIP93_SA_CMD_HASH_SOURCE, 0x2)
#define   EIP93_SA_CMD_HASH_FROM_SA		FIELD_PREP(EIP93_SA_CMD_HASH_SOURCE, 0x0)
#define   EIP93_SA_CMD_IV_SOURCE		GENMASK(25, 24)
#define   EIP93_SA_CMD_IV_FROM_PRNG		FIELD_PREP(EIP93_SA_CMD_IV_SOURCE, 0x3)
#define   EIP93_SA_CMD_IV_FROM_STATE		FIELD_PREP(EIP93_SA_CMD_IV_SOURCE, 0x2)
#define   EIP93_SA_CMD_IV_FROM_INPUT		FIELD_PREP(EIP93_SA_CMD_IV_SOURCE, 0x1)
#define   EIP93_SA_CMD_IV_NO_LOAD		FIELD_PREP(EIP93_SA_CMD_IV_SOURCE, 0x0)
#define   EIP93_SA_CMD_DIGEST_LENGTH		GENMASK(23, 20)
#define   EIP93_SA_CMD_DIGEST_10WORD		FIELD_PREP(EIP93_SA_CMD_DIGEST_LENGTH, 0xa) /* SRTP and TLS */
#define   EIP93_SA_CMD_DIGEST_8WORD		FIELD_PREP(EIP93_SA_CMD_DIGEST_LENGTH, 0x8) /* SHA-256 */
#define   EIP93_SA_CMD_DIGEST_7WORD		FIELD_PREP(EIP93_SA_CMD_DIGEST_LENGTH, 0x7) /* SHA-224 */
#define   EIP93_SA_CMD_DIGEST_6WORD		FIELD_PREP(EIP93_SA_CMD_DIGEST_LENGTH, 0x6)
#define   EIP93_SA_CMD_DIGEST_5WORD		FIELD_PREP(EIP93_SA_CMD_DIGEST_LENGTH, 0x5) /* SHA1 */
#define   EIP93_SA_CMD_DIGEST_4WORD		FIELD_PREP(EIP93_SA_CMD_DIGEST_LENGTH, 0x4) /* MD5 and AES-based */
#define   EIP93_SA_CMD_DIGEST_3WORD_IPSEC	FIELD_PREP(EIP93_SA_CMD_DIGEST_LENGTH, 0x3) /* IPSEC */
#define   EIP93_SA_CMD_DIGEST_2WORD		FIELD_PREP(EIP93_SA_CMD_DIGEST_LENGTH, 0x2)
#define   EIP93_SA_CMD_DIGEST_1WORD		FIELD_PREP(EIP93_SA_CMD_DIGEST_LENGTH, 0x1)
#define   EIP93_SA_CMD_DIGEST_3WORD		FIELD_PREP(EIP93_SA_CMD_DIGEST_LENGTH, 0x0) /* 96bit output */
#define   EIP93_SA_CMD_HDR_PROC			BIT(19)
#define   EIP93_SA_CMD_EXT_PAD			BIT(18)
#define   EIP93_SA_CMD_SCPAD			BIT(17)
#define   EIP93_SA_CMD_HASH			GENMASK(15, 12)
#define   EIP93_SA_CMD_HASH_NULL		FIELD_PREP(EIP93_SA_CMD_HASH, 0xf)
#define   EIP93_SA_CMD_HASH_SHA256		FIELD_PREP(EIP93_SA_CMD_HASH, 0x3)
#define   EIP93_SA_CMD_HASH_SHA224		FIELD_PREP(EIP93_SA_CMD_HASH, 0x2)
#define   EIP93_SA_CMD_HASH_SHA1		FIELD_PREP(EIP93_SA_CMD_HASH, 0x1)
#define   EIP93_SA_CMD_HASH_MD5			FIELD_PREP(EIP93_SA_CMD_HASH, 0x0)
#define   EIP93_SA_CMD_CIPHER			GENMASK(11, 8)
#define   EIP93_SA_CMD_CIPHER_NULL		FIELD_PREP(EIP93_SA_CMD_CIPHER, 0xf)
#define   EIP93_SA_CMD_CIPHER_AES		FIELD_PREP(EIP93_SA_CMD_CIPHER, 0x3)
#define   EIP93_SA_CMD_CIPHER_ARC4		FIELD_PREP(EIP93_SA_CMD_CIPHER, 0x2)
#define   EIP93_SA_CMD_CIPHER_3DES		FIELD_PREP(EIP93_SA_CMD_CIPHER, 0x1)
#define   EIP93_SA_CMD_CIPHER_DES		FIELD_PREP(EIP93_SA_CMD_CIPHER, 0x0)
#define   EIP93_SA_CMD_PAD_TYPE			GENMASK(7, 6)
#define   EIP93_SA_CMD_PAD_CONST_SSL		FIELD_PREP(EIP93_SA_CMD_PAD_TYPE, 0x6)
#define   EIP93_SA_CMD_PAD_TLS_DTLS		FIELD_PREP(EIP93_SA_CMD_PAD_TYPE, 0x5)
#define   EIP93_SA_CMD_PAD_ZERO			FIELD_PREP(EIP93_SA_CMD_PAD_TYPE, 0x3)
#define   EIP93_SA_CMD_PAD_CONST		FIELD_PREP(EIP93_SA_CMD_PAD_TYPE, 0x2)
#define   EIP93_SA_CMD_PAD_PKCS7		FIELD_PREP(EIP93_SA_CMD_PAD_TYPE, 0x1)
#define   EIP93_SA_CMD_PAD_IPSEC		FIELD_PREP(EIP93_SA_CMD_PAD_TYPE, 0x0)
#define   EIP93_SA_CMD_OPGROUP			GENMASK(5, 4)
#define   EIP93_SA_CMD_OP_EXT			FIELD_PREP(EIP93_SA_CMD_OPGROUP, 0x2)
#define   EIP93_SA_CMD_OP_PROTOCOL		FIELD_PREP(EIP93_SA_CMD_OPGROUP, 0x1)
#define   EIP93_SA_CMD_OP_BASIC			FIELD_PREP(EIP93_SA_CMD_OPGROUP, 0x0)
#define   EIP93_SA_CMD_DIRECTION_IN		BIT(3) /* 0: outbount 1: inbound */
#define   EIP93_SA_CMD_OPCODE			GENMASK(2, 0)
#define   EIP93_SA_CMD_OPCODE_BASIC_OUT_PRNG	0x7
#define   EIP93_SA_CMD_OPCODE_BASIC_OUT_HASH	0x3
#define   EIP93_SA_CMD_OPCODE_BASIC_OUT_ENC_HASH 0x1
#define   EIP93_SA_CMD_OPCODE_BASIC_OUT_ENC	0x0
#define   EIP93_SA_CMD_OPCODE_BASIC_IN_HASH	0x3
#define   EIP93_SA_CMD_OPCODE_BASIC_IN_HASH_DEC	0x1
#define   EIP93_SA_CMD_OPCODE_BASIC_IN_DEC	0x0
#define   EIP93_SA_CMD_OPCODE_PROTOCOL_OUT_ESP	0x0
#define   EIP93_SA_CMD_OPCODE_PROTOCOL_OUT_SSL	0x4
#define   EIP93_SA_CMD_OPCODE_PROTOCOL_OUT_TLS	0x5
#define   EIP93_SA_CMD_OPCODE_PROTOCOL_OUT_SRTP	0x7
#define   EIP93_SA_CMD_OPCODE_PROTOCOL_IN_ESP	0x0
#define   EIP93_SA_CMD_OPCODE_PROTOCOL_IN_SSL	0x2
#define   EIP93_SA_CMD_OPCODE_PROTOCOL_IN_TLS	0x3
#define   EIP93_SA_CMD_OPCODE_PROTOCOL_IN_SRTP	0x7
#define   EIP93_SA_CMD_OPCODE_EXT_OUT_DTSL	0x1
#define   EIP93_SA_CMD_OPCODE_EXT_OUT_SSL	0x4
#define   EIP93_SA_CMD_OPCODE_EXT_OUT_TLSV10	0x5
#define   EIP93_SA_CMD_OPCODE_EXT_OUT_TLSV11	0x6
#define   EIP93_SA_CMD_OPCODE_EXT_IN_DTSL	0x1
#define   EIP93_SA_CMD_OPCODE_EXT_IN_SSL	0x4
#define   EIP93_SA_CMD_OPCODE_EXT_IN_TLSV10	0x5
#define   EIP93_SA_CMD_OPCODE_EXT_IN_TLSV11	0x6
#define EIP93_REG_SA_CMD_1			0x404
#define   EIP93_SA_CMD_EN_SEQNUM_CHK		BIT(29)
/* This mask can be either used for ARC4 or AES */
#define   EIP93_SA_CMD_ARC4_KEY_LENGHT		GENMASK(28, 24)
#define   EIP93_SA_CMD_AES_DEC_KEY		BIT(28) /* 0: encrypt key 1: decrypt key */
#define   EIP93_SA_CMD_AES_KEY_LENGTH		GENMASK(26, 24)
#define   EIP93_SA_CMD_AES_KEY_256BIT		FIELD_PREP(EIP93_SA_CMD_AES_KEY_LENGTH, 0x4)
#define   EIP93_SA_CMD_AES_KEY_192BIT		FIELD_PREP(EIP93_SA_CMD_AES_KEY_LENGTH, 0x3)
#define   EIP93_SA_CMD_AES_KEY_128BIT		FIELD_PREP(EIP93_SA_CMD_AES_KEY_LENGTH, 0x2)
#define   EIP93_SA_CMD_HASH_CRYPT_OFFSET	GENMASK(23, 16)
#define   EIP93_SA_CMD_BYTE_OFFSET		BIT(13) /* 0: CRYPT_OFFSET in 32bit word 1: CRYPT_OFFSET in 8bit bytes */
#define   EIP93_SA_CMD_HMAC			BIT(12)
#define   EIP93_SA_CMD_SSL_MAC			BIT(12)
/* This mask can be either used for ARC4 or AES */
#define   EIP93_SA_CMD_CHIPER_MODE		GENMASK(9, 8)
/* AES or DES operations */
#define   EIP93_SA_CMD_CHIPER_MODE_ICM		FIELD_PREP(EIP93_SA_CMD_CHIPER_MODE, 0x3)
#define   EIP93_SA_CMD_CHIPER_MODE_CTR		FIELD_PREP(EIP93_SA_CMD_CHIPER_MODE, 0x2)
#define   EIP93_SA_CMD_CHIPER_MODE_CBC		FIELD_PREP(EIP93_SA_CMD_CHIPER_MODE, 0x1)
#define   EIP93_SA_CMD_CHIPER_MODE_ECB		FIELD_PREP(EIP93_SA_CMD_CHIPER_MODE, 0x0)
/* ARC4 operations */
#define   EIP93_SA_CMD_CHIPER_MODE_STATEFULL	FIELD_PREP(EIP93_SA_CMD_CHIPER_MODE, 0x1)
#define   EIP93_SA_CMD_CHIPER_MODE_STATELESS	FIELD_PREP(EIP93_SA_CMD_CHIPER_MODE, 0x0)
#define   EIP93_SA_CMD_COPY_PAD			BIT(3)
#define   EIP93_SA_CMD_COPY_PAYLOAD		BIT(2)
#define   EIP93_SA_CMD_COPY_HEADER		BIT(1)
#define   EIP93_SA_CMD_COPY_DIGEST		BIT(0) /* With this enabled, COPY_PAD is required */

/* State save register */
#define EIP93_REG_STATE_IV_0			0x500
#define EIP93_REG_STATE_IV_1			0x504

#define EIP93_REG_PE_ARC4STATE			0x700

struct sa_record {
	u32 sa_cmd0_word;
	u32 sa_cmd1_word;
	u32 sa_key[8];
	u8 sa_i_digest[32];
	u8 sa_o_digest[32];
	u32 sa_spi;
	u32 sa_seqnum[2];
	u32 sa_seqmum_mask[2];
	u32 sa_nonce;
} __packed;

struct sa_state {
	u32 state_iv[4];
	u32 state_byte_cnt[2];
	u8 state_i_digest[32];
} __packed;

struct eip93_descriptor {
	u32 pe_ctrl_stat_word;
	u32 src_addr;
	u32 dst_addr;
	u32 sa_addr;
	u32 state_addr;
	u32 arc4_addr;
	u32 user_id;
	u32 pe_length_word;
} __packed;

#endif
