/* GdkPixbuf library - test compositing
 *
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Benjamin Otte
 */

#include <gdk-pixbuf.h>

#include "test-common.h"

static void
test_original (void)
{
  GdkPixbuf* buf;
  int size = 32;
  GError* err = NULL;

  buf = gdk_pixbuf_new_from_resource_at_scale ("/test/resource/cve-2015-4491.bmp", size, size, FALSE, &err);
  /* Image is corrupt because the rowstride * height mul overflows */
  g_assert_error (err, GDK_PIXBUF_ERROR, GDK_PIXBUF_ERROR_CORRUPT_IMAGE);
  g_assert_null (buf);
  g_error_free (err);
}

static void
test_scale_overflow (void)
{
  GdkPixbuf *src, *dest;

  src = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, 1 << 12, 1 << 12);
  dest = gdk_pixbuf_scale_simple (src, 1, 1, GDK_INTERP_BILINEAR);

  g_object_unref (dest);
  g_object_unref (src);

}

static void
test_scalex_overflow (void)
{
  GdkPixbuf *src, *dest;

  src = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, (((guint) G_MAXINT) + 1) >> 7, 1);
  dest = gdk_pixbuf_scale_simple (src, 1, 1, GDK_INTERP_BILINEAR);

  g_object_unref (dest);
  g_object_unref (src);

}

static void
test_scaley_overflow (void)
{
  GdkPixbuf *src, *dest;

  src = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, 1, (((guint) G_MAXINT) + 1) >> 7);
  dest = gdk_pixbuf_scale_simple (src, 1, 1, GDK_INTERP_BILINEAR);

  g_object_unref (dest);
  g_object_unref (src);

}

int
main (int argc, char *argv[])
{
  g_test_init (&argc, &argv, NULL);

  g_test_add_func ("/pixbuf/cve-2015-4491/original", test_original);
  g_test_add_func ("/pixbuf/cve-2015-4491/scale-overflow", test_scale_overflow);
  g_test_add_func ("/pixbuf/cve-2015-4491/scale-x-overflow", test_scalex_overflow);
  g_test_add_func ("/pixbuf/cve-2015-4491/scale-y-overflow", test_scaley_overflow);

  return g_test_run ();
}
