#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Bee Simulator
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250904.2

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='bee-simulator'
GAME_NAME='Bee Simulator'

ARCHIVE_BASE_0_NAME='setup_bee_simulator_1.0_(55451).exe'
ARCHIVE_BASE_0_MD5='74cbfd6873ed784201bea56a857d6222'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_bee_simulator_1.0_(55451)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='214c92f714f12bdf6a3408f0650ec2d2'
ARCHIVE_BASE_0_PART2_NAME='setup_bee_simulator_1.0_(55451)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='9dcca7e498376ff76b40e86d7fae8cf4'
ARCHIVE_BASE_0_SIZE='11000000'
ARCHIVE_BASE_0_VERSION='1.0-gog55451'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/bee_simulator'

UNREALENGINE4_NAME='bebee'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME0_BIN_FILES="
${UNREALENGINE4_NAME}/config"
CONTENT_GAME0_DATA_FILES="
${UNREALENGINE4_NAME}/assetregistry.bin
${UNREALENGINE4_NAME}/bebee.uproject"
CONTENT_GAME_MOVIES_FILES="
${UNREALENGINE4_NAME}/content/movies"

APP_MAIN_EXE="${UNREALENGINE4_NAME}/binaries/win64/${UNREALENGINE4_NAME}-win64-shipping.exe"
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=123'

PACKAGES_LIST='
PKG_BIN
PKG_MOVIES
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_MOVIES
PKG_DATA'

PKG_MOVIES_ID="${GAME_ID}-movies"
PKG_MOVIES_DESCRIPTION='movies'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

## Do not install the Visual C++ Runtime, to prevent a launch error… telling it’s missing?!
unrealengine4_wine_winetricks_verbs_default() { return 0; }

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
