# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

profile-window-heading = Välj en { -brand-short-name }-profil
profile-window-body = Håll ditt arbete och din personliga surfning, inklusive saker som lösenord och bokmärken, helt åtskilda. Eller skapa profiler för alla som använder den här enheten.
# This checkbox appears in the Choose profile window that appears when the browser is opened. "Show this" refers to this window, which is displayed when the checkbox is enabled.
profile-window-checkbox-label-2 =
    .label = Välj en profil när { -brand-short-name } öppnas
# This subcopy appears below the checkbox when it is unchecked
profile-window-checkbox-subcopy = { -brand-short-name } kommer att öppnas till din senast använda profil.
profile-window-create-profile = Skapa en profil
profile-card-edit-button =
    .title = Redigera profil
    .aria-label = Redigera profil
profile-card-delete-button =
    .title = Ta bort profil
    .aria-label = Ta bort profil
# Variables
#   $profileName (string) - The name of the profile
profile-card =
    .title = Öppna { $profileName }
    .aria-label = Öppna { $profileName }
# Variables
#   $number (number) - The number of the profile
default-profile-name = Profil { $number }
# The word 'original' is used in the sense that it is the initial or starting profile when you install Firefox.
original-profile-name = Ursprunglig profil
default-desktop-shortcut-name = { -brand-short-name }
edit-profile-page-title = Redigera profil
edit-profile-page-header = Redigera din profil
edit-profile-page-profile-name-label = Profilnamn
edit-profile-page-theme-header-2 =
    .label = Tema
edit-profile-page-explore-themes = Utforska fler teman
edit-profile-page-desktop-shortcut-header = Skapa genväg på skrivbordet
edit-profile-page-desktop-shortcut-toggle =
    .aria-label = Skapa genväg på skrivbordet
edit-profile-page-avatar-header-2 =
    .label = Avatar
edit-profile-page-delete-button =
    .label = Ta bort
edit-profile-page-avatar-selector-opener-link = Redigera
avatar-selector-icon-tab = Ikon
avatar-selector-custom-tab = Anpassa
avatar-selector-cancel-button =
    .label = Avbryt
avatar-selector-save-button =
    .label = Spara
avatar-selector-upload-file = Ladda upp en fil
avatar-selector-drag-file = Eller dra en fil hit
avatar-selector-add-image = Lägg till en bild
avatar-selector-crop = Beskär
edit-profile-page-no-name = Ge profilen ett namn för att hjälpa dig hitta den senare. Byt namn på den när som helst.
edit-profile-page-duplicate-name = Profilnamnet används redan. Prova ett nytt namn.
edit-profile-page-profile-saved = Sparad
new-profile-page-title = Ny profil
new-profile-page-header = Anpassa din nya profil
new-profile-page-header-description = Varje profil behåller sin unika surfhistorik och inställningar skild från dina andra profiler. Dessutom är { -brand-short-name }:s starka integritetsskydd aktiverade som standard.
new-profile-page-learn-more = Läs mer
new-profile-page-input-placeholder =
    .placeholder = Välj ett namn som "Arbete" eller "Personligt"
new-profile-page-done-button =
    .label = Klar med redigering
# Variables
#   $profilename (String) - The name of the copied profile.
copied-profile-page-header = Din kopia av { $profilename } är redo att anpassas
copied-profile-page-header-description = Vi kopierade din data och inställningar till en ny profil. Ge den ett namn, välj ett utseende och gör den till din egen.
profile-window-title-2 = { -brand-short-name } - Välj en profil
profile-window-logo =
    .alt = { -brand-short-name } logotyp

## Delete profile dialogue that allows users to review what they will lose if they choose to delete their profile. Each item (open windows, etc.) is displayed in a table, followed by a column with the number of items.

# Variables
#   $profilename (String) - The name of the profile.
delete-profile-page-title = Ta bort profilen { $profilename }
# Variables
#   $profilename (String) - The name of the profile.
delete-profile-header = Ta bort profil { $profilename }?
delete-profile-description = { -brand-short-name } tar bort följande data permanent från den här enheten:
# Open is an adjective, as in "browser windows currently open".
delete-profile-windows = Öppna fönster
# Open is an adjective, as in "browser tabs currently open".
delete-profile-tabs = Öppna flikar
delete-profile-bookmarks = Bokmärken
delete-profile-history = Historik (besökta sidor, kakor, webbplatsdata)
delete-profile-autofill = Autofylldata (adresser, betalningsmetoder)
delete-profile-logins = Lösenord

##

# Button label
delete-profile-cancel = Avbryt
# Button label
delete-profile-confirm = Ta bort

## These strings are color themes available to select from the profile selection screen. Theme names should be localized.

# The default light theme
profiles-light-theme = Ljust
# The default dark theme
profiles-dark-theme = Mörkt
# The default system theme
profiles-system-theme = System
profiles-system-theme-title =
    .title = Använd systemtema
# This light theme features sunny colors such as goldenrod and pale yellow. Its name evokes the color of a marigold flower. This name can be translated directly if it's easily understood in your language, or adapted to a more natural sounding name that fits the color scheme.
profiles-marigold-theme-2 = Gul ringblomma
# This light theme features various shades of soft, muted purples. Its name evokes the color of a lavender flower. This name can be translated directly if it's easily understood in your language, or adapted to a more natural sounding name that fits the color scheme.
profiles-lavender-theme-2 = Blek lavendel
# This light theme features very pale green tones. Its name evokes the color of pale green mint ice cream. This name can be translated directly if it's easily understood in your language, or adapted to a more natural sounding name that fits the color scheme.
profiles-lichen-theme-2 = Mintgrön
# This light theme features various shades of pink ranging from pale to bold. Its name evokes the color of a pink magnolia flower. This name can be translated directly if it's easily understood in your language, or adapted to a more natural sounding name that fits the color scheme.
profiles-magnolia-theme-2 = Rosa magnolia
# Ocean blue is a dark theme that features very dark blues and black. Its name evokes the color of the deep ocean water. This name can be translated directly if it's easily understood in your language, or adapted to a more natural sounding name that fits the color scheme.
profiles-ocean-theme-2 = Havsblått
# This dark theme features warm oranges, dark mahogany browns, and earthy red/brown colors. The name evokes the earthy colors of brick masonry. This name can be translated directly if it's easily understood in your language, or adapted to a more natural sounding name that fits the color scheme.
profiles-terracotta-theme-2 = Tegelröd
# This dark theme features forest green, dusky green with a gray undertone, and a muted sage green. Its name evokes the rich color of green moss in the forest. This name can be translated directly if its easily understood in your language, or adapted to a more natural sounding name that fits the color scheme.
profiles-moss-theme-2 = Mossgrön
profiles-gray-theme = Grå
profiles-gray-theme-title =
    .title = Använd grått tema
profiles-yellow-theme = Gul
profiles-yellow-theme-title =
    .title = Använd gult tema
profiles-orange-theme = Orange
profiles-orange-theme-title =
    .title = Använd orange tema
profiles-red-theme = Röd
profiles-red-theme-title =
    .title = Använd rött tema
profiles-pink-theme = Rosa
profiles-pink-theme-title =
    .title = Använd rosa tema
profiles-purple-theme = Lila
profiles-purple-theme-title =
    .title = Använd lila tema
profiles-violet-theme = Violett
profiles-violet-theme-title =
    .title = Använd violett tema
profiles-blue-theme = Blå
profiles-blue-theme-title =
    .title = Använd blått tema
profiles-green-theme = Grön
profiles-green-theme-title =
    .title = Använd grönt tema
profiles-cyan-theme = Cyan
profiles-cyan-theme-title =
    .title = Använd cyan tema
profiles-custom-theme-title =
    .title = Använd anpassat tema

## Data collection settings changed (multi-profile)

# Full infobar message with inline bold title followed by body text
multiprofile-data-collection-message = <strong>Inställningarna för datainsamling har ändrats.</strong> Ändringarna som görs i en annan profil gäller alla profiler på den här enheten.
# Primary button label to open the Data collection section in Settings
multiprofile-data-collection-view-settings = Visa inställningar
# Secondary button label to dismiss the infobar without action
multiprofile-data-collection-dismiss = Ignorera

## Alternative text for default profile icons

book-avatar-alt =
    .alt = Bok
briefcase-avatar-alt =
    .alt = Portfölj
picture-avatar-alt =
    .alt = Bild
# Craft refers to hobby arts and crafts, represented by a button/fastener commonly found on clothing like shirts
craft-avatar-alt =
    .alt = Hantverk
flower-avatar-alt =
    .alt = Blomma
folder-avatar-alt =
    .alt = Mapp
hammer-avatar-alt =
    .alt = Hammare
heart-avatar-alt =
    .alt = Hjärta
heart-rate-avatar-alt =
    .alt = Hjärtfrekvens
clock-avatar-alt =
    .alt = Klocka
leaf-avatar-alt =
    .alt = Löv
lightbulb-avatar-alt =
    .alt = Glödlampa
makeup-avatar-alt =
    .alt = Smink
# Message refers to a text message, not a traditional letter/envelope message
message-avatar-alt =
    .alt = Meddelande
musical-note-avatar-alt =
    .alt = Musiknot
palette-avatar-alt =
    .alt = Palett
paw-print-avatar-alt =
    .alt = Tassavtryck
plane-avatar-alt =
    .alt = Flygplan
# Present refers to a gift box, not the current time period
present-avatar-alt =
    .alt = Present
shopping-avatar-alt =
    .alt = Varukorg
soccer-ball-avatar-alt =
    .alt = Fotboll
sparkle-single-avatar-alt =
    .alt = Gnistra
star-avatar-alt =
    .alt = Stjärna
video-game-controller-avatar-alt =
    .alt = Handkontroll för TV-spel
custom-avatar-alt =
    .alt = Anpassad avatar
# Globe refers to the generic globe/world icon that appears in browser tabs when a website doesn't have its own favicon.
globe-avatar-alt =
    .alt = Glob
# Diamond refers to the precious stone, not the geometric shape
diamond-avatar-alt =
    .alt = Diamant
barbell-avatar-alt =
    .alt = Skivstång
bike-avatar-alt =
    .alt = Cykel

## Tooltips for default avatar icons

book-avatar = Bok
briefcase-avatar = Portfölj
clock-avatar = Klocka
# Craft refers to hobby arts and crafts, represented by a button/fastener commonly found on clothing like shirts
craft-avatar = Hantverk
custom-avatar = Anpassad avatar
# Diamond refers to the precious stone, not the geometric shape
diamond-avatar = Diamant
flower-avatar = Blomma
folder-avatar = Mapp
# Globe refers to the generic globe/world icon that appears in browser tabs when a website doesn't have its own favicon.
globe-avatar = Glob
hammer-avatar = Hammare
heart-avatar = Hjärta
heart-rate-avatar = Hjärtfrekvens
leaf-avatar = Löv
lightbulb-avatar = Glödlampa
makeup-avatar = Smink
# Message refers to a text message, not a traditional letter/envelope message
message-avatar = Meddelande
musical-note-avatar = Musiknot
palette-avatar = Palett
paw-print-avatar = Tassavtryck
picture-avatar = Bild
plane-avatar = Flygplan
# Present refers to a gift box, not the current time period
present-avatar = Present
shopping-avatar = Varukorg
soccer-ball-avatar = Fotboll
sparkle-single-avatar = Gnistra
star-avatar = Stjärna
video-game-controller-avatar = Handkontroll för TV-spel
custom-avatar-crop-back-button =
    .aria-label = Tillbaka
custom-avatar-crop-view =
    .aria-label = Beskär bildvy
custom-avatar-crop-area =
    .aria-label = Justera beskärningsytan
custom-avatar-drag-handle =
    .aria-label = Ändra storlek på beskärningsyta
profiles-appmenu-callout-tour-title = Din nya profil är klar
# "Spin up another" means creating another profile, “Hop between your digital lives" is referring to switching between different profiles such as work, personal, etc.
profiles-appmenu-callout-tour-subtitle = I menyn ☰ trycker du på ditt profilnamn för att skapa en annan, redigera den här eller hoppa mellan dina digitala liv.
profiles-appmenu-callout-tour-primary-button = Visa mig hur
barbell-avatar = Skivstång
bike-avatar = Cykel

## Tooltips for default avatar icons

barbell-avatar-tooltip =
    .tooltiptext = Använd skivstångsavatar
bike-avatar-tooltip =
    .tooltiptext = Använd cykelavatar
book-avatar-tooltip =
    .tooltiptext = Använd bokavatar
briefcase-avatar-tooltip =
    .tooltiptext = Använd portföljavatar
picture-avatar-tooltip =
    .tooltiptext = Använd bildavatar
# Craft refers to hobby arts and crafts, represented by a button/fastener commonly found on clothing like shirts
craft-avatar-tooltip =
    .tooltiptext = Använd hantverksavatar
# Globe refers to the generic globe/world icon that appears in browser tabs when a website doesn't have its own favicon.
globe-avatar-tooltip =
    .tooltiptext = Använd glob-avatar
diamond-avatar-tooltip =
    .tooltiptext = Använd diamantavatar
flower-avatar-tooltip =
    .tooltiptext = Använd blomavatar
folder-avatar-tooltip =
    .tooltiptext = Använd mappavatar
hammer-avatar-tooltip =
    .tooltiptext = Använd hammaravatar
heart-avatar-tooltip =
    .tooltiptext = Använd hjärtavatar
heart-rate-avatar-tooltip =
    .tooltiptext = Använd pulsavatar
clock-avatar-tooltip =
    .tooltiptext = Använd klockavatar
leaf-avatar-tooltip =
    .tooltiptext = Använd lövavatar
lightbulb-avatar-tooltip =
    .tooltiptext = Använd glödlampsavatar
makeup-avatar-tooltip =
    .tooltiptext = Använd smink-avatar
# Message refers to a text message, not a traditional letter/envelope message
message-avatar-tooltip =
    .tooltiptext = Använd meddelandeavatar
musical-note-avatar-tooltip =
    .tooltiptext = Använd musiknotsavatar
palette-avatar-tooltip =
    .tooltiptext = Använd palettavatar
paw-print-avatar-tooltip =
    .tooltiptext = Använd tassavtrycksavatar
plane-avatar-tooltip =
    .tooltiptext = Använd flygplansavatar
# Present refers to a gift box, not the current time period
present-avatar-tooltip =
    .tooltiptext = Använd presentavatar
shopping-avatar-tooltip =
    .tooltiptext = Använd kundvagnsavatar
soccer-ball-avatar-tooltip =
    .tooltiptext = Använd fotbollsavatar
sparkle-single-avatar-tooltip =
    .tooltiptext = Använd gnistavatar
star-avatar-tooltip =
    .tooltiptext = Använd stjärnavatar
video-game-controller-avatar-tooltip =
    .tooltiptext = Använd avatar för TV-spelskontroll
