/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.generate;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.uima.pear.PearException;
import org.apache.uima.pear.PearPlugin;
import org.apache.uima.pear.generate.PearFileResourceExportPage;
import org.apache.uima.pear.insd.edit.INSDComponentPage;
import org.apache.uima.pear.insd.edit.INSDEnvironmentPage;
import org.apache.uima.pear.insd.edit.InsdConstants;
import org.apache.uima.pear.insd.edit.PearInstallationDescriptor;
import org.apache.uima.pear.insd.edit.vars.VarVal;
import org.apache.uima.pear.nature.ProjectCustomizer;
import org.apache.uima.pear.tools.InstallationDescriptor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public class GeneratePearWizard
extends Wizard
implements IWizard,
InsdConstants {
    private IContainer currentContainer;
    private InstallationDescriptor insd;
    private Hashtable wizardData = new Hashtable();
    private INSDComponentPage componentPage;
    private INSDEnvironmentPage environmentPage;
    private PearFileResourceExportPage pearExportPage;

    public GeneratePearWizard(IContainer container) {
        PearException subEx;
        try {
            this.setWindowTitle("PEAR Generation Wizard");
            this.setDefaultPageImageDescriptor(PearPlugin.getImageDescriptor("generatePearWiz.gif"));
            this.setNeedsProgressMonitor(true);
            this.currentContainer = container;
        }
        catch (Throwable e) {
            subEx = new PearException("Operation failed because the wizard could not be initialized.\nPlease report this error.", e);
            subEx.openErrorDialog(this.getShell());
            this.dispose();
        }
        try {
            PearPlugin plugin = PearPlugin.getDefault();
            IDialogSettings workbenchSettings = plugin.getDialogSettings();
            IDialogSettings section = workbenchSettings.getSection("PearFileExportWizard");
            if (section == null) {
                section = workbenchSettings.addNewSection("PearFileExportWizard");
            }
            this.setDialogSettings(section);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.insd = PearInstallationDescriptor.getInstallationDescriptor(this.currentContainer);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.insd = new InstallationDescriptor();
        }
        try {
            ProjectCustomizer.customizeProject(this.currentContainer, this.insd);
        }
        catch (Throwable e) {
            subEx = new PearException("Operation failed because the wizard could not customize your project as a UIMA project.", e);
            subEx.openErrorDialog(this.getShell());
            this.dispose();
        }
    }

    public void addPages() {
        try {
            this.componentPage = new INSDComponentPage(this.currentContainer, this.insd, this.wizardData);
            this.addPage((IWizardPage)this.componentPage);
            this.environmentPage = new INSDEnvironmentPage(this.currentContainer, this.insd, this.wizardData);
            this.addPage((IWizardPage)this.environmentPage);
            this.pearExportPage = new PearFileResourceExportPage((IStructuredSelection)new StructuredSelection((Object[])this.currentContainer.members()), this.currentContainer);
            this.addPage((IWizardPage)this.pearExportPage);
        }
        catch (Throwable e) {
            PearException subEx = new PearException("Operation failed because the wizard's pages could not be initialized properly.", e);
            subEx.openErrorDialog(this.getShell());
            this.dispose();
        }
    }

    public boolean performFinish() {
        try {
            this.editInstallationDescriptor();
            String file = this.pearExportPage.getDestinationValue();
            if (new File(file).exists() && !MessageDialog.openConfirm((Shell)this.getShell(), (String)"File exists", (String)("The file " + file + " already exists. Do you want to overwrite it?"))) {
                return false;
            }
            this.getContainer().run(false, true, this.pearExportPage.getExportRunnable());
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Done.", (String)"The PEAR file export operation is done.");
            return true;
        }
        catch (Throwable e) {
            PearException.openErrorDialog(e, this.getShell());
            return false;
        }
    }

    private void editInstallationDescriptor() throws CoreException, IOException {
        this.handleComponentInformation();
        this.addEnvOptions();
        this.addEnvVars();
        PearInstallationDescriptor.saveInstallationDescriptor(this.currentContainer, this.insd);
    }

    private void handleComponentInformation() {
        this.insd.setMainComponent(this.componentPage.compID);
        this.insd.setMainComponentDesc(PearInstallationDescriptor.addMacro(this.componentPage.compDescriptorPath));
    }

    private void addEnvOptions() {
        String jdkVersion;
        this.insd.clearOSSpecs();
        this.insd.clearToolkitsSpecs();
        this.insd.clearFrameworkSpecs();
        String os = this.environmentPage.osCombo.getText();
        if (os != null && os.trim().length() > 0) {
            this.insd.addOSSpec("NAME", os);
        }
        if ((jdkVersion = this.environmentPage.jdkVersionCombo.getText()) != null && jdkVersion.trim().length() > 0) {
            this.insd.addToolkitsSpec("JDK_VERSION", jdkVersion);
        }
    }

    private void addEnvVars() {
        this.insd.deleteInstallationActions("set_env_variable");
        for (VarVal vv : this.environmentPage.envVarList.tableRows) {
            String envVarName = vv.getVarName();
            String envVarValue = vv.getVarValue();
            if (envVarName == null || envVarValue == null || envVarName.trim().length() <= 0 || envVarValue.trim().length() <= 0) continue;
            InstallationDescriptor.ActionInfo actionInfo = new InstallationDescriptor.ActionInfo("set_env_variable");
            actionInfo.params.put("VAR_NAME", envVarName);
            actionInfo.params.put("VAR_VALUE", envVarValue);
            actionInfo.params.put("COMMENTS", "");
            this.insd.addInstallationAction(actionInfo);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

