/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.container.ResourceIsolationInterface;
import org.apache.storm.daemon.supervisor.AdvancedFSOps;
import org.apache.storm.daemon.supervisor.ContainerMemoryTracker;
import org.apache.storm.daemon.supervisor.ContainerRecoveryException;
import org.apache.storm.daemon.supervisor.Killable;
import org.apache.storm.daemon.supervisor.OnlyLatestExecutor;
import org.apache.storm.generated.LSWorkerHeartbeat;
import org.apache.storm.generated.LocalAssignment;
import org.apache.storm.generated.ProfileRequest;
import org.apache.storm.generated.WorkerMetricList;
import org.apache.storm.generated.WorkerMetricPoint;
import org.apache.storm.generated.WorkerMetrics;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.metricstore.MetricException;
import org.apache.storm.metricstore.WorkerMetricsProcessor;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.LocalState;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ServerConfigUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public abstract class Container
implements Killable {
    private static final Logger LOG = LoggerFactory.getLogger(Container.class);
    private static final String MEMORY_USED_METRIC = "UsedMemory";
    private static final String SYSTEM_COMPONENT_ID = "System";
    private static final String INVALID_EXECUTOR_ID = "-1";
    private static final String INVALID_STREAM_ID = "None";
    private static final Map<String, Integer> cachedUserToUidMap = new ConcurrentHashMap<String, Integer>();
    private final Meter numCleanupExceptions;
    private final Meter numKillExceptions;
    private final Meter numForceKillExceptions;
    private final Meter numForceKill;
    private final Timer shutdownDuration;
    private final Timer cleanupDuration;
    protected final Map<String, Object> conf;
    protected final Map<String, Object> topoConf;
    protected final String topologyId;
    protected final String supervisorId;
    protected final int supervisorPort;
    protected final int port;
    protected final LocalAssignment assignment;
    protected final AdvancedFSOps ops;
    protected final ResourceIsolationInterface resourceIsolationManager;
    protected final boolean symlinksDisabled;
    protected String workerId;
    protected ContainerType type;
    protected ContainerMemoryTracker containerMemoryTracker;
    private long lastMetricProcessTime = 0L;
    private Timer.Context shutdownTimer = null;
    protected boolean runAsUser;
    private String cachedUser;

    protected Container(ContainerType type, Map<String, Object> conf, String supervisorId, int supervisorPort, int port, LocalAssignment assignment, ResourceIsolationInterface resourceIsolationManager, String workerId, Map<String, Object> topoConf, AdvancedFSOps ops, StormMetricsRegistry metricsRegistry, ContainerMemoryTracker containerMemoryTracker) throws IOException {
        if (type == null) {
            throw new IOException("ContainerType parameter is null");
        }
        if (conf == null) {
            throw new IOException("conf parameter value is null");
        }
        if (supervisorId == null) {
            throw new IOException("SupervisorId parameter value is null");
        }
        this.symlinksDisabled = (Boolean)conf.getOrDefault("storm.disable.symlinks", false);
        if (ops == null) {
            ops = AdvancedFSOps.make(conf);
        }
        this.workerId = workerId;
        this.type = type;
        this.port = port;
        this.ops = ops;
        this.conf = conf;
        this.supervisorId = supervisorId;
        this.supervisorPort = supervisorPort;
        this.resourceIsolationManager = resourceIsolationManager;
        this.assignment = assignment;
        this.runAsUser = ObjectReader.getBoolean((Object)conf.get("supervisor.run.worker.as.user"), (boolean)false);
        if (this.runAsUser && Utils.isOnWindows()) {
            throw new UnsupportedOperationException("ERROR: Windows doesn't support running workers as different users yet");
        }
        if (this.type.isOnlyKillable()) {
            if (this.assignment != null) {
                throw new IOException("With ContainerType==OnlyKillable, expecting LocalAssignment member variable to be null");
            }
            if (this.port > 0) {
                throw new IOException("With ContainerType==OnlyKillable, expecting port member variable <=0 but found " + this.port);
            }
            if (this.workerId == null) {
                throw new IOException("With ContainerType==OnlyKillable, expecting WorkerId member variable to be assigned");
            }
            this.topologyId = null;
            this.topoConf = null;
        } else {
            if (this.assignment == null) {
                throw new IOException("With ContainerType!=OnlyKillable, expecting LocalAssignment member variable to be assigned");
            }
            if (this.port <= 0) {
                throw new IOException("With ContainerType!=OnlyKillable, expecting port member variable >0 but found " + this.port);
            }
            this.topologyId = assignment.get_topology_id();
            if (!this.ops.doRequiredTopoFilesExist(this.conf, this.topologyId)) {
                LOG.info("Missing topology storm code, so can't launch  worker with assignment {} for this supervisor {} on port {} with id {}", new Object[]{this.assignment, this.supervisorId, this.port, this.workerId});
                throw new ContainerRecoveryException("Missing required topology files...");
            }
            this.topoConf = topoConf == null ? this.readTopoConf() : topoConf;
        }
        this.numCleanupExceptions = metricsRegistry.registerMeter("supervisor:num-cleanup-exceptions");
        this.numKillExceptions = metricsRegistry.registerMeter("supervisor:num-kill-exceptions");
        this.numForceKillExceptions = metricsRegistry.registerMeter("supervisor:num-force-kill-exceptions");
        this.numForceKill = metricsRegistry.registerMeter("supervisor:num-workers-force-kill");
        this.shutdownDuration = metricsRegistry.registerTimer("supervisor:worker-shutdown-duration-ns");
        this.cleanupDuration = metricsRegistry.registerTimer("supervisor:worker-per-call-clean-up-duration-ns");
        this.containerMemoryTracker = containerMemoryTracker;
    }

    public String toString() {
        return "topo:" + this.topologyId + " worker:" + this.workerId;
    }

    protected Map<String, Object> readTopoConf() throws IOException {
        if (this.topologyId == null) {
            throw new IOException("Cannot readTopoConf: member variable topologyId is null");
        }
        return ConfigUtils.readSupervisorStormConf(this.conf, (String)this.topologyId);
    }

    @Override
    public void kill() throws IOException {
        LOG.info("Killing {}:{}", (Object)this.supervisorId, (Object)this.workerId);
        if (this.shutdownTimer == null) {
            this.shutdownTimer = this.shutdownDuration.time();
        }
        try {
            if (this.resourceIsolationManager != null) {
                this.resourceIsolationManager.kill(this.getWorkerUser(), this.workerId);
            }
        }
        catch (IOException e) {
            this.numKillExceptions.mark();
            throw e;
        }
    }

    @Override
    public void forceKill() throws IOException {
        LOG.info("Force Killing {}:{}", (Object)this.supervisorId, (Object)this.workerId);
        this.numForceKill.mark();
        try {
            if (this.resourceIsolationManager != null) {
                this.resourceIsolationManager.forceKill(this.getWorkerUser(), this.workerId);
            }
        }
        catch (IOException e) {
            this.numForceKillExceptions.mark();
            throw e;
        }
    }

    public LSWorkerHeartbeat readHeartbeat() throws IOException {
        LocalState localState = ConfigUtils.workerState(this.conf, (String)this.workerId);
        LSWorkerHeartbeat hb = localState.getWorkerHeartBeat();
        LOG.trace("{}: Reading heartbeat {}", (Object)this.workerId, (Object)hb);
        return hb;
    }

    @Override
    public boolean areAllProcessesDead() throws IOException {
        boolean allDead = true;
        if (this.resourceIsolationManager != null) {
            allDead = this.resourceIsolationManager.areAllProcessesDead(this.getWorkerUser(), this.workerId);
        }
        if (allDead && this.shutdownTimer != null) {
            this.shutdownTimer.stop();
            this.shutdownTimer = null;
        }
        return allDead;
    }

    @Override
    public void cleanUp() throws IOException {
        try (Timer.Context t = this.cleanupDuration.time();){
            this.containerMemoryTracker.remove(this.port);
            this.cleanUpForRestart();
        }
        catch (IOException e) {
            this.numCleanupExceptions.mark();
            throw e;
        }
    }

    protected void setup() throws IOException {
        this.type.assertFull();
        if (!this.ops.doRequiredTopoFilesExist(this.conf, this.topologyId)) {
            LOG.info("Missing topology storm code, so can't launch  worker with assignment {} for this supervisor {} on port {} with id {}", new Object[]{this.assignment, this.supervisorId, this.port, this.workerId});
            throw new IllegalStateException("Not all needed files are here!!!!");
        }
        LOG.info("Setting up {}:{}", (Object)this.supervisorId, (Object)this.workerId);
        this.ops.forceMkdir(new File(ConfigUtils.workerPidsRoot(this.conf, (String)this.workerId)));
        this.ops.forceMkdir(new File(ConfigUtils.workerTmpRoot(this.conf, (String)this.workerId)));
        this.ops.forceMkdir(new File(ConfigUtils.workerHeartbeatsRoot(this.conf, (String)this.workerId)));
        File workerArtifacts = new File(ConfigUtils.workerArtifactsRoot(this.conf, (String)this.topologyId, (Integer)this.port));
        if (!this.ops.fileExists(workerArtifacts)) {
            this.ops.forceMkdir(workerArtifacts);
            this.ops.setupWorkerArtifactsDir(this.assignment.get_owner(), workerArtifacts);
        }
        String user = this.getWorkerUser();
        this.writeLogMetadata(user);
        this.saveWorkerUser(user);
        this.createArtifactsLink();
        this.createBlobstoreLinks();
    }

    protected void writeLogMetadata(String user) throws IOException {
        this.type.assertFull();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("topology.submitter.user", user);
        data.put("worker-id", this.workerId);
        HashSet logsGroups = new HashSet();
        if (this.topoConf.get("logs.groups") != null) {
            List groups = ObjectReader.getStrings((Object)this.topoConf.get("logs.groups"));
            logsGroups.addAll(groups);
        }
        if (this.topoConf.get("topology.groups") != null) {
            List topGroups = ObjectReader.getStrings((Object)this.topoConf.get("topology.groups"));
            logsGroups.addAll(topGroups);
        }
        data.put("logs.groups", logsGroups.toArray());
        HashSet logsUsers = new HashSet();
        if (this.topoConf.get("logs.users") != null) {
            List logUsers = ObjectReader.getStrings((Object)this.topoConf.get("logs.users"));
            logsUsers.addAll(logUsers);
        }
        if (this.topoConf.get("topology.users") != null) {
            List topUsers = ObjectReader.getStrings((Object)this.topoConf.get("topology.users"));
            logsUsers.addAll(topUsers);
        }
        data.put("logs.users", logsUsers.toArray());
        if (this.topoConf.get("topology.worker.timeout.secs") != null) {
            int topoTimeout = ObjectReader.getInt((Object)this.topoConf.get("topology.worker.timeout.secs"));
            int defaultWorkerTimeout = ObjectReader.getInt((Object)this.conf.get("supervisor.worker.timeout.secs"));
            topoTimeout = Math.max(topoTimeout, defaultWorkerTimeout);
            data.put("topology.worker.timeout.secs", topoTimeout);
        }
        File file = ServerConfigUtils.getLogMetaDataFile(this.conf, this.topologyId, this.port);
        Yaml yaml = new Yaml();
        try (Writer writer = this.ops.getWriter(file);){
            yaml.dump(data, writer);
        }
    }

    protected void createArtifactsLink() throws IOException {
        this.type.assertFull();
        if (!this.symlinksDisabled) {
            File workerDir = new File(ConfigUtils.workerRoot(this.conf, (String)this.workerId));
            File topoDir = new File(ConfigUtils.workerArtifactsRoot(this.conf, (String)this.topologyId, (Integer)this.port));
            if (this.ops.fileExists(workerDir)) {
                LOG.debug("Creating symlinks for worker-id: {} topology-id: {} to its port artifacts directory", (Object)this.workerId, (Object)this.topologyId);
                this.ops.createSymlink(new File(ConfigUtils.workerArtifactsSymlink(this.conf, (String)this.workerId)), topoDir);
            }
        }
    }

    protected void createBlobstoreLinks() throws IOException {
        this.type.assertFull();
        String stormRoot = ConfigUtils.supervisorStormDistRoot(this.conf, (String)this.topologyId);
        String workerRoot = ConfigUtils.workerRoot(this.conf, (String)this.workerId);
        Map blobstoreMap = (Map)this.topoConf.get("topology.blobstore.map");
        ArrayList<String> blobFileNames = new ArrayList<String>();
        if (blobstoreMap != null) {
            for (Map.Entry entry : blobstoreMap.entrySet()) {
                String key = (String)entry.getKey();
                Map blobInfo = (Map)entry.getValue();
                String ret = null;
                ret = blobInfo != null && blobInfo.containsKey("localname") ? (String)blobInfo.get("localname") : key;
                blobFileNames.add(ret);
            }
        }
        File targetResourcesDir = new File(stormRoot, "resources");
        ArrayList<String> resourceFileNames = new ArrayList<String>();
        if (targetResourcesDir.exists()) {
            resourceFileNames.add("resources");
        }
        resourceFileNames.addAll(blobFileNames);
        if (!this.symlinksDisabled) {
            LOG.info("Creating symlinks for worker-id: {} storm-id: {} for files({}): {}", new Object[]{this.workerId, this.topologyId, resourceFileNames.size(), resourceFileNames});
            if (targetResourcesDir.exists()) {
                this.ops.createSymlink(new File(workerRoot, "resources"), targetResourcesDir);
            } else {
                LOG.info("Topology jar for worker-id: {} storm-id: {} does not contain re sources directory {}.", new Object[]{this.workerId, this.topologyId, targetResourcesDir.toString()});
            }
            for (String fileName : blobFileNames) {
                this.ops.createSymlink(new File(workerRoot, fileName), new File(stormRoot, fileName));
            }
        } else if (blobFileNames.size() > 0) {
            LOG.warn("Symlinks are disabled, no symlinks created for blobs {}", blobFileNames);
        }
    }

    protected String getWorkerUser() throws IOException {
        if (this.cachedUser != null) {
            return this.cachedUser;
        }
        LOG.info("GET worker-user for {}", (Object)this.workerId);
        File file = new File(ConfigUtils.workerUserFile(this.conf, (String)this.workerId));
        if (this.ops.fileExists(file)) {
            this.cachedUser = this.ops.slurpString(file).trim();
            if (!StringUtils.isBlank((String)this.cachedUser)) {
                return this.cachedUser;
            }
        }
        if (this.assignment != null && this.assignment.is_set_owner()) {
            this.cachedUser = this.assignment.get_owner();
            if (!StringUtils.isBlank((String)this.cachedUser)) {
                return this.cachedUser;
            }
        }
        if (ConfigUtils.isLocalMode(this.conf)) {
            this.cachedUser = System.getProperty("user.name");
            return this.cachedUser;
        }
        File f = new File(ConfigUtils.workerArtifactsRoot(this.conf));
        if (f.exists()) {
            this.cachedUser = Files.getOwner(f.toPath(), new LinkOption[0]).getName();
            if (!StringUtils.isBlank((String)this.cachedUser)) {
                return this.cachedUser;
            }
        }
        throw new IllegalStateException("Could not recover the user for " + this.workerId);
    }

    protected void saveWorkerUser(String user) throws IOException {
        this.type.assertFull();
        LOG.info("SET worker-user {} {}", (Object)this.workerId, (Object)user);
        this.ops.dump(new File(ConfigUtils.workerUserFile(this.conf, (String)this.workerId)), user);
    }

    protected void deleteSavedWorkerUser() throws IOException {
        LOG.info("REMOVE worker-user {}", (Object)this.workerId);
        this.ops.deleteIfExists(new File(ConfigUtils.workerUserFile(this.conf, (String)this.workerId)));
    }

    public void cleanUpForRestart() throws IOException {
        LOG.info("Cleaning up {}:{}", (Object)this.supervisorId, (Object)this.workerId);
        String user = this.getWorkerUser();
        if (this.resourceIsolationManager != null) {
            this.resourceIsolationManager.cleanup(user, this.workerId, this.port);
        }
        this.ops.deleteIfExists(new File(ConfigUtils.workerHeartbeatsRoot(this.conf, (String)this.workerId)), user, this.workerId);
        this.ops.deleteIfExists(new File(ConfigUtils.workerPidsRoot(this.conf, (String)this.workerId)), user, this.workerId);
        this.ops.deleteIfExists(new File(ConfigUtils.workerTmpRoot(this.conf, (String)this.workerId)), user, this.workerId);
        this.ops.deleteIfExists(new File(ConfigUtils.workerRoot(this.conf, (String)this.workerId)), user, this.workerId);
        this.deleteSavedWorkerUser();
        this.workerId = null;
    }

    public boolean isMemoryLimitViolated(LocalAssignment withUpdatedLimits) throws IOException {
        this.updateMemoryAccounting();
        return false;
    }

    protected void updateMemoryAccounting() {
        this.type.assertFull();
        long used = this.getMemoryUsageMb();
        long reserved = this.getMemoryReservationMb();
        this.containerMemoryTracker.setUsedMemoryMb(this.port, this.topologyId, used);
        this.containerMemoryTracker.setReservedMemoryMb(this.port, this.topologyId, reserved);
    }

    public long getTotalTopologyMemoryUsed() {
        this.updateMemoryAccounting();
        return this.containerMemoryTracker.getUsedMemoryMb(this.topologyId);
    }

    public long getTotalTopologyMemoryReserved(LocalAssignment withUpdatedLimits) {
        this.updateMemoryAccounting();
        long ret = this.containerMemoryTracker.getReservedMemoryMb(this.topologyId);
        if (withUpdatedLimits.is_set_total_node_shared()) {
            ret = (long)((double)ret + withUpdatedLimits.get_total_node_shared());
        }
        return ret;
    }

    public long getTotalWorkersForThisTopology() {
        return this.containerMemoryTracker.getAssignedWorkerCount(this.topologyId);
    }

    public long getMemoryUsageMb() {
        return 0L;
    }

    public long getMemoryReservationMb() {
        return 0L;
    }

    public abstract void launch() throws IOException;

    public abstract void relaunch() throws IOException;

    public abstract boolean didMainProcessExit();

    public abstract boolean runProfiling(ProfileRequest var1, boolean var2) throws IOException, InterruptedException;

    public String getWorkerId() {
        return this.workerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMetrics(OnlyLatestExecutor<Integer> exec, WorkerMetricsProcessor processor) {
        try {
            Optional<Long> usedMemoryForPort = this.containerMemoryTracker.getUsedMemoryMb(this.port);
            if (usedMemoryForPort.isPresent()) {
                long nextMetricProcessTime = this.lastMetricProcessTime + 60000L;
                long currentTimeMsec = System.currentTimeMillis();
                if (currentTimeMsec < nextMetricProcessTime) {
                    return;
                }
                String hostname = Utils.hostname();
                long timestamp = System.currentTimeMillis();
                WorkerMetricPoint workerMetric = new WorkerMetricPoint(MEMORY_USED_METRIC, timestamp, (double)usedMemoryForPort.get().longValue(), SYSTEM_COMPONENT_ID, INVALID_EXECUTOR_ID, INVALID_STREAM_ID);
                WorkerMetricList metricList = new WorkerMetricList();
                metricList.add_to_metrics(workerMetric);
                WorkerMetrics metrics = new WorkerMetrics(this.topologyId, this.port, hostname, metricList);
                exec.execute(this.port, () -> {
                    try {
                        processor.processWorkerMetrics(this.conf, metrics);
                    }
                    catch (MetricException e) {
                        LOG.error("Failed to process metrics", (Throwable)e);
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error("Failed to process metrics", (Throwable)e);
        }
        finally {
            this.lastMetricProcessTime = System.currentTimeMillis();
        }
    }

    public static enum ContainerType {
        LAUNCH(false, false),
        RECOVER_FULL(true, false),
        RECOVER_PARTIAL(true, true);

        private final boolean recovery;
        private final boolean onlyKillable;

        private ContainerType(boolean recovery, boolean onlyKillable) {
            this.recovery = recovery;
            this.onlyKillable = onlyKillable;
        }

        public boolean isRecovery() {
            return this.recovery;
        }

        public void assertFull() {
            if (this.onlyKillable) {
                throw new IllegalStateException("Container is only Killable.");
            }
        }

        public boolean isOnlyKillable() {
            return this.onlyKillable;
        }
    }
}

