/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm;

import java.nio.channels.ClosedByInterruptException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.storm.daemon.Shutdownable;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessSimulator {
    protected static ConcurrentHashMap<String, Shutdownable> processMap = new ConcurrentHashMap();
    private static Logger LOG = LoggerFactory.getLogger(ProcessSimulator.class);
    private static Object lock = new Object();

    public static void registerProcess(String pid, Shutdownable shutdownable) {
        processMap.put(pid, shutdownable);
    }

    public static Collection<Shutdownable> getAllProcessHandles() {
        return processMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killProcess(String pid) {
        Object object = lock;
        synchronized (object) {
            LOG.info("Begin killing process " + pid);
            Shutdownable shutdownHandle = processMap.get(pid);
            if (shutdownHandle != null) {
                shutdownHandle.shutdown();
            }
            processMap.remove(pid);
            LOG.info("Successfully killed process " + pid);
        }
    }

    public static void killAllProcesses() {
        Set pids = processMap.keySet();
        for (String pid : pids) {
            try {
                ProcessSimulator.killProcess(pid);
            }
            catch (Exception e) {
                if (Utils.exceptionCauseIsInstanceOf(InterruptedException.class, (Throwable)e)) {
                    LOG.warn("process {} not killed (Ignoring InterruptedException)", (Object)pid, (Object)e);
                    continue;
                }
                if (Utils.exceptionCauseIsInstanceOf(ClosedByInterruptException.class, (Throwable)e)) {
                    LOG.warn("process {} not killed (Ignoring ClosedByInterruptException)", (Object)pid, (Object)e);
                    continue;
                }
                if (e instanceof RuntimeException) {
                    throw e;
                }
                throw new RuntimeException(e);
            }
        }
    }
}

