/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.commons.collections4.functors;

import org.apache.storm.shade.org.apache.commons.collections4.Closure;
import org.apache.storm.shade.org.apache.commons.collections4.functors.NOPClosure;

public class ForClosure<T>
implements Closure<T> {
    private final int iCount;
    private final Closure<? super T> iClosure;

    public static <E> Closure<E> forClosure(int count, Closure<? super E> closure) {
        if (count <= 0 || closure == null) {
            return NOPClosure.nopClosure();
        }
        if (count == 1) {
            return closure;
        }
        return new ForClosure<E>(count, closure);
    }

    public ForClosure(int count, Closure<? super T> closure) {
        this.iCount = count;
        this.iClosure = closure;
    }

    @Override
    public void execute(T input) {
        for (int i = 0; i < this.iCount; ++i) {
            this.iClosure.accept(input);
        }
    }

    public Closure<? super T> getClosure() {
        return this.iClosure;
    }

    public int getCount() {
        return this.iCount;
    }
}

