/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health.response;

import io.dropwizard.health.response.HealthResponse;
import io.dropwizard.health.response.HealthResponseProvider;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletHealthResponder
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletHealthResponder.class);
    private final HealthResponseProvider healthResponseProvider;
    private final boolean cacheControlEnabled;
    private final String cacheControlValue;

    public ServletHealthResponder(HealthResponseProvider healthResponseProvider, boolean cacheControlEnabled, String cacheControlValue) {
        this.healthResponseProvider = Objects.requireNonNull(healthResponseProvider);
        this.cacheControlEnabled = cacheControlEnabled;
        this.cacheControlValue = Objects.requireNonNull(cacheControlValue);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block3: {
            if (this.cacheControlEnabled) {
                response.setHeader("Cache-Control", this.cacheControlValue);
            }
            Map<String, Collection<String>> queryParameters = request.getParameterMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Arrays.asList((String[])entry.getValue())));
            HealthResponse healthResponse = this.healthResponseProvider.healthResponse(queryParameters);
            response.setContentType(healthResponse.getContentType());
            try {
                response.getWriter().write(healthResponse.getMessage());
                response.setStatus(healthResponse.getStatus());
            }
            catch (IOException ioException) {
                LOGGER.error("Failed to write response", (Throwable)ioException);
                if (response.isCommitted()) break block3;
                response.reset();
                response.setStatus(500);
            }
        }
    }
}

