/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogWithListener;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.client.package;
import org.apache.spark.sql.hive.client.package$hive$;
import org.apache.spark.sql.hive.client.package$hive$v12$;
import org.apache.spark.sql.hive.client.package$hive$v13$;
import org.apache.spark.sql.hive.client.package$hive$v14$;
import org.apache.spark.sql.hive.client.package$hive$v1_0$;
import org.apache.spark.sql.hive.client.package$hive$v1_1$;
import org.apache.spark.sql.hive.client.package$hive$v1_2$;
import org.apache.spark.sql.hive.client.package$hive$v2_0$;
import org.apache.spark.sql.hive.client.package$hive$v2_1$;
import org.apache.spark.sql.hive.client.package$hive$v2_2$;
import org.apache.spark.sql.hive.client.package$hive$v2_3$;
import org.apache.spark.sql.hive.client.package$hive$v3_0$;
import org.apache.spark.sql.hive.client.package$hive$v3_1$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001\u0002\u000b\u0016\u0001\tB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\ti\u0001\u0011)\u0019!C\u0001k!Aa\b\u0001B\u0001B\u0003%a\u0007\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011\u00151\u0005\u0001\"\u0001H\u0011\u001di\u0005\u00011A\u0005\n9CqA\u0015\u0001A\u0002\u0013%1\u000b\u0003\u0004Z\u0001\u0001\u0006Ka\u0014\u0005\t5\u0002A)\u0019!C\u00017\")A\f\u0001C\u0005;\")q\f\u0001C\u0005A\")q\u000e\u0001C\u0005a\")A\u000f\u0001C\u0005k\"A\u00111\u0001\u0001\u0005\u0002]\t)\u0001C\u0004\u0002\u000e\u0001!I!a\u0004\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*!9\u00111\u0006\u0001\u0005\u0002\u00055\u0002bBA\u0018\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003c\u0001A\u0011AA\u001a\u00051A\u0015N^3UK6\u0004\b+\u0019;i\u0015\t1r#A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0001$G\u0001\u0005Q&4XM\u0003\u0002\u001b7\u0005\u00191/\u001d7\u000b\u0005qi\u0012!B:qCJ\\'B\u0001\u0010 \u0003\u0019\t\u0007/Y2iK*\t\u0001%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0007C\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u001c\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0018,\u0005\u001daunZ4j]\u001e\fqa]3tg&|g\u000e\u0005\u00022e5\t\u0011$\u0003\u000243\ta1\u000b]1sWN+7o]5p]\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0016\u0003Y\u0002\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\t\r|gN\u001a\u0006\u0003wu\ta\u0001[1e_>\u0004\u0018BA\u001f9\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006Y\u0001.\u00193p_B\u001cuN\u001c4!\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\rS\u0014A\u00014t\u0013\t)%I\u0001\u0003QCRD\u0017A\u0002\u001fj]&$h\b\u0006\u0003I\u0015.c\u0005CA%\u0001\u001b\u0005)\u0002\"B\u0018\u0006\u0001\u0004\u0001\u0004\"\u0002\u001b\u0006\u0001\u00041\u0004\"B \u0006\u0001\u0004\u0001\u0015!F:uC\u001eLgn\u001a#je\u001a{'o\u0011:fCRLgnZ\u000b\u0002\u001fB\u0019A\u0005\u0015!\n\u0005E+#AB(qi&|g.A\rti\u0006<\u0017N\\4ESJ4uN]\"sK\u0006$\u0018N\\4`I\u0015\fHC\u0001+X!\t!S+\u0003\u0002WK\t!QK\\5u\u0011\u001dAv!!AA\u0002=\u000b1\u0001\u001f\u00132\u0003Y\u0019H/Y4j]\u001e$\u0015N\u001d$pe\u000e\u0013X-\u0019;j]\u001e\u0004\u0013\u0001E3yi\u0016\u0014h.\u00197UK6\u0004\b+\u0019;i+\u0005\u0001\u0015AE4fi\u0016CH/\u001a:oC2$V\u000e\u001d)bi\"$\"\u0001\u00110\t\u000b}R\u0001\u0019\u0001!\u00025=dGMV3sg&|g.\u0012=uKJt\u0017\r\u001c+f[B\u0004\u0016\r\u001e5\u0015\u0007\u0001\u000b'\rC\u0003@\u0017\u0001\u0007\u0001\tC\u0003d\u0017\u0001\u0007A-\u0001\u0006tGJ\fGo\u00195ESJ\u0004\"!\u001a7\u000f\u0005\u0019T\u0007CA4&\u001b\u0005A'BA5\"\u0003\u0019a$o\\8u}%\u00111.J\u0001\u0007!J,G-\u001a4\n\u00055t'AB*ue&twM\u0003\u0002lK\u0005Qb.Z<WKJ\u001c\u0018n\u001c8FqR,'O\\1m)\u0016l\u0007\u000fU1uQR\u0019\u0001)\u001d:\t\u000b}b\u0001\u0019\u0001!\t\u000bMd\u0001\u0019\u00013\u0002\u0015M$\u0018mZ5oO\u0012K'/A\u000bhKR,\u0005\u0010^3s]\u0006d7k\u0019:bi\u000eDG)\u001b:\u0015\t\u00013\u0018\u0011\u0001\u0005\u0006o6\u0001\r\u0001_\u0001\u0007Kb$XKU%\u0011\u0005etX\"\u0001>\u000b\u0005md\u0018a\u00018fi*\tQ0\u0001\u0003kCZ\f\u0017BA@{\u0005\r)&+\u0013\u0005\u0006g6\u0001\r\u0001Z\u0001\u000eO\u0016$8\u000b^1hS:<G)\u001b:\u0015\u000b\u0001\u000b9!a\u0003\t\r\u0005%a\u00021\u0001A\u0003%Ig\u000e];u!\u0006$\b\u000eC\u0003t\u001d\u0001\u0007A-\u0001\u0005jgN+(\rR5s)!\t\t\"a\u0006\u0002\u001c\u0005}\u0001c\u0001\u0013\u0002\u0014%\u0019\u0011QC\u0013\u0003\u000f\t{w\u000e\\3b]\"1\u0011\u0011D\bA\u0002\u0001\u000b!\u0001]\u0019\t\r\u0005uq\u00021\u0001A\u0003\t\u0001(\u0007\u0003\u0004D\u001f\u0001\u0007\u0011\u0011\u0005\t\u0004\u0003\u0006\r\u0012bAA\u0013\u0005\nQa)\u001b7f'f\u001cH/Z7\u0002\u0017\u0015DXmY;uS>t\u0017\nZ\u000b\u0002I\u0006iA-\u001a7fi\u0016$V\u000e\u001d)bi\"$\u0012\u0001V\u0001\u000eGJ,\u0017\r^3U[B\u0004\u0016\r\u001e5\u0002+\u0011,G.\u001a;f\u0013\u001atu\u000e^*uC\u001eLgn\u001a#jeR)A+!\u000e\u00028!)qh\u0005a\u0001\u0001\"11i\u0005a\u0001\u0003C\u0001")
public class HiveTempPath
implements Logging {
    private Path externalTempPath;
    private final SparkSession session;
    private final Configuration hadoopConf;
    private Path path;
    private Option<Path> stagingDirForCreating;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private Option<Path> stagingDirForCreating() {
        return this.stagingDirForCreating;
    }

    private void stagingDirForCreating_$eq(Option<Path> x$1) {
        this.stagingDirForCreating = x$1;
    }

    private Path externalTempPath$lzycompute() {
        HiveTempPath hiveTempPath = this;
        synchronized (hiveTempPath) {
            if (!this.bitmap$0) {
                this.externalTempPath = this.getExternalTmpPath(this.path);
                this.bitmap$0 = true;
            }
        }
        this.path = null;
        return this.externalTempPath;
    }

    public Path externalTempPath() {
        if (!this.bitmap$0) {
            return this.externalTempPath$lzycompute();
        }
        return this.externalTempPath;
    }

    private Path getExternalTmpPath(Path path) {
        scala.collection.immutable.Set hiveVersionsUsingOldExternalTempPath = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.HiveVersion[]{package$hive$v12$.MODULE$, package$hive$v13$.MODULE$, package$hive$v14$.MODULE$, package$hive$v1_0$.MODULE$}));
        scala.collection.immutable.Set hiveVersionsUsingNewExternalTempPath = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.HiveVersion[]{package$hive$v1_1$.MODULE$, package$hive$v1_2$.MODULE$, package$hive$v2_0$.MODULE$, package$hive$v2_1$.MODULE$, package$hive$v2_2$.MODULE$, package$hive$v2_3$.MODULE$, package$hive$v3_0$.MODULE$, package$hive$v3_1$.MODULE$}));
        Set set = hiveVersionsUsingNewExternalTempPath.$plus$plus((GenTraversableOnce)hiveVersionsUsingOldExternalTempPath);
        scala.collection.immutable.Set<package.HiveVersion> set2 = package$hive$.MODULE$.allSupportedHiveVersions();
        Predef$.MODULE$.assert(!(set != null ? !set.equals(set2) : set2 != null));
        ExternalCatalogWithListener externalCatalog = this.session.sharedState().externalCatalog();
        package.HiveVersion hiveVersion = ((HiveExternalCatalog)externalCatalog.unwrapped()).client().version();
        String stagingDir = this.hadoopConf().get("hive.exec.stagingdir", ".hive-staging");
        String scratchDir = this.hadoopConf().get("hive.exec.scratchdir", "/tmp/hive");
        if (hiveVersionsUsingOldExternalTempPath.contains((Object)hiveVersion)) {
            return this.oldVersionExternalTempPath(path, scratchDir);
        }
        if (hiveVersionsUsingNewExternalTempPath.contains((Object)hiveVersion)) {
            return this.newVersionExternalTempPath(path, stagingDir);
        }
        throw new IllegalStateException(new StringBuilder(26).append("Unsupported hive version: ").append(hiveVersion.fullVersion()).toString());
    }

    private Path oldVersionExternalTempPath(Path path, String scratchDir) {
        URI extURI = path.toUri();
        Path scratchPath = new Path(scratchDir, this.executionId());
        Path dirPath = new Path(extURI.getScheme(), extURI.getAuthority(), new StringBuilder(1).append(scratchPath.toUri().getPath()).append("-").append(TaskRunner.getTaskRunnerID()).toString());
        FileSystem fs = dirPath.getFileSystem(this.hadoopConf());
        dirPath = new Path(fs.makeQualified(dirPath).toString());
        this.stagingDirForCreating_$eq((Option<Path>)new Some((Object)dirPath));
        return dirPath;
    }

    private Path newVersionExternalTempPath(Path path, String stagingDir) {
        URI extURI = path.toUri();
        String string = extURI.getScheme();
        String string2 = "viewfs";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Path qualifiedStagingDir = this.getStagingDir(path, stagingDir);
            this.stagingDirForCreating_$eq((Option<Path>)new Some((Object)qualifiedStagingDir));
            return new Path(qualifiedStagingDir, "-ext-10000");
        }
        Path qualifiedStagingDir = this.getExternalScratchDir(extURI, stagingDir);
        this.stagingDirForCreating_$eq((Option<Path>)new Some((Object)qualifiedStagingDir));
        return new Path(qualifiedStagingDir, "-ext-10000");
    }

    private Path getExternalScratchDir(URI extURI, String stagingDir) {
        return this.getStagingDir(new Path(extURI.getScheme(), extURI.getAuthority(), extURI.getPath()), stagingDir);
    }

    public Path getStagingDir(Path inputPath, String stagingDir) {
        String inputPathName = inputPath.toString();
        FileSystem fs = inputPath.getFileSystem(this.hadoopConf());
        ObjectRef stagingPathName = ObjectRef.create((Object)(inputPathName.indexOf(stagingDir) == -1 ? new Path(inputPathName, stagingDir).toString() : inputPathName.substring(0, inputPathName.indexOf(stagingDir) + stagingDir.length())));
        if (this.isSubDir(new Path((String)stagingPathName.elem), inputPath, fs) && !new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString((String)stagingPathName.elem)).stripPrefix(inputPathName))).stripPrefix("/").startsWith(".")) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(143).append("The staging dir '").append((String)stagingPathName$1.elem).append("' should be a child directory starts ").append("with '.' to avoid being deleted if we set hive.exec.stagingdir under the table ").append("directory.").toString());
            stagingPathName.elem = new Path(inputPathName, ".hive-staging").toString();
        }
        Path dir = fs.makeQualified(new Path(new StringBuilder(2).append((String)stagingPathName.elem).append("_").append(this.executionId()).append("-").append(TaskRunner.getTaskRunnerID()).toString()));
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Created staging dir = ").append(dir).append(" for path = ").append(inputPath).toString());
        return dir;
    }

    private boolean isSubDir(Path p1, Path p2, FileSystem fs) {
        String path1 = new StringBuilder(1).append(fs.makeQualified(p1).toString()).append("/").toString();
        String path2 = new StringBuilder(1).append(fs.makeQualified(p2).toString()).append("/").toString();
        return path1.startsWith(path2);
    }

    private String executionId() {
        Random rand = new Random();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_SSS", Locale.US);
        return new StringBuilder(6).append("hive_").append(format.format(new Date())).append("_").append(Math.abs(rand.nextLong())).toString();
    }

    public void deleteTmpPath() {
        try {
            this.stagingDirForCreating().foreach((Function1 & Serializable & scala.Serializable)stagingDir -> {
                FileSystem fs = stagingDir.getFileSystem(this.hadoopConf());
                if (fs.delete(stagingDir, true)) {
                    return BoxesRunTime.boxToBoolean((boolean)fs.cancelDeleteOnExit(stagingDir));
                }
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String stagingDir2 = this.hadoopConf().get("hive.exec.stagingdir", ".hive-staging");
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Unable to delete staging directory: ").append(stagingDir2).append(".\n").append(e).toString());
            }
            throw throwable;
        }
    }

    public void createTmpPath() {
        try {
            this.stagingDirForCreating().foreach((Function1 & Serializable & scala.Serializable)stagingDir -> BoxesRunTime.boxToBoolean((boolean)HiveTempPath.$anonfun$createTmpPath$1(this, stagingDir)));
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.cannotCreateStagingDirError(new StringBuilder(4).append("'").append(this.stagingDirForCreating().toString()).append("': ").append(e.getMessage()).toString(), e);
        }
    }

    public void deleteIfNotStagingDir(Path path, FileSystem fs) {
        Option option = Option$.MODULE$.apply((Object)path);
        Option<Path> option2 = this.stagingDirForCreating();
        if (option == null ? option2 != null : !option.equals(option2)) {
            fs.delete(path, true);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$createTmpPath$1(HiveTempPath $this, Path stagingDir) {
        FileSystem fs = stagingDir.getFileSystem($this.hadoopConf());
        if (!FileUtils.mkdir((FileSystem)fs, (Path)stagingDir, (boolean)true, (Configuration)$this.hadoopConf())) {
            throw new IllegalStateException(new StringBuilder(35).append("Cannot create staging directory  '").append(stagingDir.toString()).append("'").toString());
        }
        return fs.deleteOnExit(stagingDir);
    }

    public HiveTempPath(SparkSession session, Configuration hadoopConf, Path path) {
        this.session = session;
        this.hadoopConf = hadoopConf;
        this.path = path;
        Logging.$init$((Logging)this);
        this.stagingDirForCreating = None$.MODULE$;
    }
}

