/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.util.Collection;
import java.util.List;
import jodd.typeconverter.TypeConverter;
import jodd.typeconverter.TypeConverterManagerBean;
import jodd.util.CsvUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongArrayConverter
implements TypeConverter<long[]> {
    protected final TypeConverterManagerBean typeConverterManagerBean;

    public LongArrayConverter(TypeConverterManagerBean typeConverterManagerBean) {
        this.typeConverterManagerBean = typeConverterManagerBean;
    }

    @Override
    public long[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (!valueClass.isArray()) {
            return this.convertValueToArray(value);
        }
        return this.convertArrayToArray(value);
    }

    protected long convertType(Object value) {
        return this.typeConverterManagerBean.convertType(value, Long.TYPE);
    }

    protected long[] convertToSingleElementArray(Object value) {
        return new long[]{this.convertType(value)};
    }

    protected long[] convertValueToArray(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            long[] target = new long[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Object element = list.get(i);
                target[i] = this.convertType(element);
            }
            return target;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            long[] target = new long[collection.size()];
            int i = 0;
            for (Object element : collection) {
                target[i] = this.convertType(element);
                ++i;
            }
            return target;
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            int count = 0;
            for (Object element : iterable) {
                ++count;
            }
            long[] target = new long[count];
            int i = 0;
            for (Object element : iterable) {
                target[i] = this.convertType(element);
                ++i;
            }
            return target;
        }
        if (value instanceof CharSequence) {
            String[] strings = CsvUtil.toStringArray(value.toString());
            return this.convertArrayToArray(strings);
        }
        return this.convertToSingleElementArray(value);
    }

    protected long[] convertArrayToArray(Object value) {
        long[] result;
        Class<?> valueComponentType = value.getClass().getComponentType();
        if (valueComponentType == Long.TYPE) {
            return (long[])value;
        }
        if (valueComponentType.isPrimitive()) {
            result = this.convertPrimitiveArrayToArray(value, valueComponentType);
        } else {
            Object[] array = (Object[])value;
            result = new long[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = this.convertType(array[i]);
            }
        }
        return result;
    }

    protected long[] convertPrimitiveArrayToArray(Object value, Class primitiveComponentType) {
        long[] result;
        block9: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block8: {
                                    result = null;
                                    if (primitiveComponentType == long[].class) {
                                        return (long[])value;
                                    }
                                    if (primitiveComponentType != Integer.TYPE) break block8;
                                    int[] array = (int[])value;
                                    result = new long[array.length];
                                    for (int i = 0; i < array.length; ++i) {
                                        result[i] = array[i];
                                    }
                                    break block9;
                                }
                                if (primitiveComponentType != Float.TYPE) break block10;
                                float[] array = (float[])value;
                                result = new long[array.length];
                                for (int i = 0; i < array.length; ++i) {
                                    result[i] = (long)array[i];
                                }
                                break block9;
                            }
                            if (primitiveComponentType != Double.TYPE) break block11;
                            double[] array = (double[])value;
                            result = new long[array.length];
                            for (int i = 0; i < array.length; ++i) {
                                result[i] = (long)array[i];
                            }
                            break block9;
                        }
                        if (primitiveComponentType != Short.TYPE) break block12;
                        short[] array = (short[])value;
                        result = new long[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            result[i] = array[i];
                        }
                        break block9;
                    }
                    if (primitiveComponentType != Byte.TYPE) break block13;
                    byte[] array = (byte[])value;
                    result = new long[array.length];
                    for (int i = 0; i < array.length; ++i) {
                        result[i] = array[i];
                    }
                    break block9;
                }
                if (primitiveComponentType != Character.TYPE) break block14;
                char[] array = (char[])value;
                result = new long[array.length];
                for (int i = 0; i < array.length; ++i) {
                    result[i] = array[i];
                }
                break block9;
            }
            if (primitiveComponentType != Boolean.TYPE) break block9;
            boolean[] array = (boolean[])value;
            result = new long[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = array[i] ? 1L : 0L;
            }
        }
        return result;
    }
}

