/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Base64;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnBase64$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str) - Converts the argument from a base 64 string `str` to a binary.", examples="\n    Examples:\n      > SELECT _FUNC_('U3BhcmsgU1FM');\n       Spark SQL\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001\u0002\u0010 \u00012B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\"A!\n\u0001BK\u0002\u0013\u00051\n\u0003\u0005P\u0001\tE\t\u0015!\u0003M\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u0015\u0001\u0006\u0001\"\u0001k\u0011\u0015i\u0007\u0001\"\u0015o\u0011\u0015!\b\u0001\"\u0011v\u0011\u001d\t9\u0001\u0001C)\u0003\u0013A\u0011\"a\u0004\u0001\u0003\u0003%\t!!\u0005\t\u0013\u0005]\u0001!%A\u0005\u0002\u0005e\u0001\"CA\u0018\u0001E\u0005I\u0011AA\u0019\u0011%\t)\u0004AA\u0001\n\u0003\n9\u0004C\u0005\u0002J\u0001\t\t\u0011\"\u0001\u0002L!I\u00111\u000b\u0001\u0002\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u00037\u0002\u0011\u0011!C!\u0003;B\u0011\"a\u001b\u0001\u0003\u0003%\t!!\u001c\t\u0013\u0005E\u0004!!A\u0005B\u0005MtaBAL?!\u0005\u0011\u0011\u0014\u0004\u0007=}A\t!a'\t\rA3B\u0011AAR\u0011\u001d\t)K\u0006C\u0001\u0003OC\u0011\"a/\u0017\u0003\u0003%\t)!0\t\u0013\u0005\rg#%A\u0005\u0002\u0005E\u0002\"CAc-\u0005\u0005I\u0011QAd\u0011%\tINFI\u0001\n\u0003\t\t\u0004C\u0005\u0002\\Z\t\t\u0011\"\u0003\u0002^\nAQK\u001c\"bg\u00164DG\u0003\u0002!C\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u00113%\u0001\u0005dCR\fG._:u\u0015\t!S%A\u0002tc2T!AJ\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005!J\u0013AB1qC\u000eDWMC\u0001+\u0003\ry'oZ\u0002\u0001'\u0019\u0001Q&\r\u001b<\u0003B\u0011afL\u0007\u0002?%\u0011\u0001g\b\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011aFM\u0005\u0003g}\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003kar!A\f\u001c\n\u0005]z\u0012a\u00029bG.\fw-Z\u0005\u0003si\u0012aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u00028?A\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t9\u0001K]8ek\u000e$\bC\u0001\u001fC\u0013\t\u0019UH\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003dQ&dG-F\u0001G!\tqs)\u0003\u0002I?\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003-1\u0017-\u001b7P]\u0016\u0013(o\u001c:\u0016\u00031\u0003\"\u0001P'\n\u00059k$a\u0002\"p_2,\u0017M\\\u0001\rM\u0006LGn\u00148FeJ|'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007I\u001bF\u000b\u0005\u0002/\u0001!)A)\u0002a\u0001\r\"9!*\u0002I\u0001\u0002\u0004a\u0015\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003]\u0003\"\u0001W.\u000e\u0003eS!AW\u0012\u0002\u000bQL\b/Z:\n\u0005qK&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001`!\r\u0001wm\u0016\b\u0003C\u001at!AY3\u000e\u0003\rT!\u0001Z\u0016\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0014BA\u001c>\u0013\tA\u0017NA\u0002TKFT!aN\u001f\u0015\u0005I[\u0007\"\u00027\t\u0001\u00041\u0015\u0001B3yaJ\fAB\\;mYN\u000bg-Z#wC2$\"a\u001c:\u0011\u0005q\u0002\u0018BA9>\u0005\r\te.\u001f\u0005\u0006g&\u0001\ra\\\u0001\u0007gR\u0014\u0018N\\4\u0002\u0013\u0011|w)\u001a8D_\u0012,G\u0003\u0002<}\u0003\u0007\u0001\"a\u001e>\u000e\u0003aT!!_\u0010\u0002\u000f\r|G-Z4f]&\u00111\u0010\u001f\u0002\t\u000bb\u0004(oQ8eK\")QP\u0003a\u0001}\u0006\u00191\r\u001e=\u0011\u0005]|\u0018bAA\u0001q\nq1i\u001c3fO\u0016t7i\u001c8uKb$\bBBA\u0003\u0015\u0001\u0007a/\u0001\u0002fm\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2AUA\u0006\u0011\u0019\tia\u0003a\u0001\r\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLH#\u0002*\u0002\u0014\u0005U\u0001b\u0002#\r!\u0003\u0005\rA\u0012\u0005\b\u00152\u0001\n\u00111\u0001M\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0007+\u0007\u0019\u000bib\u000b\u0002\u0002 A!\u0011\u0011EA\u0016\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012!C;oG\",7m[3e\u0015\r\tI#P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0017\u0003G\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\r+\u00071\u000bi\"A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003s\u0001B!a\u000f\u0002F5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%\u0001\u0003mC:<'BAA\"\u0003\u0011Q\u0017M^1\n\t\u0005\u001d\u0013Q\b\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u00055\u0003c\u0001\u001f\u0002P%\u0019\u0011\u0011K\u001f\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007=\f9\u0006C\u0005\u0002ZE\t\t\u00111\u0001\u0002N\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0018\u0011\u000b\u0005\u0005\u0014qM8\u000e\u0005\u0005\r$bAA3{\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00141\r\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002M\u0003_B\u0001\"!\u0017\u0014\u0003\u0003\u0005\ra\\\u0001\u0007KF,\u0018\r\\:\u0015\u00071\u000b)\b\u0003\u0005\u0002ZQ\t\t\u00111\u0001pQM\u0001\u0011\u0011PA@\u0003\u0003\u000b))a\"\u0002\f\u00065\u0015\u0011SAJ!\rq\u00131P\u0005\u0004\u0003{z\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u0007\u000bAj\u0018$V\u001d\u000e{\u0006f\u001d;sS\u0001j\u0003eQ8om\u0016\u0014Ho\u001d\u0011uQ\u0016\u0004\u0013M]4v[\u0016tG\u000f\t4s_6\u0004\u0013\r\t2bg\u0016\u0004c\u0007\u000e\u0011tiJLgn\u001a\u0011agR\u0014\b\r\t;pA\u0005\u0004#-\u001b8beft\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005%\u0015!\u0013\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OU\u001b$\t[2ng\u001e,\u0016GR'(SmR\u0001\u0005\t\u0011!A\u0001\u00023\u000b]1sW\u0002\u001a\u0016\u000b\u0014\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qR\u0001\u0006c9*d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003+\u000bAb\u001d;sS:<wLZ;oGN\f\u0001\"\u00168CCN,g\u0007\u000e\t\u0003]Y\u0019BAFAO\u0003B\u0019A(a(\n\u0007\u0005\u0005VH\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u00033\u000bQ\"[:WC2LGMQ1tKZ\"Dc\u0001'\u0002*\"9\u00111\u0016\rA\u0002\u00055\u0016!C:sGN#(/\u001b8h!\u0011\ty+a.\u000e\u0005\u0005E&b\u0001.\u00024*\u0019\u0011QW\u0013\u0002\rUt7/\u00194f\u0013\u0011\tI,!-\u0003\u0015U#f\tO*ue&tw-A\u0003baBd\u0017\u0010F\u0003S\u0003\u007f\u000b\t\rC\u0003E3\u0001\u0007a\tC\u0004K3A\u0005\t\u0019\u0001'\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002J\u0006U\u0007#\u0002\u001f\u0002L\u0006=\u0017bAAg{\t1q\n\u001d;j_:\u0004R\u0001PAi\r2K1!a5>\u0005\u0019!V\u000f\u001d7fe!A\u0011q[\u000e\u0002\u0002\u0003\u0007!+A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a8\u0011\t\u0005m\u0012\u0011]\u0005\u0005\u0003G\fiD\u0001\u0004PE*,7\r\u001e")
public class UnBase64
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression child;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$2() {
        return UnBase64$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(UnBase64 unBase64) {
        return UnBase64$.MODULE$.unapply(unBase64);
    }

    public static boolean apply$default$2() {
        return UnBase64$.MODULE$.apply$default$2();
    }

    public static boolean isValidBase64(UTF8String uTF8String) {
        return UnBase64$.MODULE$.isValidBase64(uTF8String);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public Object nullSafeEval(Object string) {
        if (this.failOnError() && !UnBase64$.MODULE$.isValidBase64((UTF8String)string)) {
            throw QueryExecutionErrors$.MODULE$.invalidInputInConversionError((DataType)BinaryType$.MODULE$, (UTF8String)string, UTF8String.fromString((String)"BASE64"), "try_to_binary");
        }
        return Base64.getMimeDecoder().decode(((UTF8String)string).toString());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)child -> {
            String string;
            if (this.failOnError()) {
                String unbase64 = new StringOps(Predef$.MODULE$.augmentString(UnBase64$.MODULE$.getClass().getName())).stripSuffix("$");
                String binaryType = ctx.addReferenceObj("to", BinaryType$.MODULE$, BinaryType$.MODULE$.getClass().getName());
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(250).append("\n           |if (!").append(unbase64).append(".isValidBase64(").append((String)child).append(")) {\n           |  throw QueryExecutionErrors.invalidInputInConversionError(\n           |    ").append(binaryType).append(",\n           |    ").append((String)child).append(",\n           |    UTF8String.fromString(\"BASE64\"),\n           |    \"try_to_binary\");\n           |}\n       ").toString())).stripMargin();
            } else {
                string = "";
            }
            String maybeValidateInputCode = string;
            return new StringBuilder(69).append("\n         ").append(maybeValidateInputCode).append("\n         ").append(ev.value()).append(" = ").append(Base64.class.getName()).append(".getMimeDecoder().decode(").append((String)child).append(".toString());\n       ").toString();
        });
    }

    @Override
    public UnBase64 withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.failOnError());
    }

    public UnBase64 copy(Expression child, boolean failOnError) {
        return new UnBase64(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "UnBase64";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UnBase64;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UnBase64)) return false;
        boolean bl = true;
        if (!bl) return false;
        UnBase64 unBase64 = (UnBase64)x$1;
        Expression expression = this.child();
        Expression expression2 = unBase64.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.failOnError() != unBase64.failOnError()) return false;
        if (!unBase64.canEqual(this)) return false;
        return true;
    }

    public UnBase64(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public UnBase64(Expression expr) {
        this(expr, false);
    }
}

