/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.text.BreakIterator;
import java.util.Locale;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Sentences$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str[, lang, country]) - Splits `str` into an array of array of words.", examples="\n    Examples:\n      > SELECT _FUNC_('Hi there! Good morning.');\n       [[\"Hi\",\"there\"],[\"Good\",\"morning\"]]\n  ", since="2.0.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\t5b\u0001\u0002\u0015*\u0001ZB\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\"A1\u000b\u0001BK\u0002\u0013\u0005a\n\u0003\u0005U\u0001\tE\t\u0015!\u0003P\u0011!)\u0006A!f\u0001\n\u0003q\u0005\u0002\u0003,\u0001\u0005#\u0005\u000b\u0011B(\t\u000b]\u0003A\u0011\u0001-\t\u000b]\u0003A\u0011A/\t\u000b]\u0003A\u0011A0\t\u000b\t\u0004A\u0011I2\t\u000b\u001d\u0004A\u0011\t5\t\u000b=\u0004A\u0011\t9\t\r\u0005\u0005\u0001\u0001\"\u0011O\u0011\u0019\t\u0019\u0001\u0001C!\u001d\"1\u0011Q\u0001\u0001\u0005B9Cq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002\u001e\u0001!I!a\b\t\u000f\u0005M\u0003\u0001\"\u0015\u0002V!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003[\u0002\u0011\u0013!C\u0001\u0003_B\u0011\"!\"\u0001#\u0003%\t!a\u001c\t\u0013\u0005\u001d\u0005!%A\u0005\u0002\u0005=\u0004\"CAE\u0001\u0005\u0005I\u0011IAF\u0011%\t9\nAA\u0001\n\u0003\tI\nC\u0005\u0002\"\u0002\t\t\u0011\"\u0001\u0002$\"I\u0011\u0011\u0016\u0001\u0002\u0002\u0013\u0005\u00131\u0016\u0005\n\u0003s\u0003\u0011\u0011!C\u0001\u0003wC\u0011\"a0\u0001\u0003\u0003%\t%!1\b\u0013\u0005\u0015\u0018&!A\t\u0002\u0005\u001dh\u0001\u0003\u0015*\u0003\u0003E\t!!;\t\r]sB\u0011AA|\u0011%\tIPHA\u0001\n\u000b\nY\u0010C\u0005\u0002~z\t\t\u0011\"!\u0002\u0000\"I!q\u0001\u0010\u0012\u0002\u0013\u0005\u0011q\u000e\u0005\n\u0005\u0013q\u0012\u0013!C\u0001\u0003_B\u0011Ba\u0003\u001f\u0003\u0003%\tI!\u0004\t\u0013\t}a$%A\u0005\u0002\u0005=\u0004\"\u0003B\u0011=E\u0005I\u0011AA8\u0011%\u0011\u0019CHA\u0001\n\u0013\u0011)CA\u0005TK:$XM\\2fg*\u0011!fK\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002-[\u0005A1-\u0019;bYf\u001cHO\u0003\u0002/_\u0005\u00191/\u001d7\u000b\u0005A\n\u0014!B:qCJ\\'B\u0001\u001a4\u0003\u0019\t\u0007/Y2iK*\tA'A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001omrDI\u0013\t\u0003qej\u0011!K\u0005\u0003u%\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tAD(\u0003\u0002>S\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002@\u00056\t\u0001I\u0003\u0002BS\u000591m\u001c3fO\u0016t\u0017BA\"A\u0005=\u0019u\u000eZ3hK:4\u0015\r\u001c7cC\u000e\\\u0007CA#I\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%a\u0002)s_\u0012,8\r\u001e\t\u0003\u000b.K!\u0001\u0014$\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0007M$(/F\u0001P!\tA\u0004+\u0003\u0002RS\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\tM$(\u000fI\u0001\tY\u0006tw-^1hK\u0006IA.\u00198hk\u0006<W\rI\u0001\bG>,h\u000e\u001e:z\u0003!\u0019w.\u001e8uef\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003Z5nc\u0006C\u0001\u001d\u0001\u0011\u0015iu\u00011\u0001P\u0011\u001d\u0019v\u0001%AA\u0002=Cq!V\u0004\u0011\u0002\u0003\u0007q\n\u0006\u0002Z=\")Q\n\u0003a\u0001\u001fR\u0019\u0011\fY1\t\u000b5K\u0001\u0019A(\t\u000bMK\u0001\u0019A(\u0002\u00119,H\u000e\\1cY\u0016,\u0012\u0001\u001a\t\u0003\u000b\u0016L!A\u001a$\u0003\u000f\t{w\u000e\\3b]\u0006AA-\u0019;b)f\u0004X-F\u0001j!\tQW.D\u0001l\u0015\taW&A\u0003usB,7/\u0003\u0002oW\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u001d\t\u0004ejlhBA:y\u001d\t!x/D\u0001v\u0015\t1X'\u0001\u0004=e>|GOP\u0005\u0002\u000f&\u0011\u0011PR\u0001\ba\u0006\u001c7.Y4f\u0013\tYHPA\u0002TKFT!!\u001f$\u0011\u0005)t\u0018BA@l\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-A\u0003gSJ\u001cH/\u0001\u0004tK\u000e|g\u000eZ\u0001\u0006i\"L'\u000fZ\u0001\u0005KZ\fG\u000e\u0006\u0003\u0002\f\u0005E\u0001cA#\u0002\u000e%\u0019\u0011q\u0002$\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u0014A\u0001\n\u00111\u0001\u0002\u0016\u0005)\u0011N\u001c9viB!\u0011qCA\r\u001b\u0005Y\u0013bAA\u000eW\tY\u0011J\u001c;fe:\fGNU8x\u000319W\r^*f]R,gnY3t)\u0019\t\t#!\f\u0002BA!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(-\nA!\u001e;jY&!\u00111FA\u0013\u0005A9UM\\3sS\u000e\f%O]1z\t\u0006$\u0018\rC\u0004\u00020E\u0001\r!!\r\u0002\u0013M,g\u000e^3oG\u0016\u001c\b\u0003BA\u001a\u0003wqA!!\u000e\u00028A\u0011AOR\u0005\u0004\u0003s1\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002>\u0005}\"AB*ue&twMC\u0002\u0002:\u0019Cq!a\u0011\u0012\u0001\u0004\t)%\u0001\u0004m_\u000e\fG.\u001a\t\u0005\u0003\u000f\ny%\u0004\u0002\u0002J)!\u0011qEA&\u0015\t\ti%\u0001\u0003kCZ\f\u0017\u0002BA)\u0003\u0013\u0012a\u0001T8dC2,\u0017aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u001dI\u0016qKA.\u0003?Ba!!\u0017\u0013\u0001\u0004y\u0015\u0001\u00038fo\u001aK'o\u001d;\t\r\u0005u#\u00031\u0001P\u0003%qWm^*fG>tG\r\u0003\u0004\u0002bI\u0001\raT\u0001\t]\u0016<H\u000b[5sI\u0006!1m\u001c9z)\u001dI\u0016qMA5\u0003WBq!T\n\u0011\u0002\u0003\u0007q\nC\u0004T'A\u0005\t\u0019A(\t\u000fU\u001b\u0002\u0013!a\u0001\u001f\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA9U\ry\u00151O\u0016\u0003\u0003k\u0002B!a\u001e\u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0010$\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0004\u0006e$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u00055\u0005\u0003BAH\u0003+k!!!%\u000b\t\u0005M\u00151J\u0001\u0005Y\u0006tw-\u0003\u0003\u0002>\u0005E\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCAAN!\r)\u0015QT\u0005\u0004\u0003?3%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0006\u0003KC\u0011\"a*\u001a\u0003\u0003\u0005\r!a'\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u000b\u0005\u0004\u00020\u0006U\u00161B\u0007\u0003\u0003cS1!a-G\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003o\u000b\tL\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00013\u0002>\"I\u0011qU\u000e\u0002\u0002\u0003\u0007\u00111B\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u0011\f\u0019\rC\u0005\u0002(r\t\t\u00111\u0001\u0002\f!\u001a\u0002!a2\u0002N\u0006=\u00171[Ak\u00033\fY.a8\u0002bB\u0019\u0001(!3\n\u0007\u0005-\u0017FA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005E\u0017\u0001T0G+:\u001bu\fK:uenc\u0003\u0005\\1oO2\u00023m\\;oiJLX,\u000b\u0011.AM\u0003H.\u001b;tA\u0001\u001cHO\u001d1!S:$x\u000eI1oA\u0005\u0014(/Y=!_\u001a\u0004\u0013M\u001d:bs\u0002zg\rI<pe\u0012\u001ch&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t9.\u00018\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dB\u0015\u000e\t;iKJ,\u0017\u0005I$p_\u0012\u0004Sn\u001c:oS:<gfJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am[&\u0005S5#Y\t\"\b.\u001a:fEuc3LI$p_\u0012\u0014CFI7pe:Lgn\u001a\u0012^;*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002^\u0006)!G\f\u0019/a\u0005)qM]8va\u0006\u0012\u00111]\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\n'\u0016tG/\u001a8dKN\u0004\"\u0001\u000f\u0010\u0014\ty\tYO\u0013\t\t\u0003[\f\u0019pT(P36\u0011\u0011q\u001e\u0006\u0004\u0003c4\u0015a\u0002:v]RLW.Z\u0005\u0005\u0003k\fyOA\tBEN$(/Y2u\rVt7\r^5p]N\"\"!a:\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!$\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fe\u0013\tAa\u0001\u0003\u0006!)Q*\ta\u0001\u001f\"91+\tI\u0001\u0002\u0004y\u0005bB+\"!\u0003\u0005\raT\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t=!1\u0004\t\u0006\u000b\nE!QC\u0005\u0004\u0005'1%AB(qi&|g\u000e\u0005\u0004F\u0005/yujT\u0005\u0004\u000531%A\u0002+va2,7\u0007\u0003\u0005\u0003\u001e\u0011\n\t\u00111\u0001Z\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u001d\u0002\u0003BAH\u0005SIAAa\u000b\u0002\u0012\n1qJ\u00196fGR\u0004")
public class Sentences
extends TernaryExpression
implements ImplicitCastInputTypes,
CodegenFallback,
Serializable {
    private final Expression str;
    private final Expression language;
    private final Expression country;

    public static Expression $lessinit$greater$default$3() {
        return Sentences$.MODULE$.$lessinit$greater$default$3();
    }

    public static Expression $lessinit$greater$default$2() {
        return Sentences$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Sentences sentences) {
        return Sentences$.MODULE$.unapply(sentences);
    }

    public static Expression apply$default$3() {
        return Sentences$.MODULE$.apply$default$3();
    }

    public static Expression apply$default$2() {
        return Sentences$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Sentences> tupled() {
        return Sentences$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Sentences>>> curried() {
        return Sentences$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression language() {
        return this.language;
    }

    public Expression country() {
        return this.country;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return new ArrayType((DataType)new ArrayType((DataType)StringType$.MODULE$, false), false);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public Expression first() {
        return this.str();
    }

    @Override
    public Expression second() {
        return this.language();
    }

    @Override
    public Expression third() {
        return this.country();
    }

    @Override
    public Object eval(InternalRow input) {
        Object string = this.str().eval(input);
        if (string == null) {
            return null;
        }
        UTF8String languageStr = (UTF8String)this.language().eval(input);
        UTF8String countryStr = (UTF8String)this.country().eval(input);
        Locale locale = languageStr != null && countryStr != null ? new Locale(languageStr.toString(), countryStr.toString()) : Locale.US;
        return this.getSentences(((UTF8String)string).toString(), locale);
    }

    private GenericArrayData getSentences(String sentences, Locale locale) {
        BreakIterator bi = BreakIterator.getSentenceInstance(locale);
        bi.setText(sentences);
        int idx = 0;
        ArrayBuffer result = new ArrayBuffer();
        while (bi.next() != -1) {
            String sentence = sentences.substring(idx, bi.current());
            idx = bi.current();
            BreakIterator wi = BreakIterator.getWordInstance(locale);
            int widx = 0;
            wi.setText(sentence);
            ArrayBuffer words = new ArrayBuffer();
            while (wi.next() != -1) {
                String word = sentence.substring(widx, wi.current());
                widx = wi.current();
                Object object = Character.isLetterOrDigit(word.charAt(0)) ? words.$plus$eq((Object)UTF8String.fromString((String)word)) : BoxedUnit.UNIT;
            }
            result.$plus$eq((Object)new GenericArrayData((Seq<Object>)words));
        }
        return new GenericArrayData((Seq<Object>)result);
    }

    @Override
    public Sentences withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public Sentences copy(Expression str, Expression language, Expression country) {
        return new Sentences(str, language, country);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.language();
    }

    public Expression copy$default$3() {
        return this.country();
    }

    @Override
    public String productPrefix() {
        return "Sentences";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.str();
            }
            case 1: {
                return this.language();
            }
            case 2: {
                return this.country();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sentences;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sentences)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sentences sentences = (Sentences)x$1;
        Expression expression = this.str();
        Expression expression2 = sentences.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.language();
        Expression expression4 = sentences.language();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.country();
        Expression expression6 = sentences.country();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!sentences.canEqual(this)) return false;
        return true;
    }

    public Sentences(Expression str, Expression language, Expression country) {
        this.str = str;
        this.language = language;
        this.country = country;
        ExpectsInputTypes.$init$(this);
        CodegenFallback.$init$(this);
    }

    public Sentences(Expression str) {
        this(str, Literal$.MODULE$.apply(""), Literal$.MODULE$.apply(""));
    }

    public Sentences(Expression str, Expression language) {
        this(str, language, Literal$.MODULE$.apply(""));
    }
}

