/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.streaming.util.FileBasedWriteAheadLog;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.parallel.ExecutionContextTaskSupport;
import scala.collection.parallel.TaskSupport;
import scala.collection.parallel.immutable.ParVector;
import scala.collection.parallel.immutable.ParVector$;
import scala.concurrent.ExecutionContext;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

public final class FileBasedWriteAheadLog$ {
    public static FileBasedWriteAheadLog$ MODULE$;
    private final Regex logFileRegex;

    static {
        new FileBasedWriteAheadLog$();
    }

    public Regex logFileRegex() {
        return this.logFileRegex;
    }

    public String timeToLogFile(long startTime, long stopTime) {
        return new StringBuilder(5).append("log-").append(startTime).append("-").append(stopTime).toString();
    }

    public Option<String> getCallerName() {
        Seq ignoreList = (Seq)new .colon.colon((Object)"WriteAheadLog", (List)new .colon.colon((Object)"Logging", (List)new .colon.colon((Object)"java.lang", (List)new .colon.colon((Object)"scala.", (List)Nil$.MODULE$))));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace())).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getClassName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).find((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FileBasedWriteAheadLog$.$anonfun$getCallerName$2(ignoreList, c))).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$9.split("\\."))).lastOption()).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$10.split("\\$\\$"))).headOption());
    }

    public Seq<FileBasedWriteAheadLog.LogInfo> logFilesTologInfo(Seq<Path> files) {
        return (Seq)((SeqLike)files.flatMap((Function1 & Serializable & scala.Serializable)file -> {
            Option option = MODULE$.logFileRegex().findFirstIn((CharSequence)file.getName());
            if (option instanceof Some) {
                Some some = (Some)option;
                String string = (String)some.value();
                Option option2 = MODULE$.logFileRegex().unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                    String startTimeStr = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    String stopTimeStr = (String)((LinearSeqOptimized)option2.get()).apply(1);
                    long startTime = new StringOps(Predef$.MODULE$.augmentString(startTimeStr)).toLong();
                    long stopTime = new StringOps(Predef$.MODULE$.augmentString(stopTimeStr)).toLong();
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new FileBasedWriteAheadLog.LogInfo(startTime, stopTime, file.toString())));
                }
            }
            if (None$.MODULE$.equals(option) ? true : option instanceof Some) {
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            throw new MatchError((Object)option);
        }, Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.startTime()), (Ordering)Ordering.Long$.MODULE$);
    }

    public <I, O> Iterator<O> seqToParIterator(ExecutionContext executionContext, Seq<I> source, Function1<I, Iterator<O>> handler) {
        ExecutionContextTaskSupport taskSupport = new ExecutionContextTaskSupport(executionContext);
        int groupSize = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(taskSupport.parallelismLevel()), 8);
        return TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)source.grouped(groupSize).flatMap((Function1 & Serializable & scala.Serializable)group -> {
            ParVector parallelCollection = new ParVector(group.toVector());
            parallelCollection.tasksupport_$eq((TaskSupport)taskSupport);
            return (ParVector)parallelCollection.map(handler, (CanBuildFrom)ParVector$.MODULE$.canBuildFrom());
        }), (Function1)Predef$.MODULE$.$conforms()).flatten();
    }

    public static final /* synthetic */ boolean $anonfun$getCallerName$2(Seq ignoreList$1, String c) {
        return !ignoreList$1.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)c.contains(x$1)));
    }

    private FileBasedWriteAheadLog$() {
        MODULE$ = this;
        this.logFileRegex = new StringOps(Predef$.MODULE$.augmentString("log-(\\d+)-(\\d+)")).r();
    }
}

