/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.Serializable;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.exceptions.ResourceNotFoundException;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.apache.spark.resource.ResourceID;
import org.apache.spark.resource.ResourceUtils$;
import org.apache.spark.util.CausedBy$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class ResourceRequestHelper$
implements Logging {
    public static ResourceRequestHelper$ MODULE$;
    private final Regex AMOUNT_AND_UNIT_REGEX;
    private volatile int numResourceErrors;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ResourceRequestHelper$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Regex AMOUNT_AND_UNIT_REGEX() {
        return this.AMOUNT_AND_UNIT_REGEX;
    }

    private int numResourceErrors() {
        return this.numResourceErrors;
    }

    private void numResourceErrors_$eq(int x$1) {
        this.numResourceErrors = x$1;
    }

    public Map<String, String> getYarnResourcesAndAmounts(SparkConf sparkConf, String componentName) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkConf.getAllWithPrefix(String.valueOf(componentName)))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                int splitIndex = key.lastIndexOf(46);
                if (splitIndex == -1) {
                    String errorMessage = new StringBuilder(89).append("Missing suffix for ").append(componentName).append(key).append(", you must specify").append(" a suffix - ").append(ResourceUtils$.MODULE$.AMOUNT()).append(" is currently the only supported suffix.").toString();
                    throw new IllegalArgumentException(errorMessage);
                }
                String resourceName = key.substring(0, splitIndex);
                String resourceSuffix = key.substring(splitIndex + 1);
                if (!ResourceUtils$.MODULE$.AMOUNT().equals(resourceSuffix)) {
                    String errorMessage = new StringBuilder(47).append("Unsupported suffix: ").append(resourceSuffix).append(" in: ").append(componentName).append(key).append(", ").append("only .").append(ResourceUtils$.MODULE$.AMOUNT()).append(" is supported.").toString();
                    throw new IllegalArgumentException(errorMessage);
                }
                return new Tuple2((Object)resourceName, (Object)value);
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, String> getResourceNameMapping(SparkConf sparkConf) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ResourceUtils$.MODULE$.GPU()), sparkConf.get(package$.MODULE$.YARN_GPU_DEVICE())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ResourceUtils$.MODULE$.FPGA()), sparkConf.get(package$.MODULE$.YARN_FPGA_DEVICE()))}));
    }

    public Map<String, String> getYarnResourcesFromSparkResources(String confPrefix, SparkConf sparkConf) {
        return (Map)((TraversableLike)this.getResourceNameMapping(sparkConf).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String rName = (String)tuple2._1();
                String yarnName = (String)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)yarnName), (Object)sparkConf.get(new ResourceID(confPrefix, rName).amountConf(), "0"));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ResourceRequestHelper$.$anonfun$getYarnResourcesFromSparkResources$2(x0$2)));
    }

    public void validateResources(SparkConf sparkConf) {
        Seq resourceDefinitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package$.MODULE$.AM_MEMORY().key(), (Object)new StringBuilder(6).append(package$.MODULE$.YARN_AM_RESOURCE_TYPES_PREFIX()).append("memory").toString()), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key(), (Object)new StringBuilder(6).append(package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX()).append("memory").toString()), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key(), (Object)new StringBuilder(6).append(package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX()).append("memory").toString()), new Tuple2((Object)package$.MODULE$.AM_MEMORY().key(), (Object)new StringBuilder(2).append(package$.MODULE$.YARN_AM_RESOURCE_TYPES_PREFIX()).append("mb").toString()), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key(), (Object)new StringBuilder(2).append(package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX()).append("mb").toString()), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key(), (Object)new StringBuilder(2).append(package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX()).append("mb").toString()), new Tuple2((Object)package$.MODULE$.AM_MEMORY().key(), (Object)new StringBuilder(9).append(package$.MODULE$.YARN_AM_RESOURCE_TYPES_PREFIX()).append("memory-mb").toString()), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key(), (Object)new StringBuilder(9).append(package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX()).append("memory-mb").toString()), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key(), (Object)new StringBuilder(9).append(package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX()).append("memory-mb").toString()), new Tuple2((Object)package$.MODULE$.AM_CORES().key(), (Object)new StringBuilder(5).append(package$.MODULE$.YARN_AM_RESOURCE_TYPES_PREFIX()).append("cores").toString()), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_CORES().key(), (Object)new StringBuilder(5).append(package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX()).append("cores").toString()), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES().key(), (Object)new StringBuilder(5).append(package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX()).append("cores").toString()), new Tuple2((Object)package$.MODULE$.AM_CORES().key(), (Object)new StringBuilder(6).append(package$.MODULE$.YARN_AM_RESOURCE_TYPES_PREFIX()).append("vcores").toString()), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_CORES().key(), (Object)new StringBuilder(6).append(package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX()).append("vcores").toString()), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES().key(), (Object)new StringBuilder(6).append(package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX()).append("vcores").toString()), new Tuple2((Object)package$.MODULE$.AM_CORES().key(), (Object)new StringBuilder(10).append(package$.MODULE$.YARN_AM_RESOURCE_TYPES_PREFIX()).append("cpu-vcores").toString()), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_CORES().key(), (Object)new StringBuilder(10).append(package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX()).append("cpu-vcores").toString()), new Tuple2((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES().key(), (Object)new StringBuilder(10).append(package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX()).append("cpu-vcores").toString()), new Tuple2((Object)new ResourceID(org.apache.spark.internal.config.package$.MODULE$.SPARK_EXECUTOR_PREFIX(), "fpga").amountConf(), (Object)new StringBuilder(0).append(package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX()).append(sparkConf.get(package$.MODULE$.YARN_FPGA_DEVICE())).toString()), new Tuple2((Object)new ResourceID(org.apache.spark.internal.config.package$.MODULE$.SPARK_DRIVER_PREFIX(), "fpga").amountConf(), (Object)new StringBuilder(0).append(package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX()).append(sparkConf.get(package$.MODULE$.YARN_FPGA_DEVICE())).toString()), new Tuple2((Object)new ResourceID(org.apache.spark.internal.config.package$.MODULE$.SPARK_EXECUTOR_PREFIX(), "gpu").amountConf(), (Object)new StringBuilder(0).append(package$.MODULE$.YARN_EXECUTOR_RESOURCE_TYPES_PREFIX()).append(sparkConf.get(package$.MODULE$.YARN_GPU_DEVICE())).toString()), new Tuple2((Object)new ResourceID(org.apache.spark.internal.config.package$.MODULE$.SPARK_DRIVER_PREFIX(), "gpu").amountConf(), (Object)new StringBuilder(0).append(package$.MODULE$.YARN_DRIVER_RESOURCE_TYPES_PREFIX()).append(sparkConf.get(package$.MODULE$.YARN_GPU_DEVICE())).toString())}));
        scala.collection.mutable.StringBuilder errorMessage = new scala.collection.mutable.StringBuilder();
        resourceDefinitions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String sparkName = (String)tuple2._1();
                String resourceRequest = (String)tuple2._2();
                String resourceRequestAmount = new StringBuilder(1).append(resourceRequest).append(".").append(ResourceUtils$.MODULE$.AMOUNT()).toString();
                if (sparkConf.contains(resourceRequestAmount)) {
                    return errorMessage.append(new StringBuilder(41).append("Error: Do not use ").append(resourceRequestAmount).append(", ").append("please use ").append(sparkName).append(" instead!\n").toString());
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        });
        if (errorMessage.nonEmpty()) {
            throw new SparkException(errorMessage.toString());
        }
    }

    public void setResourceRequests(Map<String, String> resources, Resource resource) {
        Predef$.MODULE$.require(resource != null, (Function0 & Serializable & scala.Serializable)() -> "Resource parameter should not be null!");
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Custom resources requested: ").append(resources).toString());
        if (resources.isEmpty()) {
            return;
        }
        resources.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ResourceRequestHelper$.$anonfun$setResourceRequests$3(resource, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private ResourceInformation createResourceInformation(String resourceName, long amount, String unit) {
        if (new StringOps(Predef$.MODULE$.augmentString(unit)).nonEmpty()) {
            return ResourceInformation.newInstance((String)resourceName, (String)unit, (long)amount);
        }
        return ResourceInformation.newInstance((String)resourceName, (long)amount);
    }

    public static final /* synthetic */ boolean $anonfun$getYarnResourcesFromSparkResources$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String count = (String)tuple2._2();
            return new StringOps(Predef$.MODULE$.augmentString(count)).toLong() > 0L;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$setResourceRequests$3(Resource resource$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            String name = (String)tuple2._1();
            String rawAmount = (String)tuple2._2();
            try {
                String string = rawAmount;
                Option option = MODULE$.AMOUNT_AND_UNIT_REGEX().unapplySeq((CharSequence)string);
                if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) {
                    throw new MatchError((Object)string);
                }
                String amountPart = (String)((LinearSeqOptimized)option.get()).apply(0);
                String unitPart = (String)((LinearSeqOptimized)option.get()).apply(1);
                Tuple2 tuple22 = new Tuple2((Object)amountPart, (Object)unitPart);
                String amountPart2 = (String)tuple22._1();
                String unitPart2 = (String)tuple22._2();
                long amount = new StringOps(Predef$.MODULE$.augmentString(amountPart2)).toLong();
                String string2 = unitPart2;
                String unit = "g".equals(string2) ? "G" : ("t".equals(string2) ? "T" : ("p".equals(string2) ? "P" : unitPart2));
                MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Registering resource with name: ").append(name).append(", amount: ").append(amount).append(", unit: ").append(unit).toString());
                ResourceInformation resourceInformation = MODULE$.createResourceInformation(name, amount, unit);
                resource$1.setResourceInformation(name, resourceInformation);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                Throwable e;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof MatchError) {
                    throw new IllegalArgumentException(new StringBuilder(53).append("Resource request for '").append(name).append("' ('").append(rawAmount).append("') ").append("does not match pattern ").append(MODULE$.AMOUNT_AND_UNIT_REGEX()).append(".").toString());
                }
                Option option = CausedBy$.MODULE$.unapply(throwable2);
                if (!option.isEmpty() && (e = (Throwable)option.get()) instanceof IllegalArgumentException) {
                    IllegalArgumentException illegalArgumentException = (IllegalArgumentException)e;
                    throw new IllegalArgumentException(new StringBuilder(22).append("Invalid request for ").append(name).append(": ").append(illegalArgumentException.getMessage()).toString());
                }
                if (throwable2 instanceof ResourceNotFoundException) {
                    ResourceNotFoundException resourceNotFoundException = (ResourceNotFoundException)throwable2;
                    if (MODULE$.numResourceErrors() < 2) {
                        MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(129).append("YARN doesn't know about resource ").append(name).append(", your resource discovery ").append("has to handle properly discovering and isolating the resource! Error: ").append(resourceNotFoundException.getMessage()).toString());
                        MODULE$.numResourceErrors_$eq(MODULE$.numResourceErrors() + 1);
                    }
                } else {
                    throw throwable;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private ResourceRequestHelper$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.AMOUNT_AND_UNIT_REGEX = new StringOps(Predef$.MODULE$.augmentString("([0-9]+)([A-Za-z]*)")).r();
        this.numResourceErrors = 0;
    }
}

