/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat.test;

import java.io.Serializable;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.stat.inference.KolmogorovSmirnovTest;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.stat.test.KolmogorovSmirnovTest$NullHypothesis$;
import org.apache.spark.mllib.stat.test.KolmogorovSmirnovTestResult;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class KolmogorovSmirnovTest$
implements Logging {
    public static KolmogorovSmirnovTest$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new KolmogorovSmirnovTest$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public KolmogorovSmirnovTestResult testOneSample(RDD<Object> data, String distName, double ... params) {
        return this.testOneSample(data, distName, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(params));
    }

    public KolmogorovSmirnovTestResult testOneSample(RDD<Object> data, Function1<Object, Object> cdf) {
        double n = data.count();
        RDD qual$1 = data.sortBy((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> x, data.sortBy$default$2(), data.sortBy$default$3(), (Ordering)Ordering.Double$.MODULE$, ClassTag$.MODULE$.Double());
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)part -> {
            Iterator<Tuple2<Object, Object>> partDiffs = MODULE$.oneSampleDifferences((Iterator<Object>)part, n, cdf);
            return MODULE$.searchOneSampleCandidates(partDiffs);
        };
        boolean x$2 = qual$1.mapPartitions$default$2();
        Tuple3[] localData = (Tuple3[])qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple3.class)).collect();
        double ksStat = this.searchOneSampleStatistic(localData, n);
        return this.evalOneSampleP(ksStat, (long)n);
    }

    public KolmogorovSmirnovTestResult testOneSample(RDD<Object> data, RealDistribution distObj) {
        JFunction1.mcDD.sp & Serializable & scala.Serializable cdf = (JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> distObj.cumulativeProbability(x);
        return this.testOneSample(data, (Function1<Object, Object>)cdf);
    }

    private Iterator<Tuple2<Object, Object>> oneSampleDifferences(Iterator<Object> partData, double n, Function1<Object, Object> cdf) {
        return partData.zipWithIndex().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                double v = tuple2._1$mcD$sp();
                int ix = tuple2._2$mcI$sp();
                double dp = (double)(ix + 1) / n;
                double dl = (double)ix / n;
                double cdfVal = cdf.apply$mcDD$sp(v);
                return new Tuple2.mcDD.sp(dl - cdfVal, dp - cdfVal);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Iterator<Tuple3<Object, Object, Object>> searchOneSampleCandidates(Iterator<Tuple2<Object, Object>> partDiffs) {
        Tuple3 pResults;
        Tuple3 initAcc = new Tuple3((Object)BoxesRunTime.boxToDouble((double)Double.MAX_VALUE), (Object)BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue()), (Object)BoxesRunTime.boxToDouble((double)0.0));
        Tuple3 tuple3 = pResults = (Tuple3)partDiffs.foldLeft((Object)initAcc, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple3 tuple3 = (Tuple3)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple3 != null) {
                    double pMin = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                    double pMax = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                    double pCt = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                    if (tuple22 != null) {
                        double dl = tuple22._1$mcD$sp();
                        double dp = tuple22._2$mcD$sp();
                        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.min(pMin, dl)), (Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.max(pMax, dp)), (Object)BoxesRunTime.boxToDouble((double)(pCt + 1.0)));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        Tuple3 tuple32 = initAcc;
        Tuple3[] results = !(tuple3 != null ? !tuple3.equals(tuple32) : tuple32 != null) ? (Tuple3[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple3.class)) : (Tuple3[])((Object[])new Tuple3[]{pResults});
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])results)).iterator();
    }

    private double searchOneSampleStatistic(Tuple3<Object, Object, Object>[] localData, double n) {
        Tuple2.mcDD.sp initAcc = new Tuple2.mcDD.sp(Double$.MODULE$.MinValue(), 0.0);
        Tuple2 results = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])localData)).foldLeft((Object)initAcc, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple3 tuple3 = (Tuple3)tuple2._2();
                if (tuple22 != null) {
                    double prevMax = tuple22._1$mcD$sp();
                    double prevCt = tuple22._2$mcD$sp();
                    if (tuple3 != null) {
                        double minCand = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                        double maxCand = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                        double ct = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                        double adjConst = prevCt / n;
                        double dist1 = package$.MODULE$.abs(minCand + adjConst);
                        double dist2 = package$.MODULE$.abs(maxCand + adjConst);
                        double maxVal = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{prevMax, dist1, dist2})).max((Ordering)Ordering.Double$.MODULE$));
                        return new Tuple2.mcDD.sp(maxVal, prevCt + ct);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return results._1$mcD$sp();
    }

    public KolmogorovSmirnovTestResult testOneSample(RDD<Object> data, String distName, Seq<Object> params) {
        NormalDistribution normalDistribution;
        String string = distName;
        if ("norm".equals(string)) {
            if (params.nonEmpty()) {
                Predef$.MODULE$.require(params.length() == 2, (Function0 & Serializable & scala.Serializable)() -> "Normal distribution requires mean and standard deviation as parameters");
                normalDistribution = new NormalDistribution(BoxesRunTime.unboxToDouble((Object)params.apply(0)), BoxesRunTime.unboxToDouble((Object)params.apply(1)));
            } else {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No parameters specified for normal distribution,initialized to standard normal (i.e. N(0, 1))");
                normalDistribution = new NormalDistribution(0.0, 1.0);
            }
        } else {
            throw new UnsupportedOperationException(new StringBuilder(76).append(distName).append(" not yet supported through").append(" convenience method. Current options are:['norm'].").toString());
        }
        NormalDistribution distObj = normalDistribution;
        return this.testOneSample(data, (RealDistribution)distObj);
    }

    private KolmogorovSmirnovTestResult evalOneSampleP(double ksStat, long n) {
        double pval = 1.0 - new KolmogorovSmirnovTest().cdf(ksStat, (int)n);
        return new KolmogorovSmirnovTestResult(pval, ksStat, KolmogorovSmirnovTest$NullHypothesis$.MODULE$.OneSampleTwoSided().toString());
    }

    private KolmogorovSmirnovTest$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

