/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.MismatchedReferenceSystemException;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.CRS;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class RTreeNode
extends GeneralEnvelope {
    private static final long serialVersionUID = -6544217991652682694L;
    private RTreeNode parent;
    private RTreeNode firstChild;
    private RTreeNode sibling;

    public RTreeNode(Envelope area) {
        super(area);
    }

    public final RTreeNode getParent() {
        return this.parent;
    }

    public final List<RTreeNode> getChildren() {
        ArrayList<RTreeNode> children = new ArrayList<RTreeNode>();
        RTreeNode child = this.firstChild;
        while (child != null) {
            assert (child.parent == this) : child;
            children.add(child);
            child = child.sibling;
        }
        return children;
    }

    public static void walk(RTreeNode node, Consumer<? super RTreeNode> action) {
        while (node != null) {
            action.accept(node);
            RTreeNode.walk(node.firstChild, action);
            node = node.sibling;
        }
    }

    public final void addNode(RTreeNode node) {
        while (node != null) {
            RTreeNode next;
            block2: {
                next = node.sibling;
                node.sibling = null;
                RTreeNode receiver = this;
                do {
                    RTreeNode tail = receiver;
                    if (receiver.tryAddChild(node)) break block2;
                } while ((receiver = receiver.sibling) != null);
                tail.sibling = node;
                node.parent = this.parent;
            }
            node = next;
        }
    }

    private boolean tryAddChild(RTreeNode candidate) {
        assert (candidate.sibling == null) : candidate;
        if (this.contains(candidate)) {
            RTreeNode child = this.firstChild;
            if (child == null) {
                this.firstChild = candidate;
            } else {
                do {
                    RTreeNode lastChild = child;
                    if (!child.tryAddChild(candidate)) continue;
                    return true;
                } while ((child = child.sibling) != null);
                lastChild.sibling = candidate;
            }
            candidate.parent = this;
            return true;
        }
        return false;
    }

    public final RTreeNode finish() {
        Uniformizer action = new Uniformizer();
        RTreeNode.walk(this, action);
        action.set = true;
        RTreeNode.walk(this, action);
        RTreeNode next = this.sibling;
        if (next == null) {
            return this;
        }
        this.parent = new RTreeNode(this);
        this.parent.firstChild = this;
        do {
            this.parent.add(next);
            next.parent = this.parent;
        } while ((next = next.sibling) != null);
        return this.parent;
    }

    public static RTreeNode locate(RTreeNode node, DirectPosition pos) {
        RTreeNode skip = null;
        if (node != null) {
            do {
                if (node.contains(pos)) {
                    RTreeNode candidate = node.firstChild;
                    while (candidate != null) {
                        if (candidate != skip && candidate.contains(pos)) {
                            node = candidate;
                            candidate = node.firstChild;
                            continue;
                        }
                        candidate = candidate.sibling;
                    }
                    return node;
                }
                skip = node;
            } while ((node = node.parent) != null);
        }
        return null;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 37 * this.getChildren().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.getChildren().equals(((RTreeNode)obj).getChildren());
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        return "Domain";
    }

    @Override
    public String toString() {
        return this.toTree().toString();
    }

    public final TreeTable toTree() {
        DefaultTreeTable tree = new DefaultTreeTable(new TableColumn[]{TableColumn.VALUE});
        this.toTree(tree.getRoot());
        return tree;
    }

    private void toTree(TreeTable.Node addTo) {
        addTo.setValue(TableColumn.VALUE, (Object)super.toString());
        for (RTreeNode child : this.getChildren()) {
            child.toTree(addTo.newChild());
        }
    }

    private static final class Uniformizer
    implements Consumer<RTreeNode> {
        private CoordinateReferenceSystem common;
        boolean set;

        private Uniformizer() {
        }

        @Override
        public void accept(RTreeNode node) {
            if (this.set) {
                node.setCoordinateReferenceSystem(this.common);
            } else {
                CoordinateReferenceSystem crs = node.getCoordinateReferenceSystem();
                if (this.common == null) {
                    this.common = crs;
                } else if (crs != null && !CRS.equivalent(this.common, crs)) {
                    throw new MismatchedReferenceSystemException(Errors.format((short)98));
                }
            }
        }
    }
}

