/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Collection;
import java.util.Optional;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStoreRegistry;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.base.Capability;
import org.apache.sis.storage.image.DataStoreFilter;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.geometry.Envelope;

public final class DataStores
extends Static {
    private DataStores() {
    }

    public static Collection<DataStoreProvider> providers() {
        return DataStoreRegistry.INSTANCE;
    }

    public static String probeContentType(Object storage) throws DataStoreException {
        return DataStoreRegistry.INSTANCE.probeContentType(storage);
    }

    public static DataStore open(Object storage) throws UnsupportedStorageException, DataStoreException {
        return DataStoreRegistry.INSTANCE.open(storage, Capability.READ, null);
    }

    public static DataStore open(Object storage, String preferredFormat) throws UnsupportedStorageException, DataStoreException {
        DataStoreFilter preferred = null;
        if (preferredFormat != null) {
            preferred = new DataStoreFilter(preferredFormat, false);
        }
        return DataStoreRegistry.INSTANCE.open(storage, Capability.READ, preferred);
    }

    public static DataStore openWritable(Object storage, String preferredFormat) throws UnsupportedStorageException, DataStoreException {
        DataStoreFilter preferred = null;
        if (preferredFormat != null) {
            preferred = new DataStoreFilter(preferredFormat, true);
        }
        return DataStoreRegistry.INSTANCE.open(storage, Capability.WRITE, preferred);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<GridCoverage> readGridCoverage(Object storage, Envelope aoi) throws UnsupportedStorageException, DataStoreException {
        GridGeometry domain = aoi == null ? null : new GridGeometry(aoi);
        try (DataStore ds = DataStores.open(storage);){
            Optional<GridCoverage> optional;
            GridCoverageResource gc;
            if (ds instanceof GridCoverageResource) {
                gc = (GridCoverageResource)((Object)ds);
            } else if (ds instanceof Aggregate) {
                for (Resource resource : ((Aggregate)((Object)ds)).components()) {
                    if (!(resource instanceof GridCoverageResource)) continue;
                    gc = (GridCoverageResource)resource;
                    break;
                }
            } else {
                optional = Optional.empty();
                return optional;
            }
            optional = Optional.of(gc.read(domain, null));
            return optional;
        }
        catch (BackingStoreException e) {
            throw (DataStoreException)e.unwrapOrRethrow(DataStoreException.class);
        }
    }
}

