/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.impl;

import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.AbstractWriters;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.RepeatedWriteSchemas;

public class AnyRepeatedWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor, FieldSchema<T> anySchema) {
        return RepeatedWriteSchemas.create(protoField, propertyDescriptor, new AnyWriters<T>(protoField, anySchema));
    }

    private static class AnyWriters<T>
    extends AbstractWriters<T> {
        public AnyWriters(Field protoField, FieldSchema<T> anySchema) {
            super(protoField);
            this.arrayWriter = (output, array) -> {
                for (Object element : array) {
                    if (element != null) {
                        anySchema.writeTo(output, element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            };
            this.collectionWriter = (output, collection) -> {
                for (Object element : collection) {
                    if (element != null) {
                        anySchema.writeTo(output, element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            };
        }
    }
}

