/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.registry.cache;

import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.serviceregistry.ServiceRegistry;
import org.apache.servicecomb.serviceregistry.registry.cache.AggregateMicroserviceCache;
import org.apache.servicecomb.serviceregistry.registry.cache.MicroserviceCache;
import org.apache.servicecomb.serviceregistry.registry.cache.MicroserviceCacheKey;
import org.apache.servicecomb.serviceregistry.registry.cache.MicroserviceCacheRefreshedEvent;
import org.apache.servicecomb.serviceregistry.registry.cache.ServiceRegistryCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateServiceRegistryCache
implements ServiceRegistryCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregateServiceRegistryCache.class);
    Collection<ServiceRegistry> serviceRegistries;
    final Map<MicroserviceCacheKey, AggregateMicroserviceCache> microserviceCache = new ConcurrentHashMapEx();
    private Consumer<List<MicroserviceCache>> cacheRefreshedWatcher;

    public AggregateServiceRegistryCache(Collection<ServiceRegistry> serviceRegistries) {
        this.serviceRegistries = serviceRegistries;
    }

    @Override
    public MicroserviceCache findServiceCache(MicroserviceCacheKey microserviceCacheKey) {
        AggregateMicroserviceCache microserviceCache = this.microserviceCache.computeIfAbsent(microserviceCacheKey, key -> new AggregateMicroserviceCache((MicroserviceCacheKey)key, this.serviceRegistries));
        this.removeMicroserviceCacheIfNotExist(microserviceCache);
        return microserviceCache;
    }

    @Override
    public ServiceRegistryCache setCacheRefreshedWatcher(Consumer<List<MicroserviceCache>> cacheRefreshedWatcher) {
        this.cacheRefreshedWatcher = cacheRefreshedWatcher;
        return this;
    }

    @Subscribe
    public void onMicroserviceCacheRefreshed(MicroserviceCacheRefreshedEvent event) {
        List<MicroserviceCache> microserviceCaches = event.getMicroserviceCaches();
        if (null == microserviceCaches || microserviceCaches.isEmpty()) {
            return;
        }
        List<MicroserviceCache> refreshedAggregateMicroserviceCaches = microserviceCaches.stream().map(cache -> this.microserviceCache.get(cache.getKey())).filter(Objects::nonNull).peek(AggregateMicroserviceCache::refresh).peek(this::removeMicroserviceCacheIfNotExist).collect(Collectors.toList());
        LOGGER.info("[{}] caches get refreshed", (Object)refreshedAggregateMicroserviceCaches.size());
        refreshedAggregateMicroserviceCaches.forEach(cache -> LOGGER.info("[{}]: status={}, revisionId={}", new Object[]{cache.getKey(), cache.getStatus(), cache.getRevisionId()}));
        if (null != this.cacheRefreshedWatcher) {
            this.cacheRefreshedWatcher.accept(refreshedAggregateMicroserviceCaches);
        }
    }

    private void removeMicroserviceCacheIfNotExist(MicroserviceCache cache) {
        if (MicroserviceCache.MicroserviceCacheStatus.SERVICE_NOT_FOUND.equals((Object)cache.getStatus())) {
            this.microserviceCache.remove(cache.getKey());
            LOGGER.info("microserviceCache[{}] got removed", (Object)cache.getKey());
        }
    }

    @Override
    public Map<MicroserviceCacheKey, MicroserviceCache> getMicroserviceCaches() {
        return Collections.unmodifiableMap(this.microserviceCache);
    }
}

