/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.log.FileHandle;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogBuffer;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.stream.OutputWireRecord;
import com.sleepycat.je.rep.stream.VLSNReader;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class FeederReader
extends VLSNReader {
    private final VLSNIndex.ForwardVLSNScanner scanner;
    private boolean initDone = false;
    private long prevCacheHits = 0L;
    private final boolean bypassCache;

    public FeederReader(EnvironmentImpl envImpl, VLSNIndex vlsnIndex, long startLsn, int readBufferSize, NameIdPair nameIdPair) {
        this(envImpl, vlsnIndex, startLsn, readBufferSize, nameIdPair, false);
    }

    FeederReader(EnvironmentImpl envImpl, VLSNIndex vlsnIndex, long startLsn, int readBufferSize) {
        this(envImpl, vlsnIndex, startLsn, readBufferSize, new NameIdPair("test Node", 0), true);
    }

    private FeederReader(EnvironmentImpl envImpl, VLSNIndex vlsnIndex, long startLsn, int readBufferSize, NameIdPair nameIdPair, boolean bypassCache) {
        super(envImpl, vlsnIndex, true, startLsn, readBufferSize, nameIdPair, -1L);
        this.scanner = new VLSNIndex.ForwardVLSNScanner(vlsnIndex);
        this.bypassCache = bypassCache;
    }

    @Override
    protected FileReader.ReadWindow makeWindow(int readBufferSize) {
        return new SwitchWindow(readBufferSize, this.envImpl);
    }

    public void initScan(VLSN startVLSN) throws IOException {
        if (startVLSN.equals(VLSN.NULL_VLSN)) {
            throw EnvironmentFailureException.unexpectedState("startVLSN can't be null");
        }
        VLSNRange currentRange = this.vlsnIndex.getRange();
        VLSN startPoint = startVLSN;
        if (currentRange.getLast().compareTo(startVLSN) < 0) {
            startPoint = currentRange.getLast();
        }
        this.startLsn = this.scanner.getStartingLsn(startPoint);
        assert (this.startLsn != -1L);
        this.window.initAtFileStart(this.startLsn);
        this.nextEntryOffset = this.window.getEndOffset();
        this.currentVLSN = startVLSN;
        this.initDone = true;
    }

    public OutputWireRecord scanForwards(VLSN vlsn, int waitTime) throws InterruptedException {
        long repositionLsn;
        assert (this.initDone);
        LogItem logItem = null;
        try {
            logItem = this.vlsnIndex.waitForVLSN(vlsn, waitTime);
        }
        catch (VLSNIndex.WaitTimeOutException e) {
            return null;
        }
        this.currentVLSN = vlsn;
        if (logItem != null && !this.bypassCache) {
            assert (logItem.header.getVLSN().equals(vlsn));
            ++this.prevCacheHits;
            return new OutputWireRecord(this.envImpl, logItem);
        }
        if (this.prevCacheHits > 0L) {
            repositionLsn = this.scanner.getApproximateLsn(vlsn);
            if (DbLsn.compareTo(this.getLastLsn(), repositionLsn) >= 0) {
                repositionLsn = -1L;
            }
        } else {
            repositionLsn = this.scanner.getPreciseLsn(vlsn);
        }
        this.prevCacheHits = 0L;
        try {
            this.setPosition(repositionLsn);
        }
        catch (ChecksumException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM, "trying to reposition FeederReader to " + DbLsn.getNoFormatString(repositionLsn) + " prevWindow=" + this.window, e);
        }
        catch (FileNotFoundException e) {
            throw new LogFileNotFoundException(vlsn, "Trying to reposition FeederReader to " + DbLsn.getNoFormatString(repositionLsn) + " for vlsn:" + vlsn + " prevWindow=" + this.window, e);
        }
        if (this.readNextEntry()) {
            return this.currentFeedRecord;
        }
        throw EnvironmentFailureException.unexpectedState(this.envImpl, "VLSN=" + vlsn + " repositionLsn = " + DbLsn.getNoFormatString(repositionLsn) + this.window);
    }

    private void checkForPassingTarget(int compareResult) {
        if (compareResult > 0) {
            throw EnvironmentFailureException.unexpectedState("want to read " + this.currentVLSN + " but reader at " + this.currentEntryHeader.getVLSN());
        }
    }

    @Override
    protected boolean isTargetEntry() {
        ++this.nScanned;
        if (this.currentEntryHeader.isInvisible()) {
            return false;
        }
        if (this.entryIsReplicated()) {
            VLSN entryVLSN = this.currentEntryHeader.getVLSN();
            int compareResult = entryVLSN.compareTo(this.currentVLSN);
            this.checkForPassingTarget(compareResult);
            return compareResult == 0;
        }
        return false;
    }

    String dumpState() {
        return "prevCacheHits=" + this.prevCacheHits + " " + this.window;
    }

    public static class LogFileNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        final VLSN vlsn;

        LogFileNotFoundException(VLSN vlsn, String msg, IOException ioe) {
            super(msg, ioe);
            this.vlsn = vlsn;
        }
    }

    static class SwitchWindow
    extends FileReader.ReadWindow {
        private final LogManager logManager;

        SwitchWindow(int readBufferSize, EnvironmentImpl envImpl) {
            super(readBufferSize, envImpl);
            this.logManager = envImpl.getLogManager();
        }

        @Override
        public void slideAndFill(long windowFileNum, long windowStartOffset, long targetOffset, boolean forward) throws ChecksumException, FileNotFoundException, DatabaseException {
            if (!this.fillFromLogBuffer(windowFileNum, targetOffset)) {
                super.slideAndFill(windowFileNum, windowStartOffset, targetOffset, forward);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean fillFromLogBuffer(long windowFileNum, long targetOffset) throws DatabaseException {
            LogBuffer logBuffer = null;
            try {
                long fileLocation = DbLsn.makeLsn(windowFileNum, targetOffset);
                logBuffer = this.logManager.getReadBufferByLsn(fileLocation);
                if (logBuffer == null) {
                    boolean bl = false;
                    return bl;
                }
                ByteBuffer wholeContents = logBuffer.getDataBuffer().duplicate();
                if (wholeContents.position() != 0) {
                    wholeContents.flip();
                }
                long firstOffset = DbLsn.getFileOffset(logBuffer.getFirstLsn());
                wholeContents.position((int)(targetOffset - firstOffset));
                ByteBuffer startAtTarget = wholeContents.slice();
                byte[] data = startAtTarget.array();
                int availableContentLen = startAtTarget.limit();
                int copyLength = availableContentLen > this.readBuffer.capacity() ? this.readBuffer.capacity() : availableContentLen;
                this.readBuffer.clear();
                this.readBuffer.put(data, startAtTarget.arrayOffset(), copyLength);
                this.readBuffer.flip();
                this.setFileNum(windowFileNum, 14);
                this.startOffset = targetOffset;
                this.endOffset = this.startOffset + (long)this.readBuffer.limit();
                this.readBuffer.position(0);
                boolean bl = true;
                return bl;
            }
            finally {
                if (logBuffer != null) {
                    logBuffer.release();
                }
            }
        }

        @Override
        protected boolean fillNext(boolean singleFile, int bytesNeeded) throws ChecksumException, DatabaseException, FileReader.EOFException {
            assert (!singleFile);
            this.adjustReadBufferSize(bytesNeeded);
            if (this.fillFromLogBuffer(this.currentFileNum(), this.endOffset)) {
                return false;
            }
            FileHandle fileHandle = null;
            try {
                fileHandle = this.fileManager.getFileHandle(this.currentFileNum());
                this.startOffset = this.endOffset;
                if (this.fillFromFile(fileHandle, this.startOffset)) {
                    boolean bl = false;
                    return bl;
                }
                fileHandle.release();
                fileHandle = null;
                if (singleFile) {
                    throw new FileReader.EOFException();
                }
                Long nextFile = this.fileManager.getFollowingFileNum(this.currentFileNum(), true);
                if (nextFile == null) {
                    nextFile = this.currentFileNum() + 1L;
                }
                if (this.fillFromLogBuffer(nextFile, FileManager.firstLogEntryOffset())) {
                    boolean bl = true;
                    return bl;
                }
                fileHandle = this.fileManager.getFileHandle(nextFile);
                this.setFileNum(nextFile, fileHandle.getLogVersion());
                this.startOffset = 0L;
                boolean moreData = this.fillFromFile(fileHandle, 0L);
                assert (moreData) : "FeederReader should find more data in next file";
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw EnvironmentFailureException.unexpectedException("Problem in ReadWindow.fill, reading from  = " + this.currentFileNum(), (Exception)e);
            }
            finally {
                if (fileHandle != null) {
                    fileHandle.release();
                }
            }
        }
    }
}

