/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectType;
import org.apache.qpid.server.security.access.config.Rule;
import org.apache.qpid.server.security.access.config.RuleCollector;
import org.apache.qpid.server.security.access.config.RuleSet;
import org.apache.qpid.server.security.access.plugins.RuleOutcome;
import org.apache.qpid.server.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AclFileParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AclFileParser.class);
    public static final String DEFAULT_ALLOW = "defaultallow";
    public static final String DEFAULT_DEFER = "defaultdefer";
    public static final String DEFAULT_DENY = "defaultdeny";
    private static final Character COMMENT = Character.valueOf('#');
    private static final Character CONTINUATION = Character.valueOf('\\');
    public static final String ACL = "acl";
    private static final String CONFIG = "config";
    private static final String GROUP = "GROUP";
    static final String UNRECOGNISED_INITIAL_MSG = "Unrecognised initial token '%s' at line %d";
    static final String NOT_ENOUGH_TOKENS_MSG = "Not enough tokens at line %d";
    static final String NUMBER_NOT_ALLOWED_MSG = "Number not allowed before '%s' at line %d";
    static final String CANNOT_LOAD_MSG = "I/O Error while reading configuration";
    static final String PREMATURE_CONTINUATION_MSG = "Premature continuation character at line %d";
    static final String PARSE_TOKEN_FAILED_MSG = "Failed to parse token at line %d";
    static final String NOT_ENOUGH_ACL_MSG = "Not enough data for an acl at line %d";
    static final String NOT_ENOUGH_CONFIG_MSG = "Not enough data for config at line %d";
    static final String BAD_ACL_RULE_NUMBER_MSG = "Invalid rule number at line %d";
    static final String PROPERTY_KEY_ONLY_MSG = "Incomplete property (key only) at line %d";
    static final String PROPERTY_NO_EQUALS_MSG = "Incomplete property (no equals) at line %d";
    static final String PROPERTY_NO_VALUE_MSG = "Incomplete property (no value) at line %d";
    static final String GROUP_NOT_SUPPORTED = "GROUP keyword not supported at line %d. Groups should defined via a Group Provider, not in the ACL file.";
    static final String PROPERTY_NO_CLOSE_BRACKET_MSG = "Incomplete property (no close bracket) at line %d";
    private static final String INVALID_ENUM = "Not a valid %s: %s";
    private static final String INVALID_URL = "Cannot convert %s to a readable resource";
    private static final Map<String, RuleOutcome> PERMISSION_MAP;
    private static final Map<String, LegacyOperation> OPERATION_MAP;
    private static final Map<String, ObjectType> OBJECT_TYPE_MAP;
    private static final Pattern NUMBER;

    public static RuleSet parse(String name, EventLoggerProvider eventLogger) {
        return new AclFileParser().readAndParse(name, eventLogger);
    }

    public static RuleSet parse(Reader reader, EventLoggerProvider eventLogger) {
        return new AclFileParser().readAndParse(reader, eventLogger);
    }

    RuleSet readAndParse(String name, EventLoggerProvider eventLogger) {
        return this.readAndParse(this.getReaderFromURLString(name)).createRuleSet(eventLogger);
    }

    RuleSet readAndParse(Reader reader, EventLoggerProvider eventLogger) {
        return this.readAndParse(reader).createRuleSet(eventLogger);
    }

    RuleCollector readAndParse(Reader configReader) {
        RuleCollector ruleCollector = new RuleCollector();
        int line = 0;
        try (Reader fileReader = configReader;){
            int current;
            LOGGER.debug("About to load ACL file");
            StreamTokenizer tokenizer = new StreamTokenizer(new BufferedReader(fileReader));
            tokenizer.resetSyntax();
            tokenizer.commentChar(COMMENT.charValue());
            tokenizer.eolIsSignificant(true);
            tokenizer.ordinaryChar(61);
            tokenizer.ordinaryChar(CONTINUATION.charValue());
            tokenizer.quoteChar(34);
            tokenizer.quoteChar(39);
            tokenizer.whitespaceChars(0, 32);
            tokenizer.wordChars(97, 122);
            tokenizer.wordChars(65, 90);
            tokenizer.wordChars(48, 57);
            tokenizer.wordChars(95, 95);
            tokenizer.wordChars(45, 45);
            tokenizer.wordChars(46, 46);
            tokenizer.wordChars(42, 42);
            tokenizer.wordChars(64, 64);
            tokenizer.wordChars(58, 58);
            tokenizer.wordChars(43, 43);
            ArrayDeque<String> stack = new ArrayDeque<String>();
            do {
                current = tokenizer.nextToken();
                line = tokenizer.lineno() - 1;
                switch (current) {
                    case -1: 
                    case 10: {
                        this.processLine(ruleCollector, line, stack);
                        break;
                    }
                    case -2: {
                        this.addLast(stack, Integer.toString(Double.valueOf(tokenizer.nval).intValue()));
                        break;
                    }
                    case -3: {
                        this.addLast(stack, tokenizer.sval);
                        break;
                    }
                    default: {
                        this.parseToken(tokenizer, stack);
                    }
                }
            } while (current != -1);
        }
        catch (IllegalConfigurationException ice) {
            throw ice;
        }
        catch (IOException ioe) {
            throw new IllegalConfigurationException(CANNOT_LOAD_MSG, (Throwable)ioe);
        }
        catch (RuntimeException re) {
            throw new IllegalConfigurationException(String.format(PARSE_TOKEN_FAILED_MSG, line), (Throwable)re);
        }
        return ruleCollector;
    }

    private void processLine(RuleCollector ruleCollector, int line, Queue<String> stack) {
        if (stack.isEmpty()) {
            return;
        }
        String first = stack.poll();
        if (stack.isEmpty()) {
            throw new IllegalConfigurationException(String.format(NOT_ENOUGH_TOKENS_MSG, line));
        }
        Matcher matcher = NUMBER.matcher(first);
        if (matcher.matches()) {
            String type = stack.poll();
            if (ACL.equalsIgnoreCase(type)) {
                Integer number = this.validateNumber(Integer.valueOf(matcher.group()), ruleCollector, line);
                this.parseAcl(number, stack, ruleCollector, line);
                stack.clear();
                return;
            }
            throw new IllegalConfigurationException(String.format(NUMBER_NOT_ALLOWED_MSG, type, line));
        }
        if (ACL.equalsIgnoreCase(first)) {
            this.parseAcl(null, stack, ruleCollector, line);
        } else if (CONFIG.equalsIgnoreCase(first)) {
            AclFileParser.parseConfig(stack, ruleCollector, line);
        } else {
            if (GROUP.equalsIgnoreCase(first)) {
                throw new IllegalConfigurationException(String.format(GROUP_NOT_SUPPORTED, line));
            }
            throw new IllegalConfigurationException(String.format(UNRECOGNISED_INITIAL_MSG, first, line));
        }
        stack.clear();
    }

    private void parseToken(StreamTokenizer tokenizer, Queue<String> stack) throws IOException {
        if (tokenizer.ttype == CONTINUATION.charValue()) {
            if (tokenizer.nextToken() != 10) {
                throw new IllegalConfigurationException(String.format(PREMATURE_CONTINUATION_MSG, tokenizer.lineno()));
            }
        } else if (tokenizer.ttype == 39 || tokenizer.ttype == 34) {
            this.addLast(stack, tokenizer.sval);
        } else if (!Character.isWhitespace(tokenizer.ttype)) {
            this.addLast(stack, Character.toString((char)tokenizer.ttype));
        }
    }

    private void addLast(Queue<String> queue, String value) {
        if (value != null) {
            queue.add(value);
        }
    }

    private Integer validateNumber(Integer number, RuleCollector ruleCollector, int line) {
        if (!ruleCollector.isValidNumber(number)) {
            throw new IllegalConfigurationException(String.format(BAD_ACL_RULE_NUMBER_MSG, line));
        }
        return number;
    }

    private void parseAcl(Integer number, Queue<String> args, RuleCollector ruleCollector, int line) {
        if (args.size() < 3) {
            throw new IllegalConfigurationException(String.format(NOT_ENOUGH_ACL_MSG, line));
        }
        Rule.Builder builder = new Rule.Builder().withOutcome(this.parsePermission(args.poll(), line)).withIdentity(args.poll()).withOperation(this.parseOperation(args.poll(), line));
        if (!args.isEmpty()) {
            builder.withObject(this.parseObjectType(args.poll(), line));
            Iterator<String> tokenIterator = args.iterator();
            while (tokenIterator.hasNext()) {
                builder.withPredicate((String)tokenIterator.next(), AclFileParser.readValue(tokenIterator, line));
            }
        }
        ruleCollector.addRule(number, builder.build());
    }

    private static void parseConfig(Queue<String> args, RuleCollector ruleCollector, int line) {
        if (args.size() < 3) {
            throw new IllegalConfigurationException(String.format(NOT_ENOUGH_CONFIG_MSG, line));
        }
        Iterator<String> i = args.iterator();
        while (i.hasNext()) {
            String key = ((String)i.next()).toLowerCase(Locale.ENGLISH);
            Set<String> values = AclFileParser.readValue(i, line);
            Boolean value = Boolean.valueOf((String)CollectionUtils.getOnlyElement(values));
            if (!Boolean.TRUE.equals(value)) continue;
            switch (key) {
                case "defaultallow": {
                    ruleCollector.setDefaultResult(Result.ALLOWED);
                    break;
                }
                case "defaultdefer": {
                    ruleCollector.setDefaultResult(Result.DEFER);
                    break;
                }
                case "defaultdeny": {
                    ruleCollector.setDefaultResult(Result.DENIED);
                    break;
                }
            }
        }
    }

    private static Set<String> readValue(Iterator<String> tokenIterator, int line) {
        if (!tokenIterator.hasNext()) {
            throw new IllegalConfigurationException(String.format(PROPERTY_KEY_ONLY_MSG, line));
        }
        if (!"=".equals(tokenIterator.next())) {
            throw new IllegalConfigurationException(String.format(PROPERTY_NO_EQUALS_MSG, line));
        }
        if (!tokenIterator.hasNext()) {
            throw new IllegalConfigurationException(String.format(PROPERTY_NO_VALUE_MSG, line));
        }
        String value = tokenIterator.next();
        if ("[".equals(value)) {
            HashSet<String> values = new HashSet<String>();
            while (tokenIterator.hasNext()) {
                String next = tokenIterator.next();
                if (",".equals(next)) continue;
                if ("]".equals(next)) {
                    return values;
                }
                values.add(next);
            }
            throw new IllegalConfigurationException(String.format(PROPERTY_NO_CLOSE_BRACKET_MSG, line));
        }
        return Collections.singleton(value);
    }

    private RuleOutcome parsePermission(String text, int line) {
        return this.parseEnum(PERMISSION_MAP, text, line, "permission");
    }

    private LegacyOperation parseOperation(String text, int line) {
        return this.parseEnum(OPERATION_MAP, text, line, "operation");
    }

    private ObjectType parseObjectType(String text, int line) {
        return this.parseEnum(OBJECT_TYPE_MAP, text, line, "object type");
    }

    private <T extends Enum<T>> T parseEnum(Map<String, T> map, String text, int line, String typeDescription) {
        return (T)Optional.ofNullable((Enum)map.get(text.toUpperCase(Locale.ENGLISH))).orElseThrow(() -> new IllegalConfigurationException(String.format(PARSE_TOKEN_FAILED_MSG, line), (Throwable)new IllegalArgumentException(String.format(INVALID_ENUM, typeDescription, text))));
    }

    private Reader getReaderFromURLString(String urlString) {
        try {
            return new InputStreamReader(new URL(urlString).openStream(), StandardCharsets.UTF_8);
        }
        catch (MalformedURLException e) {
            return this.getReaderFromPath(urlString);
        }
        catch (IOException | RuntimeException e) {
            throw this.createReaderError(urlString, e);
        }
    }

    private Reader getReaderFromPath(String path) {
        try {
            Path file = Paths.get(path, new String[0]);
            return new InputStreamReader(file.toUri().toURL().openStream(), StandardCharsets.UTF_8);
        }
        catch (IOException | RuntimeException e) {
            throw this.createReaderError(path, e);
        }
    }

    private IllegalConfigurationException createReaderError(String urlString, Exception e) {
        return new IllegalConfigurationException(String.format(INVALID_URL, urlString), (Throwable)e);
    }

    static {
        NUMBER = Pattern.compile("\\s*(\\d+)\\s*");
        PERMISSION_MAP = new HashMap<String, RuleOutcome>();
        for (RuleOutcome value2 : RuleOutcome.values()) {
            PERMISSION_MAP.put(value2.name().toUpperCase(Locale.ENGLISH), value2);
            PERMISSION_MAP.put(value2.name().replace('_', '-').toUpperCase(Locale.ENGLISH), value2);
        }
        OPERATION_MAP = Arrays.stream(LegacyOperation.values()).collect(Collectors.toMap(value -> value.name().toUpperCase(Locale.ENGLISH), Function.identity()));
        OBJECT_TYPE_MAP = Arrays.stream(ObjectType.values()).collect(Collectors.toMap(value -> value.name().toUpperCase(Locale.ENGLISH), Function.identity()));
    }
}

