/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.nar;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.toolkit.client.ControllerClient;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;

public class DownloadNar
extends AbstractNiFiCommand<VoidResult> {
    public DownloadNar() {
        super("download-nar", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Downloads a NAR from the NAR Manager";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.NAR_ID.createOption());
        this.addOption(CommandOption.OUTPUT_DIR.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String narId = this.getRequiredArg(properties, CommandOption.NAR_ID);
        File outputDir = new File(this.getRequiredArg(properties, CommandOption.OUTPUT_DIR));
        ControllerClient controllerClient = client.getControllerClient();
        File narFile = controllerClient.downloadNar(narId, outputDir);
        if (this.isInteractive()) {
            this.println(narFile.getAbsolutePath());
        }
        return VoidResult.getInstance();
    }
}

