/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.time.DurationFormat;

public class FormatUtils {
    public static final String TIME_DURATION_REGEX = DurationFormat.TIME_DURATION_REGEX;
    public static final Pattern TIME_DURATION_PATTERN = DurationFormat.TIME_DURATION_PATTERN;

    public static String formatCount(long count) {
        return NumberFormat.getIntegerInstance().format(count);
    }

    public static String formatMinutesSeconds(long sourceDuration, TimeUnit sourceUnit) {
        long millis = TimeUnit.MILLISECONDS.convert(sourceDuration, sourceUnit);
        long millisInMinute = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES);
        int minutes = (int)(millis / millisInMinute);
        long secondsMillisLeft = millis - (long)minutes * millisInMinute;
        long millisInSecond = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS);
        int seconds = (int)(secondsMillisLeft / millisInSecond);
        long millisLeft = secondsMillisLeft - (long)seconds * millisInSecond;
        return FormatUtils.pad2Places(minutes) + ":" + FormatUtils.pad2Places(seconds) + "." + FormatUtils.pad3Places(millisLeft);
    }

    public static String formatHoursMinutesSeconds(long sourceDuration, TimeUnit sourceUnit) {
        long millis = TimeUnit.MILLISECONDS.convert(sourceDuration, sourceUnit);
        long millisInHour = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
        int hours = (int)(millis / millisInHour);
        long minutesSecondsMillisLeft = millis - (long)hours * millisInHour;
        return FormatUtils.pad2Places(hours) + ":" + FormatUtils.formatMinutesSeconds(minutesSecondsMillisLeft, TimeUnit.MILLISECONDS);
    }

    private static String pad2Places(long val) {
        return val < 10L ? "0" + val : String.valueOf(val);
    }

    private static String pad3Places(long val) {
        return val < 100L ? "0" + FormatUtils.pad2Places(val) : String.valueOf(val);
    }

    public static String formatDataSize(double dataSize) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(2);
        double dataSizeToFormat = DataUnit.B.toTB(dataSize);
        if (dataSizeToFormat > 1.0) {
            return format.format(dataSizeToFormat) + " TB";
        }
        dataSizeToFormat = DataUnit.B.toGB(dataSize);
        if (dataSizeToFormat > 1.0) {
            return format.format(dataSizeToFormat) + " GB";
        }
        dataSizeToFormat = DataUnit.B.toMB(dataSize);
        if (dataSizeToFormat > 1.0) {
            return format.format(dataSizeToFormat) + " MB";
        }
        dataSizeToFormat = DataUnit.B.toKB(dataSize);
        if (dataSizeToFormat > 1.0) {
            return format.format(dataSizeToFormat) + " KB";
        }
        return format.format(dataSize) + " bytes";
    }

    public static long getTimeDuration(String value, TimeUnit desiredUnit) {
        return DurationFormat.getTimeDuration((String)value, (TimeUnit)desiredUnit);
    }

    public static double getPreciseTimeDuration(String value, TimeUnit desiredUnit) {
        return DurationFormat.getPreciseTimeDuration((String)value, (TimeUnit)desiredUnit);
    }

    public static String formatUtilization(double utilization) {
        return utilization + "%";
    }

    public static DateTimeFormatter prepareLenientCaseInsensitiveDateTimeFormatter(String pattern) {
        return new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern(pattern).toFormatter(Locale.US);
    }

    public static String formatNanos(long nanos, boolean includeTotalNanos) {
        StringBuilder sb = new StringBuilder();
        long seconds = nanos >= 1000000000L ? nanos / 1000000000L : 0L;
        long millis = nanos >= 1000000L ? nanos / 1000000L : 0L;
        long nanosLeft = nanos % 1000000L;
        if (seconds > 0L) {
            sb.append(seconds).append(" seconds");
        }
        if (millis > 0L) {
            if (seconds > 0L) {
                sb.append(", ");
                millis -= seconds * 1000L;
            }
            sb.append(millis).append(" millis");
        }
        if (seconds > 0L || millis > 0L) {
            sb.append(", ");
        }
        sb.append(nanosLeft).append(" nanos");
        if (includeTotalNanos) {
            sb.append(" (").append(nanos).append(" nanos)");
        }
        return sb.toString();
    }

    public static Instant parseToInstant(DateTimeFormatter formatter, String text) {
        ZoneOffset zoneOffset;
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        TemporalAccessor parsed = formatter.parse(text);
        int year = 1970;
        if (parsed.isSupported(ChronoField.YEAR)) {
            year = parsed.get(ChronoField.YEAR);
        }
        int month = 1;
        if (parsed.isSupported(ChronoField.MONTH_OF_YEAR)) {
            month = parsed.get(ChronoField.MONTH_OF_YEAR);
        }
        int day = 1;
        if (parsed.isSupported(ChronoField.DAY_OF_MONTH)) {
            day = parsed.get(ChronoField.DAY_OF_MONTH);
        }
        int hour = 0;
        if (parsed.isSupported(ChronoField.HOUR_OF_DAY)) {
            hour = parsed.get(ChronoField.HOUR_OF_DAY);
        }
        int minute = 0;
        if (parsed.isSupported(ChronoField.MINUTE_OF_HOUR)) {
            minute = parsed.get(ChronoField.MINUTE_OF_HOUR);
        }
        int second = 0;
        if (parsed.isSupported(ChronoField.SECOND_OF_MINUTE)) {
            second = parsed.get(ChronoField.SECOND_OF_MINUTE);
        }
        int nano = 0;
        if (parsed.isSupported(ChronoField.MILLI_OF_SECOND)) {
            nano = parsed.get(ChronoField.NANO_OF_SECOND);
        }
        LocalDateTime localDateTime = LocalDateTime.of(year, month, day, hour, minute, second, nano);
        ZoneId zoneId = parsed.query(TemporalQueries.zoneId());
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        if (parsed.isSupported(ChronoField.OFFSET_SECONDS)) {
            int offsetSeconds = parsed.get(ChronoField.OFFSET_SECONDS);
            zoneOffset = ZoneOffset.ofTotalSeconds(offsetSeconds);
        } else {
            zoneOffset = zoneId.getRules().getOffset(localDateTime);
        }
        OffsetDateTime offsetDateTime = OffsetDateTime.of(localDateTime, zoneOffset);
        return offsetDateTime.toInstant();
    }
}

