/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.monitor;

import java.io.PrintWriter;
import java.security.AccessControlException;
import java.util.Locale;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.loader.InstanceGetter;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.impl.services.monitor.FileMonitor;

public class Monitor {
    public static final String SERVICE_TYPE_DIRECTORY = "serviceDirectory";
    public static final Object syncMe = new Object();
    public static final String NEW_INSTANCE_FROM_ID_TRACE_DEBUG_FLAG = null;
    public static final String DEBUG_TRUE = null;
    public static final String DEBUG_FALSE = null;
    private static ModuleFactory monitor;
    private static boolean active;

    public static void startMonitor(Properties properties, PrintWriter printWriter) {
        SecurityUtil.checkDerbyInternalsPrivilege();
        try {
            new FileMonitor(properties, printWriter);
        }
        catch (AccessControlException accessControlException) {
            Monitor.clearMonitor();
            throw accessControlException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setMonitor(ModuleFactory moduleFactory) {
        SecurityUtil.checkDerbyInternalsPrivilege();
        Object object = syncMe;
        synchronized (object) {
            if (active) {
                return false;
            }
            monitor = moduleFactory;
            active = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearMonitor() {
        SecurityUtil.checkDerbyInternalsPrivilege();
        Object object = syncMe;
        synchronized (object) {
            active = false;
        }
    }

    public static ModuleFactory getMonitor() {
        SecurityUtil.checkDerbyInternalsPrivilege();
        return monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleFactory getMonitorLite() {
        SecurityUtil.checkDerbyInternalsPrivilege();
        Object object = syncMe;
        synchronized (object) {
            if (active && monitor != null) {
                return monitor;
            }
        }
        return new FileMonitor();
    }

    public static HeaderPrintWriter getStream() {
        return monitor.getSystemStreams().stream();
    }

    public static String getServiceName(Object object) {
        SecurityUtil.checkDerbyInternalsPrivilege();
        return monitor.getServiceName(object);
    }

    public static Object startSystemModule(String string) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        Object object = monitor.startModule(false, null, string, null, null);
        return object;
    }

    public static Object findSystemModule(String string) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        Object object = Monitor.getMonitor().findModule(null, string, null);
        if (object == null) {
            throw Monitor.missingImplementation(string);
        }
        return object;
    }

    public static Object getSystemModule(String string) {
        SecurityUtil.checkDerbyInternalsPrivilege();
        ModuleFactory moduleFactory = Monitor.getMonitor();
        if (moduleFactory == null) {
            return null;
        }
        Object object = moduleFactory.findModule(null, string, null);
        return object;
    }

    public static Object bootServiceModule(boolean bl, Object object, String string, Properties properties) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        Object object2 = monitor.startModule(bl, object, string, null, properties);
        return object2;
    }

    public static Object bootServiceModule(boolean bl, Object object, String string, String string2, Properties properties) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        Object object2 = monitor.startModule(bl, object, string, string2, properties);
        return object2;
    }

    public static Object findServiceModule(Object object, String string) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        Object object2 = Monitor.getMonitor().findModule(object, string, null);
        if (object2 == null) {
            throw Monitor.missingImplementation(string);
        }
        return object2;
    }

    public static Object getServiceModule(Object object, String string) {
        SecurityUtil.checkDerbyInternalsPrivilege();
        Object object2 = Monitor.getMonitor().findModule(object, string, null);
        return object2;
    }

    public static Object findService(String string, String string2) {
        SecurityUtil.checkDerbyInternalsPrivilege();
        return monitor.findService(string, string2);
    }

    public static boolean startPersistentService(String string, Properties properties) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        return monitor.startPersistentService(string, properties);
    }

    public static Object startNonPersistentService(String string, String string2, Properties properties) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        return monitor.startNonPersistentService(string, string2, properties);
    }

    public static Object createPersistentService(String string, String string2, Properties properties) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        return monitor.createPersistentService(string, string2, properties);
    }

    public static void removePersistentService(String string) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        if (!string.startsWith("memory:")) {
            throw StandardException.newException("XBM0I.D", string);
        }
        monitor.removePersistentService(string);
    }

    public static InstanceGetter classFromIdentifier(int n) throws StandardException {
        return monitor.classFromIdentifier(n);
    }

    public static Object newInstanceFromIdentifier(int n) throws StandardException {
        return monitor.newInstanceFromIdentifier(n);
    }

    public static StandardException missingProductVersion(String string) {
        return StandardException.newException("XBM05.D", string);
    }

    public static StandardException missingImplementation(String string) {
        return StandardException.newException("XBM02.D", string);
    }

    public static StandardException exceptionStartingModule(Throwable throwable) {
        return StandardException.newException("XBM01.D", throwable, new Object[0]);
    }

    public static void logMessage(String string) {
        Monitor.getStream().println(string);
    }

    public static void logTextMessage(String string, Object ... objectArray) {
        Monitor.getStream().println(MessageService.getTextMessage(string, objectArray));
    }

    public static Locale getLocaleFromString(String string) throws StandardException {
        return monitor.getLocaleFromString(string);
    }

    public static boolean isFullUpgrade(Properties properties, String string) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        boolean bl = Boolean.valueOf(properties.getProperty("upgrade"));
        ProductVersionHolder productVersionHolder = Monitor.getMonitor().getEngineVersion();
        if ((productVersionHolder.isBeta() || productVersionHolder.isAlpha()) && !PropertyUtil.getSystemBoolean("derby.database.allowPreReleaseUpgrade")) {
            throw StandardException.newException("XCW00.D", string, productVersionHolder.getSimpleVersionString());
        }
        return bl;
    }

    public static boolean isDesiredType(Properties properties, int n) {
        int n2 = 2;
        if (properties != null) {
            n2 = Monitor.getEngineType(properties);
        }
        return (n2 & n) != 0;
    }

    public static boolean isDesiredType(int n, int n2) {
        return (n & n2) != 0;
    }

    public static int getEngineType(Properties properties) {
        if (properties != null) {
            String string = properties.getProperty("derby.engineType");
            int n = string == null ? 2 : Integer.parseInt(string.trim());
            return n;
        }
        return 2;
    }

    public static boolean isDesiredCreateType(Properties properties, int n) {
        boolean bl = Boolean.valueOf(properties.getProperty("create"));
        if (bl) {
            return (n & 2) != 0;
        }
        return Monitor.isDesiredType(properties, n);
    }

    public static void logThrowable(Throwable throwable) {
        throwable.printStackTrace(Monitor.getStream().getPrintWriter());
    }
}

