/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.binding;

import java.util.Iterator;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.Binding0;
import org.apache.jena.sparql.engine.binding.Binding1;
import org.apache.jena.sparql.engine.binding.Binding2;
import org.apache.jena.sparql.engine.binding.Binding3;
import org.apache.jena.sparql.engine.binding.Binding4;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingRoot;

public class BindingFactory {
    public static final Binding noParent = null;
    private static final Binding EMPTY = BindingFactory.binding();
    private static final boolean CHECK = true;

    public static final Binding empty() {
        return EMPTY;
    }

    public static BindingBuilder builder() {
        return Binding.builder();
    }

    public static BindingBuilder builder(Binding parent) {
        return Binding.builder(parent);
    }

    public static Binding binding() {
        return BindingFactory.binding(noParent);
    }

    public static Binding binding(Binding parent) {
        return new Binding0(parent);
    }

    public static Binding binding(Var var, Node node) {
        return BindingFactory.binding(noParent, var, node);
    }

    public static Binding binding(Var var1, Node node1, Var var2, Node node2) {
        return BindingFactory.binding(noParent, var1, node1, var2, node2);
    }

    public static Binding binding(Var var1, Node node1, Var var2, Node node2, Var var3, Node node3) {
        return BindingFactory.binding(noParent, var1, node1, var2, node2, var3, node3);
    }

    public static Binding binding(Var var1, Node node1, Var var2, Node node2, Var var3, Node node3, Var var4, Node node4) {
        return BindingFactory.binding(noParent, var1, node1, var2, node2, var3, node3, var4, node4);
    }

    public static Binding binding(Binding parent, Var var, Node node) {
        return new Binding1(parent, var, node);
    }

    public static Binding binding(Binding parent, Var var1, Node node1, Var var2, Node node2) {
        BindingFactory.allDifferent2(var1, var2);
        return new Binding2(parent, var1, node1, var2, node2);
    }

    public static Binding binding(Binding parent, Var var1, Node node1, Var var2, Node node2, Var var3, Node node3) {
        BindingFactory.allDifferent3(var1, var2, var3);
        return new Binding3(parent, var1, node1, var2, node2, var3, node3);
    }

    public static Binding binding(Binding parent, Var var1, Node node1, Var var2, Node node2, Var var3, Node node3, Var var4, Node node4) {
        BindingFactory.allDifferent4(var1, var2, var3, var4);
        return new Binding4(parent, var1, node1, var2, node2, var3, node3, var4, node4);
    }

    private static void different(Var var1, Var var2) {
        if (var1.equals(var2)) {
            throw new IllegalArgumentException("Duplicate variable: " + String.valueOf(var1));
        }
    }

    private static void allDifferent2(Var var1, Var var2) {
        BindingFactory.different(var1, var2);
    }

    private static void allDifferent3(Var var1, Var var2, Var var3) {
        BindingFactory.different(var1, var2);
        BindingFactory.different(var1, var3);
        BindingFactory.different(var2, var3);
    }

    private static void allDifferent4(Var var1, Var var2, Var var3, Var var4) {
        BindingFactory.different(var1, var2);
        BindingFactory.different(var1, var3);
        BindingFactory.different(var1, var4);
        BindingFactory.different(var2, var3);
        BindingFactory.different(var2, var4);
        BindingFactory.different(var3, var4);
    }

    public static Binding root() {
        return BindingRoot.create();
    }

    public static Binding copy(Binding b) {
        Iterator<Var> vIter = b.vars();
        BindingBuilder builder = new BindingBuilder();
        builder.addAll(b);
        return builder.build();
    }
}

