/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.assembler;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class StandardAnalyzerAssembler
extends AssemblerBase {
    @Override
    public Analyzer open(Assembler a, Resource root2, Mode mode) {
        if (root2.hasProperty(TextVocab.pStopWords)) {
            return this.analyzerWithStopWords(root2);
        }
        return new StandardAnalyzer();
    }

    private Analyzer analyzerWithStopWords(Resource root2) {
        RDFNode node = root2.getProperty(TextVocab.pStopWords).getObject();
        if (!node.isResource()) {
            throw new TextIndexException("text:stopWords property takes a list as a value : " + String.valueOf(node));
        }
        CharArraySet stopWords = this.toCharArraySet((Resource)node);
        return new StandardAnalyzer(stopWords);
    }

    private CharArraySet toCharArraySet(Resource list) {
        return new CharArraySet(this.toList(list), false);
    }

    private List<String> toList(Resource list) {
        ArrayList<String> result = new ArrayList<String>();
        Resource current = list;
        while (current != null && !current.equals(RDF.nil)) {
            Statement stmt = current.getProperty(RDF.first);
            if (stmt == null) {
                throw new TextIndexException("stop word list not well formed");
            }
            RDFNode node = stmt.getObject();
            if (!node.isLiteral()) {
                throw new TextIndexException("stop word is not a literal : " + String.valueOf(node));
            }
            result.add(((Literal)node).getLexicalForm());
            stmt = current.getProperty(RDF.rest);
            if (stmt == null) {
                throw new TextIndexException("stop word list not terminated by rdf:nil");
            }
            node = stmt.getObject();
            if (!node.isResource()) {
                throw new TextIndexException("stop word list node is not a resource : " + String.valueOf(node));
            }
            current = (Resource)node;
        }
        return result;
    }
}

