/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.serialization;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

final class GraphMap {
    private final Map<String, Map<String, Map<String, JsonValue>>> index = new LinkedHashMap<String, Map<String, Map<String, JsonValue>>>();
    private final Map<String, Map<String, List<Reference>>> usages;

    public GraphMap() {
        this.index.put("@default", new LinkedHashMap());
        this.usages = new LinkedHashMap<String, Map<String, List<Reference>>>();
    }

    public boolean contains(String graphName, String subject) {
        return this.index.containsKey(graphName) && this.index.get(graphName).containsKey(subject);
    }

    public void set(String graphName, String subject, String property, JsonValue value) {
        this.index.computeIfAbsent(graphName, e2 -> new LinkedHashMap()).computeIfAbsent(subject, e2 -> new LinkedHashMap()).put(property, value);
    }

    public Optional<Map<String, JsonValue>> get(String graphName, String subject) {
        Map<String, Map<String, JsonValue>> graphMap = this.index.get(graphName);
        if (graphMap == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(graphMap.get(subject));
    }

    public Optional<JsonValue> get(String graphName, String subject, String property) {
        Map<String, Map<String, JsonValue>> graphMap = this.index.get(graphName);
        if (graphMap == null) {
            return Optional.empty();
        }
        Map<String, JsonValue> subjectMap = graphMap.get(subject);
        if (subjectMap == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(subjectMap.get(property));
    }

    public Set<String> keys(String graphName) {
        return this.index.get(graphName).keySet();
    }

    public boolean contains(String graphName) {
        return this.index.containsKey(graphName);
    }

    public Set<String> keys() {
        return this.index.keySet();
    }

    public List<Reference> getUsages(String graphName, String subject) {
        return this.usages.containsKey(graphName) && this.usages.get(graphName).containsKey(subject) ? this.usages.get(graphName).get(subject) : Collections.emptyList();
    }

    public void addUsage(String graphName, String subject, Reference reference) {
        this.usages.computeIfAbsent(graphName, e2 -> new LinkedHashMap()).computeIfAbsent(subject, e2 -> new ArrayList()).add(reference);
    }

    public void remove(String graphName, String subject) {
        this.index.get(graphName).remove(subject);
    }

    public void clear() {
        this.index.clear();
        this.index.put("@default", new LinkedHashMap());
        this.usages.clear();
    }

    static class Reference {
        String graphName;
        String subject;
        String property;
        JsonObject value;

        Reference() {
        }
    }
}

