/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import org.apache.jena.query.QueryException;

public class QueryParseException
extends QueryException {
    private int line;
    private int column;

    public QueryParseException(int line, int column) {
        this(null, null, line, column);
    }

    public QueryParseException(Throwable cause, int line, int column) {
        this(null, cause, line, column);
    }

    public QueryParseException(String msg, int line, int column) {
        this(msg, null, line, column);
    }

    public QueryParseException(String msg, Throwable cause, int line, int column) {
        super(msg, cause);
        this.set(line, column);
    }

    private void set(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public static String formatMessage(String msg, int line, int column) {
        if (line == -1 || column == -1) {
            return msg;
        }
        return String.format("[line: %d, col: %d] " + msg, line, column);
    }
}

