/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.List;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.NamespaceRequest;
import org.apache.james.imap.message.response.NamespaceResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.NamespaceSupplier;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import reactor.core.publisher.Mono;

public class NamespaceProcessor
extends AbstractMailboxProcessor<NamespaceRequest>
implements CapabilityImplementingProcessor {
    private static final List<Capability> CAPS = ImmutableList.of((Object)ImapConstants.SUPPORTS_NAMESPACES);
    private final NamespaceSupplier namespaceSupplier;

    @Inject
    public NamespaceProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory, NamespaceSupplier namespaceSupplier) {
        super(NamespaceRequest.class, mailboxManager, factory, metricFactory);
        this.namespaceSupplier = namespaceSupplier;
    }

    @Override
    protected Mono<Void> processRequestReactive(NamespaceRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxSession mailboxSession = session.getMailboxSession();
        NamespaceResponse response = new NamespaceResponse(this.namespaceSupplier.personalNamespaces(mailboxSession), this.namespaceSupplier.otherUsersNamespaces(mailboxSession), this.namespaceSupplier.sharedNamespaces(mailboxSession));
        responder.respond(response);
        return this.unsolicitedResponses(session, responder, false).then(Mono.fromRunnable(() -> this.okComplete(request, responder)));
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }

    @Override
    protected MDCBuilder mdc(NamespaceRequest request) {
        return MDCBuilder.create().addToContext("action", "NAMESPACE");
    }
}

