/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityKeyMapper;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignmentCache;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheInternal;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public class GridCacheAffinityManager
extends GridCacheManagerAdapter {
    private static final AffinityTopologyVersion LOC_CACHE_TOP_VER = new AffinityTopologyVersion(1L);
    private static final String FAILED_TO_FIND_CACHE_ERR_MSG = "Failed to find cache (cache was not started yet or cache was already stopped): ";
    private GridAffinityAssignmentCache aff;
    private AffinityFunction affFunction;
    private AffinityKeyMapper affMapper;

    @Override
    public void start0() throws IgniteCheckedException {
        this.affFunction = this.cctx.config().getAffinity();
        this.affMapper = this.cctx.config().getAffinityMapper();
        this.aff = this.cctx.group().affinity();
    }

    @Override
    protected void stop0(boolean cancel, boolean destroy) {
        this.aff = null;
    }

    public IgniteInternalFuture<AffinityTopologyVersion> affinityReadyFuture(long topVer) {
        return this.affinityReadyFuture(new AffinityTopologyVersion(topVer));
    }

    public IgniteInternalFuture<AffinityTopologyVersion> affinityReadyFuture(AffinityTopologyVersion topVer) {
        GridFinishedFuture<AffinityTopologyVersion> fut = this.aff.readyFuture(topVer);
        return fut != null ? fut : new GridFinishedFuture<AffinityTopologyVersion>(this.aff.lastVersion());
    }

    @Nullable
    public IgniteInternalFuture<AffinityTopologyVersion> affinityReadyFuturex(AffinityTopologyVersion topVer) {
        return this.aff.readyFuture(topVer);
    }

    public List<List<ClusterNode>> assignments(AffinityTopologyVersion topVer) {
        GridAffinityAssignmentCache aff0 = this.aff;
        if (aff0 == null) {
            throw new IgniteException(FAILED_TO_FIND_CACHE_ERR_MSG + this.cctx.name());
        }
        return aff0.assignments(topVer);
    }

    public List<List<ClusterNode>> idealAssignment() {
        return this.aff.idealAssignmentRaw();
    }

    public int partitions() {
        GridAffinityAssignmentCache aff0 = this.aff;
        if (aff0 == null) {
            throw new IgniteException(FAILED_TO_FIND_CACHE_ERR_MSG + this.cctx.name());
        }
        return aff0.partitions();
    }

    public int partition(Object key) {
        return this.partition(key, true);
    }

    public int partition(Object key, boolean useKeyPart) {
        int part;
        GridAffinityAssignmentCache aff0 = this.aff;
        if (aff0 == null) {
            throw new IgniteException(FAILED_TO_FIND_CACHE_ERR_MSG + this.cctx.name());
        }
        if (useKeyPart && key instanceof KeyCacheObject && (part = ((KeyCacheObject)key).partition()) != -1) {
            return part;
        }
        return this.affFunction.partition(this.affinityKey(key));
    }

    public Object affinityKey(Object key) {
        CacheObjectContext coCtx = this.cctx.cacheObjectContext();
        if (key instanceof CacheObject && !(key instanceof BinaryObject)) {
            key = ((CacheObject)key).value(coCtx, false);
        }
        return (key instanceof GridCacheInternal ? coCtx.defaultAffMapper() : this.affMapper).affinityKey(key);
    }

    public List<ClusterNode> nodesByKey(Object key, AffinityTopologyVersion topVer) {
        return this.nodesByPartition(this.partition(key), topVer);
    }

    public List<ClusterNode> nodesByPartition(int part, AffinityTopologyVersion topVer) {
        GridAffinityAssignmentCache aff0 = this.aff;
        if (aff0 == null) {
            throw new IgniteException(FAILED_TO_FIND_CACHE_ERR_MSG + this.cctx.name());
        }
        return aff0.nodes(part, topVer);
    }

    public AffinityAssignment assignment(AffinityTopologyVersion topVer) {
        return this.assignment(topVer, this.cctx.shared().exchange().lastAffinityChangedTopologyVersion(topVer));
    }

    public AffinityAssignment assignment(AffinityTopologyVersion topVer, AffinityTopologyVersion lastAffChangedTopVer) {
        GridAffinityAssignmentCache aff0 = this.aff;
        if (aff0 == null) {
            throw new IgniteException(FAILED_TO_FIND_CACHE_ERR_MSG + this.cctx.name());
        }
        return aff0.cachedAffinity(topVer, lastAffChangedTopVer);
    }

    @Nullable
    public ClusterNode primaryByKey(Object key, AffinityTopologyVersion topVer) {
        return this.primaryByPartition(this.partition(key), topVer);
    }

    @Nullable
    public ClusterNode primaryByPartition(int part, AffinityTopologyVersion topVer) {
        List<ClusterNode> nodes = this.nodesByPartition(part, topVer);
        if (nodes.isEmpty()) {
            return null;
        }
        return nodes.get(0);
    }

    public boolean primaryByKey(ClusterNode n, Object key, AffinityTopologyVersion topVer) {
        return F.eq(this.primaryByKey(key, topVer), n);
    }

    public boolean primaryByPartition(ClusterNode n, int part, AffinityTopologyVersion topVer) {
        return F.eq(this.primaryByPartition(part, topVer), n);
    }

    public Collection<ClusterNode> backupsByKey(Object key, AffinityTopologyVersion topVer) {
        return this.backupsByPartition(this.partition(key), topVer);
    }

    private Collection<ClusterNode> backupsByPartition(int part, AffinityTopologyVersion topVer) {
        List<ClusterNode> nodes = this.nodesByPartition(part, topVer);
        assert (!F.isEmpty(nodes));
        if (nodes.size() == 1) {
            return Collections.emptyList();
        }
        return F.view(nodes, F.notEqualTo(nodes.get(0)));
    }

    public boolean backupByPartition(ClusterNode n, int part, AffinityTopologyVersion topVer) {
        List<ClusterNode> nodes = this.nodesByPartition(part, topVer);
        assert (!F.isEmpty(nodes));
        return nodes.indexOf(n) > 0;
    }

    public boolean keyLocalNode(Object key, AffinityTopologyVersion topVer) {
        return this.partitionLocalNode(this.partition(key), topVer);
    }

    public boolean partitionLocalNode(int part, AffinityTopologyVersion topVer) {
        assert (part >= 0) : "Invalid partition: " + part;
        return this.nodesByPartition(part, topVer).contains(this.cctx.localNode());
    }

    public boolean partitionBelongs(ClusterNode node, int part, AffinityTopologyVersion topVer) {
        assert (node != null);
        assert (part >= 0) : "Invalid partition: " + part;
        return this.nodesByPartition(part, topVer).contains(node);
    }

    public Set<Integer> primaryPartitions(UUID nodeId, AffinityTopologyVersion topVer) {
        GridAffinityAssignmentCache aff0 = this.aff;
        if (aff0 == null) {
            throw new IgniteException(FAILED_TO_FIND_CACHE_ERR_MSG + this.cctx.name());
        }
        return aff0.primaryPartitions(nodeId, topVer);
    }

    public Set<Integer> backupPartitions(UUID nodeId, AffinityTopologyVersion topVer) {
        GridAffinityAssignmentCache aff0 = this.aff;
        if (aff0 == null) {
            throw new IgniteException(FAILED_TO_FIND_CACHE_ERR_MSG + this.cctx.name());
        }
        return aff0.backupPartitions(nodeId, topVer);
    }

    public AffinityTopologyVersion affinityTopologyVersion() {
        GridAffinityAssignmentCache aff0 = this.aff;
        if (aff0 == null) {
            throw new IgniteException(FAILED_TO_FIND_CACHE_ERR_MSG + this.cctx.name());
        }
        return aff0.lastVersion();
    }

    public boolean primaryChanged(int part, AffinityTopologyVersion startVer, AffinityTopologyVersion endVer) {
        GridAffinityAssignmentCache aff0 = this.aff;
        if (aff0 == null) {
            throw new IgniteException(FAILED_TO_FIND_CACHE_ERR_MSG + this.cctx.name());
        }
        return aff0.primaryChanged(part, startVer, endVer);
    }

    public boolean isCompatibleWithCurrentTopologyVersion(AffinityTopologyVersion rmtVer) {
        Collection<ClusterNode> cacheNodes1;
        AffinityTopologyVersion curVer = this.cctx.topology().readyTopologyVersion();
        if (curVer.equals(rmtVer)) {
            return true;
        }
        AffinityTopologyVersion lastAffChangedTopVer = this.cctx.shared().exchange().lastAffinityChangedTopologyVersion(rmtVer);
        if (curVer.isBetween(lastAffChangedTopVer, rmtVer)) {
            return true;
        }
        if (this.cctx.shared().exchange().lastFinishedFuture().context().remapStaleCacheRequests()) {
            return false;
        }
        Collection<ClusterNode> cacheNodes0 = this.cctx.discovery().cacheGroupAffinityNodes(this.cctx.groupId(), rmtVer);
        if (!cacheNodes0.equals(cacheNodes1 = this.cctx.discovery().cacheGroupAffinityNodes(this.cctx.groupId(), curVer)) || this.affinityTopologyVersion().before(curVer)) {
            return false;
        }
        try {
            List<List<ClusterNode>> aff1 = this.assignments(rmtVer);
            List<List<ClusterNode>> aff2 = this.assignments(curVer);
            return aff1.equals(aff2);
        }
        catch (IllegalStateException ignored) {
            return false;
        }
    }
}

