/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.policy.Policy;
import org.apache.gravitino.policy.PolicyContent;
import org.apache.gravitino.policy.PolicyContents;

public class PolicyEntity
implements Entity,
Auditable,
HasIdentifier {
    public static final Field ID = Field.required("id", Long.class, "The unique id of the policy entity.");
    public static final Field NAME = Field.required("name", String.class, "The name of the policy entity.");
    public static final Field POLICY_TYPE = Field.required("policyType", Policy.BuiltInType.class, "The type of the policy entity.");
    public static final Field COMMENT = Field.optional("comment", String.class, "The comment of the policy entity.");
    public static final Field ENABLED = Field.required("enabled", Boolean.class, "The policy entity is enabled.");
    public static final Field CONTENT = Field.required("content", PolicyContent.class, "The content of the policy entity.");
    public static final Field AUDIT_INFO = Field.required("audit_info", AuditInfo.class, "The audit details of the policy entity.");
    private Long id;
    private String name;
    private Namespace namespace;
    private Policy.BuiltInType policyType;
    private String comment;
    private boolean enabled;
    private PolicyContent content;
    private AuditInfo auditInfo;

    public static Builder builder() {
        return new Builder();
    }

    private PolicyEntity() {
    }

    @Override
    public Map<Field, Object> fields() {
        HashMap fields = Maps.newHashMap();
        fields.put(ID, this.id);
        fields.put(NAME, this.name);
        fields.put(POLICY_TYPE, this.policyType);
        fields.put(COMMENT, this.comment);
        fields.put(ENABLED, this.enabled);
        fields.put(CONTENT, this.content);
        fields.put(AUDIT_INFO, this.auditInfo);
        return Collections.unmodifiableMap(fields);
    }

    @Override
    public Long id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Namespace namespace() {
        return this.namespace;
    }

    @Override
    public Entity.EntityType type() {
        return Entity.EntityType.POLICY;
    }

    public Audit auditInfo() {
        return this.auditInfo;
    }

    public Policy.BuiltInType policyType() {
        return this.policyType;
    }

    public String comment() {
        return this.comment;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public PolicyContent content() {
        return this.content;
    }

    public Optional<Boolean> inherited() {
        return Optional.empty();
    }

    @Override
    public void validate() throws IllegalArgumentException {
        Entity.super.validate();
        this.validatePolicy();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PolicyEntity)) {
            return false;
        }
        PolicyEntity that = (PolicyEntity)o;
        return this.enabled == that.enabled && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.policyType, that.policyType) && Objects.equals(this.comment, that.comment) && Objects.equals(this.content, that.content) && Objects.equals(this.auditInfo, that.auditInfo);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.namespace, this.policyType, this.comment, this.enabled, this.content, this.auditInfo);
    }

    private void validatePolicy() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name()), (Object)"Policy name cannot be blank");
        Preconditions.checkArgument((this.content() != null ? 1 : 0) != 0, (Object)"Policy content cannot be null");
        Preconditions.checkArgument((this.policyType != Policy.BuiltInType.CUSTOM || this.content() instanceof PolicyContents.CustomContent ? 1 : 0) != 0, (String)"Expected CustomContent for custom policy type, but got %s", (Object)this.content().getClass().getName());
        this.content().validate();
    }

    public String toString() {
        return "PolicyEntity(id=" + this.id + ", name=" + this.name + ", namespace=" + String.valueOf(this.namespace) + ", policyType=" + String.valueOf(this.policyType) + ", comment=" + this.comment + ", enabled=" + this.enabled + ", content=" + String.valueOf(this.content) + ", auditInfo=" + String.valueOf(this.auditInfo) + ")";
    }

    public static class Builder {
        private Long id;
        private String name;
        private Namespace namespace;
        private Policy.BuiltInType policyType;
        private String comment;
        private boolean enabled = true;
        private PolicyContent content;
        private AuditInfo auditInfo;

        public Builder withId(Long id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withNamespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder withPolicyType(Policy.BuiltInType policyType) {
            this.policyType = policyType;
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder withEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder withContent(PolicyContent content) {
            this.content = content;
            return this;
        }

        public Builder withAuditInfo(AuditInfo auditInfo) {
            this.auditInfo = auditInfo;
            return this;
        }

        public PolicyEntity build() {
            PolicyEntity policyEntity = new PolicyEntity();
            policyEntity.id = this.id;
            policyEntity.name = this.name;
            policyEntity.namespace = this.namespace;
            policyEntity.policyType = this.policyType;
            policyEntity.comment = this.comment;
            policyEntity.enabled = this.enabled;
            policyEntity.content = this.content;
            policyEntity.auditInfo = this.auditInfo;
            policyEntity.validate();
            return policyEntity;
        }
    }
}

