/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.meta.GenericEntity;
import org.apache.gravitino.metrics.MethodMonitorAspect;
import org.apache.gravitino.metrics.Monitored;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.storage.relational.mapper.CatalogMetaMapper;
import org.apache.gravitino.storage.relational.mapper.FilesetMetaMapper;
import org.apache.gravitino.storage.relational.mapper.JobTemplateMetaMapper;
import org.apache.gravitino.storage.relational.mapper.MetalakeMetaMapper;
import org.apache.gravitino.storage.relational.mapper.ModelMetaMapper;
import org.apache.gravitino.storage.relational.mapper.PolicyMetaMapper;
import org.apache.gravitino.storage.relational.mapper.SchemaMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TableColumnMapper;
import org.apache.gravitino.storage.relational.mapper.TableMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TagMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TopicMetaMapper;
import org.apache.gravitino.storage.relational.po.ColumnPO;
import org.apache.gravitino.storage.relational.po.FilesetPO;
import org.apache.gravitino.storage.relational.po.ModelPO;
import org.apache.gravitino.storage.relational.po.SchemaPO;
import org.apache.gravitino.storage.relational.po.TablePO;
import org.apache.gravitino.storage.relational.po.TopicPO;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataObjectService {
    private static final String DOT = ".";
    private static final Joiner DOT_JOINER;
    private static final Logger LOG;
    static final Map<MetadataObject.Type, Function<List<Long>, Map<Long, String>>> TYPE_TO_FULLNAME_FUNCTION_MAP;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ Annotation ajc$anno$8;

    private static Map<Long, String> getPolicyObjectsFullName(List<Long> policyIds) {
        if (policyIds == null || policyIds.isEmpty()) {
            return Map.of();
        }
        return policyIds.stream().collect(Collectors.toMap(policyId -> policyId, policyId -> SessionUtils.getWithoutCommit(PolicyMetaMapper.class, policyMetaMapper -> policyMetaMapper.selectPolicyByPolicyId((Long)policyId).getPolicyName())));
    }

    private static Map<Long, String> getJobObjectsFullName(List<Long> jobIds) {
        if (jobIds == null || jobIds.isEmpty()) {
            return Maps.newHashMap();
        }
        return jobIds.stream().collect(Collectors.toMap(jobId -> jobId, jobId -> "job-" + jobId));
    }

    private static Map<Long, String> getJobTemplateObjectsFullName(List<Long> jobTemplateIds) {
        if (jobTemplateIds == null || jobTemplateIds.isEmpty()) {
            return Maps.newHashMap();
        }
        return jobTemplateIds.stream().collect(Collectors.toMap(jobTemplateId -> jobTemplateId, jobTemplateId -> SessionUtils.getWithoutCommit(JobTemplateMetaMapper.class, jobTemplateMetaMapper -> jobTemplateMetaMapper.selectJobTemplateById((Long)jobTemplateId).jobTemplateName())));
    }

    private static Map<Long, String> getTagObjectsFullName(List<Long> tagIds) {
        if (tagIds == null || tagIds.isEmpty()) {
            return Map.of();
        }
        return tagIds.stream().collect(Collectors.toMap(tagId -> tagId, tagId -> SessionUtils.getWithoutCommit(TagMetaMapper.class, tagMetaMapper -> tagMetaMapper.selectTagByTagId((Long)tagId).getTagName())));
    }

    private MetadataObjectService() {
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="fromGenericEntities")
    public static List<MetadataObject> fromGenericEntities(List<GenericEntity> entities) {
        List<GenericEntity> list = entities;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, list);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = MetadataObjectService.class.getDeclaredMethod("fromGenericEntities", List.class).getAnnotation(Monitored.class);
        }
        return (List)MetadataObjectService.fromGenericEntities_aroundBody1$advice(list, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getMetalakeObjectsFullName")
    public static Map<Long, String> getMetalakeObjectsFullName(List<Long> metalakeIds) {
        List<Long> list = metalakeIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, list);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = MetadataObjectService.class.getDeclaredMethod("getMetalakeObjectsFullName", List.class).getAnnotation(Monitored.class);
        }
        return (Map)MetadataObjectService.getMetalakeObjectsFullName_aroundBody3$advice(list, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getFilesetObjectsFullName")
    public static Map<Long, String> getFilesetObjectsFullName(List<Long> filesetIds) {
        List<Long> list = filesetIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, list);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = MetadataObjectService.class.getDeclaredMethod("getFilesetObjectsFullName", List.class).getAnnotation(Monitored.class);
        }
        return (Map)MetadataObjectService.getFilesetObjectsFullName_aroundBody5$advice(list, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getModelObjectsFullName")
    public static Map<Long, String> getModelObjectsFullName(List<Long> modelIds) {
        List<Long> list = modelIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, list);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = MetadataObjectService.class.getDeclaredMethod("getModelObjectsFullName", List.class).getAnnotation(Monitored.class);
        }
        return (Map)MetadataObjectService.getModelObjectsFullName_aroundBody7$advice(list, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getTableObjectsFullName")
    public static Map<Long, String> getTableObjectsFullName(List<Long> tableIds) {
        List<Long> list = tableIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, list);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = MetadataObjectService.class.getDeclaredMethod("getTableObjectsFullName", List.class).getAnnotation(Monitored.class);
        }
        return (Map)MetadataObjectService.getTableObjectsFullName_aroundBody9$advice(list, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getColumnObjectsFullName")
    public static Map<Long, String> getColumnObjectsFullName(List<Long> columnsIds) {
        List<Long> list = columnsIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, list);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = MetadataObjectService.class.getDeclaredMethod("getColumnObjectsFullName", List.class).getAnnotation(Monitored.class);
        }
        return (Map)MetadataObjectService.getColumnObjectsFullName_aroundBody11$advice(list, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getTopicObjectsFullName")
    public static Map<Long, String> getTopicObjectsFullName(List<Long> topicIds) {
        List<Long> list = topicIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, list);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = MetadataObjectService.class.getDeclaredMethod("getTopicObjectsFullName", List.class).getAnnotation(Monitored.class);
        }
        return (Map)MetadataObjectService.getTopicObjectsFullName_aroundBody13$advice(list, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getCatalogObjectsFullName")
    public static Map<Long, String> getCatalogObjectsFullName(List<Long> catalogIds) {
        List<Long> list = catalogIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, list);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = MetadataObjectService.class.getDeclaredMethod("getCatalogObjectsFullName", List.class).getAnnotation(Monitored.class);
        }
        return (Map)MetadataObjectService.getCatalogObjectsFullName_aroundBody15$advice(list, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getSchemaObjectsFullName")
    public static Map<Long, String> getSchemaObjectsFullName(List<Long> schemaIds) {
        List<Long> list = schemaIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, list);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = MetadataObjectService.class.getDeclaredMethod("getSchemaObjectsFullName", List.class).getAnnotation(Monitored.class);
        }
        return (Map)MetadataObjectService.getSchemaObjectsFullName_aroundBody17$advice(list, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    static {
        MetadataObjectService.ajc$preClinit();
        DOT_JOINER = Joiner.on((String)DOT);
        LOG = LoggerFactory.getLogger(MetadataObjectService.class);
        TYPE_TO_FULLNAME_FUNCTION_MAP = ImmutableMap.builder().put((Object)MetadataObject.Type.METALAKE, MetadataObjectService::getMetalakeObjectsFullName).put((Object)MetadataObject.Type.CATALOG, MetadataObjectService::getCatalogObjectsFullName).put((Object)MetadataObject.Type.SCHEMA, MetadataObjectService::getSchemaObjectsFullName).put((Object)MetadataObject.Type.TABLE, MetadataObjectService::getTableObjectsFullName).put((Object)MetadataObject.Type.FILESET, MetadataObjectService::getFilesetObjectsFullName).put((Object)MetadataObject.Type.MODEL, MetadataObjectService::getModelObjectsFullName).put((Object)MetadataObject.Type.TOPIC, MetadataObjectService::getTopicObjectsFullName).put((Object)MetadataObject.Type.COLUMN, MetadataObjectService::getColumnObjectsFullName).put((Object)MetadataObject.Type.TAG, MetadataObjectService::getTagObjectsFullName).put((Object)MetadataObject.Type.POLICY, MetadataObjectService::getPolicyObjectsFullName).put((Object)MetadataObject.Type.JOB, MetadataObjectService::getJobObjectsFullName).put((Object)MetadataObject.Type.JOB_TEMPLATE, MetadataObjectService::getJobTemplateObjectsFullName).build();
    }

    private static final /* synthetic */ List fromGenericEntities_aroundBody0(List entities, JoinPoint joinPoint) {
        if (entities == null || entities.isEmpty()) {
            return Lists.newArrayList();
        }
        Map groupIdsByType = entities.stream().collect(Collectors.groupingBy(GenericEntity::type, Collectors.mapping(GenericEntity::id, Collectors.toList())));
        ArrayList metadataObjects = Lists.newArrayList();
        for (Map.Entry entry : groupIdsByType.entrySet()) {
            MetadataObject.Type objectType = MetadataObject.Type.valueOf((String)entry.getKey().name());
            Map<Long, String> metadataObjectNames = TYPE_TO_FULLNAME_FUNCTION_MAP.get(objectType).apply(entry.getValue());
            for (Map.Entry<Long, String> metadataObjectName : metadataObjectNames.entrySet()) {
                String fullName = metadataObjectName.getValue();
                if (fullName == null) continue;
                metadataObjects.add(MetadataObjects.parse((String)fullName, (MetadataObject.Type)objectType));
            }
        }
        return metadataObjects;
    }

    private static final /* synthetic */ Object fromGenericEntities_aroundBody1$advice(List entities, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetadataObjectService.fromGenericEntities_aroundBody0(entities, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetadataObjectService.fromGenericEntities_aroundBody0(entities, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = MetadataObjectService.fromGenericEntities_aroundBody0(entities, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ Map getMetalakeObjectsFullName_aroundBody2(List metalakeIds, JoinPoint joinPoint) {
        List metalakePOs = SessionUtils.getWithoutCommit(MetalakeMetaMapper.class, mapper -> mapper.listMetalakePOsByMetalakeIds(metalakeIds));
        if (metalakePOs == null || metalakePOs.isEmpty()) {
            return new HashMap();
        }
        HashMap metalakeIdAndNameMap = new HashMap();
        metalakePOs.forEach(metalakePO -> metalakeIdAndNameMap.put(metalakePO.getMetalakeId(), metalakePO.getMetalakeName()));
        return metalakeIdAndNameMap;
    }

    private static final /* synthetic */ Object getMetalakeObjectsFullName_aroundBody3$advice(List metalakeIds, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Map map;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetadataObjectService.getMetalakeObjectsFullName_aroundBody2(metalakeIds, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetadataObjectService.getMetalakeObjectsFullName_aroundBody2(metalakeIds, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Map result = MetadataObjectService.getMetalakeObjectsFullName_aroundBody2(metalakeIds, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                map = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return map;
    }

    private static final /* synthetic */ Map getFilesetObjectsFullName_aroundBody4(List filesetIds, JoinPoint joinPoint) {
        List filesetPOs = SessionUtils.getWithoutCommit(FilesetMetaMapper.class, mapper -> mapper.listFilesetPOsByFilesetIds(filesetIds));
        if (filesetPOs == null || filesetPOs.isEmpty()) {
            return new HashMap();
        }
        List<Long> schemaIds = filesetPOs.stream().map(FilesetPO::getSchemaId).collect(Collectors.toList());
        Map<Long, String> schemaIdAndNameMap = MetadataObjectService.getSchemaObjectsFullName(schemaIds);
        HashMap filesetIdAndNameMap = new HashMap();
        filesetPOs.forEach(filesetPO -> {
            String schemaName = schemaIdAndNameMap.getOrDefault(filesetPO.getSchemaId(), null);
            if (schemaName == null) {
                LOG.warn("The schema of fileset {} may be deleted", (Object)filesetPO.getFilesetId());
                filesetIdAndNameMap.put(filesetPO.getFilesetId(), null);
                return;
            }
            String fullName = DOT_JOINER.join((Object)schemaName, (Object)filesetPO.getFilesetName(), new Object[0]);
            filesetIdAndNameMap.put(filesetPO.getFilesetId(), fullName);
        });
        return filesetIdAndNameMap;
    }

    private static final /* synthetic */ Object getFilesetObjectsFullName_aroundBody5$advice(List filesetIds, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Map map;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetadataObjectService.getFilesetObjectsFullName_aroundBody4(filesetIds, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetadataObjectService.getFilesetObjectsFullName_aroundBody4(filesetIds, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Map result = MetadataObjectService.getFilesetObjectsFullName_aroundBody4(filesetIds, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                map = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return map;
    }

    private static final /* synthetic */ Map getModelObjectsFullName_aroundBody6(List modelIds, JoinPoint joinPoint) {
        List modelPOs = SessionUtils.getWithoutCommit(ModelMetaMapper.class, mapper -> mapper.listModelPOsByModelIds(modelIds));
        if (modelPOs == null || modelPOs.isEmpty()) {
            return new HashMap();
        }
        List<Long> schemaIds = modelPOs.stream().map(ModelPO::getSchemaId).collect(Collectors.toList());
        Map<Long, String> schemaIdAndNameMap = MetadataObjectService.getSchemaObjectsFullName(schemaIds);
        HashMap modelIdAndNameMap = new HashMap();
        modelPOs.forEach(modelPO -> {
            String schemaName = schemaIdAndNameMap.getOrDefault(modelPO.getSchemaId(), null);
            if (schemaName == null) {
                LOG.warn("The schema of model {} may be deleted", (Object)modelPO.getModelId());
                modelIdAndNameMap.put(modelPO.getModelId(), null);
                return;
            }
            String fullName = DOT_JOINER.join((Object)schemaName, (Object)modelPO.getModelName(), new Object[0]);
            modelIdAndNameMap.put(modelPO.getModelId(), fullName);
        });
        return modelIdAndNameMap;
    }

    private static final /* synthetic */ Object getModelObjectsFullName_aroundBody7$advice(List modelIds, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Map map;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetadataObjectService.getModelObjectsFullName_aroundBody6(modelIds, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetadataObjectService.getModelObjectsFullName_aroundBody6(modelIds, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Map result = MetadataObjectService.getModelObjectsFullName_aroundBody6(modelIds, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                map = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return map;
    }

    private static final /* synthetic */ Map getTableObjectsFullName_aroundBody8(List tableIds, JoinPoint joinPoint) {
        List tablePOs = SessionUtils.getWithoutCommit(TableMetaMapper.class, mapper -> mapper.listTablePOsByTableIds(tableIds));
        if (tablePOs == null || tablePOs.isEmpty()) {
            return new HashMap();
        }
        List<Long> schemaIds = tablePOs.stream().map(TablePO::getSchemaId).collect(Collectors.toList());
        Map<Long, String> schemaIdAndNameMap = MetadataObjectService.getSchemaObjectsFullName(schemaIds);
        HashMap tableIdAndNameMap = new HashMap();
        tablePOs.forEach(tablePO -> {
            String schemaName = schemaIdAndNameMap.getOrDefault(tablePO.getSchemaId(), null);
            if (schemaName == null) {
                LOG.warn("The schema of table {} may be deleted", (Object)tablePO.getTableId());
                tableIdAndNameMap.put(tablePO.getTableId(), null);
                return;
            }
            String fullName = DOT_JOINER.join((Object)schemaName, (Object)tablePO.getTableName(), new Object[0]);
            tableIdAndNameMap.put(tablePO.getTableId(), fullName);
        });
        return tableIdAndNameMap;
    }

    private static final /* synthetic */ Object getTableObjectsFullName_aroundBody9$advice(List tableIds, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Map map;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetadataObjectService.getTableObjectsFullName_aroundBody8(tableIds, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetadataObjectService.getTableObjectsFullName_aroundBody8(tableIds, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Map result = MetadataObjectService.getTableObjectsFullName_aroundBody8(tableIds, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                map = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return map;
    }

    private static final /* synthetic */ Map getColumnObjectsFullName_aroundBody10(List columnsIds, JoinPoint joinPoint) {
        List columnPOs = SessionUtils.getWithoutCommit(TableColumnMapper.class, mapper -> mapper.listColumnPOsByColumnIds(columnsIds));
        if (columnPOs == null || columnPOs.isEmpty()) {
            return new HashMap();
        }
        List<Long> tableIds = columnPOs.stream().map(ColumnPO::getTableId).collect(Collectors.toList());
        Map<Long, String> tableIdAndNameMap = MetadataObjectService.getTableObjectsFullName(tableIds);
        HashMap columnIdAndNameMap = new HashMap();
        columnPOs.forEach(columnPO -> {
            String tableName = tableIdAndNameMap.getOrDefault(columnPO.getTableId(), null);
            if (tableName == null) {
                LOG.warn("The table '{}' of column '{}' may be deleted", (Object)columnPO.getTableId(), (Object)columnPO.getColumnId());
                columnIdAndNameMap.put(columnPO.getColumnId(), null);
                return;
            }
            String fullName = DOT_JOINER.join((Object)tableName, (Object)columnPO.getColumnName(), new Object[0]);
            columnIdAndNameMap.put(columnPO.getColumnId(), fullName);
        });
        return columnIdAndNameMap;
    }

    private static final /* synthetic */ Object getColumnObjectsFullName_aroundBody11$advice(List columnsIds, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Map map;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetadataObjectService.getColumnObjectsFullName_aroundBody10(columnsIds, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetadataObjectService.getColumnObjectsFullName_aroundBody10(columnsIds, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Map result = MetadataObjectService.getColumnObjectsFullName_aroundBody10(columnsIds, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                map = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return map;
    }

    private static final /* synthetic */ Map getTopicObjectsFullName_aroundBody12(List topicIds, JoinPoint joinPoint) {
        List topicPOs = SessionUtils.getWithoutCommit(TopicMetaMapper.class, mapper -> mapper.listTopicPOsByTopicIds(topicIds));
        if (topicPOs == null || topicPOs.isEmpty()) {
            return new HashMap();
        }
        List<Long> schemaIds = topicPOs.stream().map(TopicPO::getSchemaId).collect(Collectors.toList());
        Map<Long, String> schemaIdAndNameMap = MetadataObjectService.getSchemaObjectsFullName(schemaIds);
        HashMap topicIdAndNameMap = new HashMap();
        topicPOs.forEach(topicPO -> {
            String schemaName = schemaIdAndNameMap.getOrDefault(topicPO.getSchemaId(), null);
            if (schemaName == null) {
                LOG.warn("The schema of topic {} may be deleted", (Object)topicPO.getTopicId());
                topicIdAndNameMap.put(topicPO.getTopicId(), null);
                return;
            }
            String fullName = DOT_JOINER.join((Object)schemaName, (Object)topicPO.getTopicName(), new Object[0]);
            topicIdAndNameMap.put(topicPO.getTopicId(), fullName);
        });
        return topicIdAndNameMap;
    }

    private static final /* synthetic */ Object getTopicObjectsFullName_aroundBody13$advice(List topicIds, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Map map;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetadataObjectService.getTopicObjectsFullName_aroundBody12(topicIds, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetadataObjectService.getTopicObjectsFullName_aroundBody12(topicIds, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Map result = MetadataObjectService.getTopicObjectsFullName_aroundBody12(topicIds, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                map = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return map;
    }

    private static final /* synthetic */ Map getCatalogObjectsFullName_aroundBody14(List catalogIds, JoinPoint joinPoint) {
        List catalogPOs = SessionUtils.getWithoutCommit(CatalogMetaMapper.class, mapper -> mapper.listCatalogPOsByCatalogIds(catalogIds));
        if (catalogPOs == null || catalogPOs.isEmpty()) {
            return new HashMap();
        }
        HashMap catalogIdAndNameMap = new HashMap();
        catalogPOs.forEach(catalogPO -> catalogIdAndNameMap.put(catalogPO.getCatalogId(), catalogPO.getCatalogName()));
        return catalogIdAndNameMap;
    }

    private static final /* synthetic */ Object getCatalogObjectsFullName_aroundBody15$advice(List catalogIds, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Map map;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetadataObjectService.getCatalogObjectsFullName_aroundBody14(catalogIds, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetadataObjectService.getCatalogObjectsFullName_aroundBody14(catalogIds, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Map result = MetadataObjectService.getCatalogObjectsFullName_aroundBody14(catalogIds, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                map = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return map;
    }

    private static final /* synthetic */ Map getSchemaObjectsFullName_aroundBody16(List schemaIds, JoinPoint joinPoint) {
        List schemaPOs = SessionUtils.getWithoutCommit(SchemaMetaMapper.class, mapper -> mapper.listSchemaPOsBySchemaIds(schemaIds));
        if (schemaPOs == null || schemaPOs.isEmpty()) {
            return new HashMap();
        }
        List<Long> catalogIds = schemaPOs.stream().map(SchemaPO::getCatalogId).collect(Collectors.toList());
        Map<Long, String> catalogIdAndNameMap = MetadataObjectService.getCatalogObjectsFullName(catalogIds);
        HashMap schemaIdAndNameMap = new HashMap();
        schemaPOs.forEach(schemaPO -> {
            String catalogName = catalogIdAndNameMap.getOrDefault(schemaPO.getCatalogId(), null);
            if (catalogName == null) {
                LOG.warn("The catalog of schema {} may be deleted", (Object)schemaPO.getSchemaId());
                schemaIdAndNameMap.put(schemaPO.getSchemaId(), null);
                return;
            }
            String fullName = DOT_JOINER.join((Object)catalogName, (Object)schemaPO.getSchemaName(), new Object[0]);
            schemaIdAndNameMap.put(schemaPO.getSchemaId(), fullName);
        });
        return schemaIdAndNameMap;
    }

    private static final /* synthetic */ Object getSchemaObjectsFullName_aroundBody17$advice(List schemaIds, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Map map;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetadataObjectService.getSchemaObjectsFullName_aroundBody16(schemaIds, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return MetadataObjectService.getSchemaObjectsFullName_aroundBody16(schemaIds, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Map result = MetadataObjectService.getSchemaObjectsFullName_aroundBody16(schemaIds, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                map = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return map;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MetadataObjectService.java", MetadataObjectService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "fromGenericEntities", "org.apache.gravitino.storage.relational.service.MetadataObjectService", "java.util.List", "entities", "", "java.util.List"), 152);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getMetalakeObjectsFullName", "org.apache.gravitino.storage.relational.service.MetadataObjectService", "java.util.List", "metalakeIds", "", "java.util.Map"), 196);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getFilesetObjectsFullName", "org.apache.gravitino.storage.relational.service.MetadataObjectService", "java.util.List", "filesetIds", "", "java.util.Map"), 226);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getModelObjectsFullName", "org.apache.gravitino.storage.relational.service.MetadataObjectService", "java.util.List", "modelIds", "", "java.util.Map"), 272);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getTableObjectsFullName", "org.apache.gravitino.storage.relational.service.MetadataObjectService", "java.util.List", "tableIds", "", "java.util.Map"), 317);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getColumnObjectsFullName", "org.apache.gravitino.storage.relational.service.MetadataObjectService", "java.util.List", "columnsIds", "", "java.util.Map"), 363);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getTopicObjectsFullName", "org.apache.gravitino.storage.relational.service.MetadataObjectService", "java.util.List", "topicIds", "", "java.util.Map"), 411);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getCatalogObjectsFullName", "org.apache.gravitino.storage.relational.service.MetadataObjectService", "java.util.List", "catalogIds", "", "java.util.Map"), 456);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getSchemaObjectsFullName", "org.apache.gravitino.storage.relational.service.MetadataObjectService", "java.util.List", "schemaIds", "", "java.util.Map"), 485);
    }
}

