/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.wan.internal.client.locator;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.cache.client.internal.locator.wan.LocatorMembershipListener;
import org.apache.geode.internal.CopyOnWriteHashSet;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;
import org.apache.geode.internal.lang.utils.JavaWorkarounds;
import org.jetbrains.annotations.NotNull;

public class LocatorHelper {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean addLocator(int distributedSystemId, DistributionLocatorId locator, LocatorMembershipListener locatorListener, DistributionLocatorId sourceLocator) {
        ConcurrentMap<Integer, Set<DistributionLocatorId>> allLocatorsInfo = locatorListener.getAllLocatorsInfo();
        CopyOnWriteHashSet locatorsSet = new CopyOnWriteHashSet();
        locatorsSet.add(locator);
        Set existingValue = allLocatorsInfo.putIfAbsent(distributedSystemId, locatorsSet);
        if (existingValue != null) {
            if (!locator.getMemberName().equals("")) {
                DistributionLocatorId existingLocator = LocatorHelper.getLocatorWithSameMemberName(existingValue, locator);
                if (existingLocator != null) {
                    if (locator.detailCompare(existingLocator)) return false;
                    if (existingLocator.getTimeStamp() > locator.getTimeStamp()) {
                        return false;
                    }
                    existingValue.remove(existingLocator);
                    ConcurrentMap<Integer, Set<String>> allServerLocatorsInfo = locatorListener.getAllServerLocatorsInfo();
                    Set allLocators = (Set)allServerLocatorsInfo.get(distributedSystemId);
                    allLocators.remove(existingLocator.toString());
                    existingValue.add(locator);
                    LocatorHelper.addServerLocator(distributedSystemId, locatorListener, locator);
                    locatorListener.locatorJoined(distributedSystemId, locator, sourceLocator);
                    return true;
                }
                if (!existingValue.contains(locator)) {
                    existingValue.add(locator);
                    LocatorHelper.addServerLocator(distributedSystemId, locatorListener, locator);
                    locatorListener.locatorJoined(distributedSystemId, locator, sourceLocator);
                    return true;
                }
                DistributionLocatorId oldLocator = LocatorHelper.getLocatorFromCollection(existingValue, locator);
                if (oldLocator == null) {
                    return false;
                }
                if (oldLocator.getTimeStamp() > locator.getTimeStamp()) {
                    return false;
                }
                existingValue.remove(oldLocator);
                existingValue.add(locator);
                locatorListener.locatorJoined(distributedSystemId, locator, sourceLocator);
                return true;
            }
            if (existingValue.contains(locator)) return false;
            existingValue.add(locator);
            LocatorHelper.addServerLocator(distributedSystemId, locatorListener, locator);
            locatorListener.locatorJoined(distributedSystemId, locator, sourceLocator);
            return true;
        } else {
            LocatorHelper.addServerLocator(distributedSystemId, locatorListener, locator);
            locatorListener.locatorJoined(distributedSystemId, locator, sourceLocator);
        }
        return true;
    }

    static void addServerLocator(@NotNull Integer distributedSystemId, @NotNull LocatorMembershipListener locatorListener, @NotNull DistributionLocatorId locator) {
        JavaWorkarounds.computeIfAbsent(locatorListener.getAllServerLocatorsInfo(), distributedSystemId, k -> new CopyOnWriteHashSet()).add(locator.marshalForClients());
    }

    public static boolean addExchangedLocators(Map<Integer, Set<DistributionLocatorId>> locators, LocatorMembershipListener locatorListener) {
        ConcurrentMap<Integer, Set<DistributionLocatorId>> allLocators = locatorListener.getAllLocatorsInfo();
        if (!allLocators.equals(locators)) {
            for (Map.Entry<Integer, Set<DistributionLocatorId>> entry : locators.entrySet()) {
                Set existingValue = allLocators.putIfAbsent(entry.getKey(), new CopyOnWriteHashSet<DistributionLocatorId>(entry.getValue()));
                if (existingValue != null) {
                    Set localLocators = (Set)allLocators.get(entry.getKey());
                    if (localLocators.equals(entry.getValue())) continue;
                    entry.getValue().removeAll(localLocators);
                    for (DistributionLocatorId locator : entry.getValue()) {
                        DistributionLocatorId existingLocator;
                        if (!locator.getMemberName().equals("") && !localLocators.isEmpty() && (existingLocator = LocatorHelper.getLocatorWithSameMemberName(localLocators, locator)) != null) continue;
                        localLocators.add(locator);
                        LocatorHelper.addServerLocator(entry.getKey(), locatorListener, locator);
                        locatorListener.locatorJoined(entry.getKey(), locator, null);
                    }
                    continue;
                }
                for (DistributionLocatorId locator : entry.getValue()) {
                    LocatorHelper.addServerLocator(entry.getKey(), locatorListener, locator);
                    locatorListener.locatorJoined(entry.getKey(), locator, null);
                }
            }
            return true;
        }
        return false;
    }

    private static DistributionLocatorId getLocatorWithSameMemberName(Set<DistributionLocatorId> locatorSet, DistributionLocatorId locator) {
        for (DistributionLocatorId locElement : locatorSet) {
            if (!locator.getMemberName().equals(locElement.getMemberName())) continue;
            return locElement;
        }
        return null;
    }

    private static DistributionLocatorId getLocatorFromCollection(Set<DistributionLocatorId> locatorSet, DistributionLocatorId locator) {
        for (DistributionLocatorId locElement : locatorSet) {
            if (!locator.equals(locElement)) continue;
            return locElement;
        }
        return null;
    }
}

