/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;

public class ClientHealthStats
implements DataSerializableFixedID,
Serializable {
    private static final long serialVersionUID = 4229401714870332766L;
    protected long numOfGets;
    protected long numOfPuts;
    protected long numOfMisses;
    protected int numOfCacheListenerCalls;
    protected int numOfThreads;
    protected long processCpuTime;
    protected int cpus;
    protected Date updateTime;
    private HashMap<String, String> poolStats = new HashMap();
    @Immutable
    private static final KnownVersion[] dsfidVersions = new KnownVersion[]{KnownVersion.GEODE_1_9_0};

    public long getNumOfGets() {
        return this.numOfGets;
    }

    public void setNumOfGets(long numOfGets) {
        this.numOfGets = numOfGets;
    }

    public long getNumOfPuts() {
        return this.numOfPuts;
    }

    public void setNumOfPuts(long numOfPuts) {
        this.numOfPuts = numOfPuts;
    }

    public long getNumOfMisses() {
        return this.numOfMisses;
    }

    public void setNumOfMisses(long numOfMisses) {
        this.numOfMisses = numOfMisses;
    }

    public int getNumOfCacheListenerCalls() {
        return this.numOfCacheListenerCalls;
    }

    public void setNumOfCacheListenerCalls(int numOfCacheListenerCalls) {
        this.numOfCacheListenerCalls = numOfCacheListenerCalls;
    }

    public int getNumOfThreads() {
        return this.numOfThreads;
    }

    public void setNumOfThreads(int numOfThreads) {
        this.numOfThreads = numOfThreads;
    }

    public long getProcessCpuTime() {
        return this.processCpuTime;
    }

    public void setProcessCpuTime(long processCpuTime) {
        this.processCpuTime = processCpuTime;
    }

    public int getCpus() {
        return this.cpus;
    }

    public void setCpus(int cpus) {
        this.cpus = cpus;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        DataSerializer.writePrimitiveLong(this.numOfGets, out);
        DataSerializer.writePrimitiveLong(this.numOfPuts, out);
        DataSerializer.writePrimitiveLong(this.numOfMisses, out);
        DataSerializer.writePrimitiveInt(this.numOfCacheListenerCalls, out);
        DataSerializer.writePrimitiveInt(this.numOfThreads, out);
        DataSerializer.writePrimitiveInt(this.cpus, out);
        DataSerializer.writePrimitiveLong(this.processCpuTime, out);
        DataSerializer.writeDate(this.updateTime, out);
        DataSerializer.writeHashMap(this.poolStats, out);
    }

    public void toDataPre_GEODE_1_9_0_0(DataOutput out, SerializationContext context) throws IOException {
        DataSerializer.writePrimitiveInt((int)this.numOfGets, out);
        DataSerializer.writePrimitiveInt((int)this.numOfPuts, out);
        DataSerializer.writePrimitiveInt((int)this.numOfMisses, out);
        DataSerializer.writePrimitiveInt(this.numOfCacheListenerCalls, out);
        DataSerializer.writePrimitiveInt(this.numOfThreads, out);
        DataSerializer.writePrimitiveInt(this.cpus, out);
        DataSerializer.writePrimitiveLong(this.processCpuTime, out);
        DataSerializer.writeDate(this.updateTime, out);
        DataSerializer.writeHashMap(this.poolStats, out);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.numOfGets = DataSerializer.readPrimitiveLong(in);
        this.numOfPuts = DataSerializer.readPrimitiveLong(in);
        this.numOfMisses = DataSerializer.readPrimitiveLong(in);
        this.numOfCacheListenerCalls = DataSerializer.readPrimitiveInt(in);
        this.numOfThreads = DataSerializer.readPrimitiveInt(in);
        this.cpus = DataSerializer.readPrimitiveInt(in);
        this.processCpuTime = DataSerializer.readPrimitiveLong(in);
        this.updateTime = DataSerializer.readDate(in);
        this.poolStats = DataSerializer.readHashMap(in);
    }

    public void fromDataPre_GEODE_1_9_0_0(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.numOfGets = DataSerializer.readPrimitiveInt(in);
        this.numOfPuts = DataSerializer.readPrimitiveInt(in);
        this.numOfMisses = DataSerializer.readPrimitiveInt(in);
        this.numOfCacheListenerCalls = DataSerializer.readPrimitiveInt(in);
        this.numOfThreads = DataSerializer.readPrimitiveInt(in);
        this.cpus = DataSerializer.readPrimitiveInt(in);
        this.processCpuTime = DataSerializer.readPrimitiveLong(in);
        this.updateTime = DataSerializer.readDate(in);
        this.poolStats = DataSerializer.readHashMap(in);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ClientHealthStats [");
        buf.append("\n numOfGets=").append(this.numOfGets);
        buf.append("\n numOfPuts=").append(this.numOfPuts);
        buf.append("\n numOfMisses=").append(this.numOfMisses);
        buf.append("\n numOfCacheListenerCalls=").append(this.numOfCacheListenerCalls);
        buf.append("\n numOfThreads=").append(this.numOfThreads);
        buf.append("\n cpus=").append(this.cpus);
        buf.append("\n processCpuTime=").append(this.processCpuTime);
        buf.append("\n updateTime=").append(this.updateTime);
        Iterator<Map.Entry<String, String>> it = this.poolStats.entrySet().iterator();
        StringBuilder tempBuffer = new StringBuilder();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            tempBuffer.append(entry.getKey()).append(" = ").append(entry.getValue());
        }
        buf.append("\n poolStats ").append((CharSequence)tempBuffer);
        buf.append("\n]");
        return buf.toString();
    }

    public int getDSFID() {
        return -126;
    }

    public KnownVersion[] getSerializationVersions() {
        return dsfidVersions;
    }

    public HashMap<String, String> getPoolStats() {
        return this.poolStats;
    }

    public void setPoolStats(HashMap<String, String> statsMap) {
        this.poolStats = statsMap;
    }
}

