/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.LinkedList;
import java.util.List;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.internal.deployment.JarDeploymentService;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.configuration.Deployment;
import org.apache.geode.management.internal.cli.domain.DeploymentInfo;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.logging.log4j.Logger;

public class ListDeployedFunction
implements InternalFunction<Void> {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;
    private static final String ID = "org.apache.geode.management.internal.cli.functions.ListDeployedFunction";

    public String getId() {
        return ID;
    }

    public void execute(FunctionContext<Void> context) {
        String memberId = "";
        try {
            InternalCache cache = (InternalCache)context.getCache();
            JarDeploymentService jarDeploymentService = ClassPathLoader.getLatest().getJarDeploymentService();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            List deployments = jarDeploymentService.listDeployed();
            LinkedList<DeploymentInfo> jars = new LinkedList<DeploymentInfo>();
            for (Deployment deployment : deployments) {
                jars.add(new DeploymentInfo(memberId, deployment));
            }
            CliFunctionResult result = new CliFunctionResult(memberId, jars, null);
            context.getResultSender().lastResult((Object)result);
        }
        catch (Exception cce) {
            logger.error(cce.getMessage(), (Throwable)cce);
            CliFunctionResult result = new CliFunctionResult(memberId, false, cce.getMessage());
            context.getResultSender().lastResult((Object)result);
        }
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public boolean isHA() {
        return false;
    }
}

