/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.otel;

import java.time.Duration;
import java.util.function.Consumer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TimeUtils;

@PublicEvolving
@Documentation.SuffixOption(value="metrics.reporter.OpenTelemetry")
public final class OpenTelemetryReporterOptions {
    public static final ConfigOption<String> EXPORTER_ENDPOINT = ConfigOptions.key((String)"exporter.endpoint").stringType().noDefaultValue().withDescription(Description.builder().text("Endpoint for the OpenTelemetry Reporters.").build());
    public static final ConfigOption<String> EXPORTER_TIMEOUT = ConfigOptions.key((String)"exporter.timeout").stringType().noDefaultValue().withDescription(Description.builder().text("Timeout for OpenTelemetry Reporters, as Duration string. Example: 10s for 10 seconds").build());
    public static final ConfigOption<String> SERVICE_NAME = ConfigOptions.key((String)"service.name").stringType().noDefaultValue().withDescription(Description.builder().text("service.name passed to OpenTelemetry Reporters.").build());
    @PublicEvolving
    public static final ConfigOption<String> SERVICE_VERSION = ConfigOptions.key((String)"service.version").stringType().noDefaultValue().withDescription(Description.builder().text("service.version passed to OpenTelemetry Reporters.").build());

    private OpenTelemetryReporterOptions() {
    }

    @Internal
    public static void tryConfigureTimeout(MetricConfig metricConfig, Consumer<Duration> builder) {
        String timeoutConfKey = EXPORTER_TIMEOUT.key();
        if (metricConfig.containsKey((Object)timeoutConfKey)) {
            builder.accept(TimeUtils.parseDuration((String)metricConfig.getProperty(timeoutConfKey)));
        }
    }

    @Internal
    public static void tryConfigureEndpoint(MetricConfig metricConfig, Consumer<String> builder) {
        String endpointConfKey = EXPORTER_ENDPOINT.key();
        Preconditions.checkArgument((boolean)metricConfig.containsKey((Object)endpointConfKey), (Object)("Must set " + EXPORTER_ENDPOINT.key()));
        builder.accept(metricConfig.getProperty(endpointConfKey));
    }
}

