/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnValueWireType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.security.keyvault.keys.KeyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientBuilder;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.azure.security.keyvault.keys.implementation.KeyBackup;
import com.azure.security.keyvault.keys.implementation.KeyImportRequestParameters;
import com.azure.security.keyvault.keys.implementation.KeyReleaseParameters;
import com.azure.security.keyvault.keys.implementation.KeyRequestAttributes;
import com.azure.security.keyvault.keys.implementation.KeyRequestParameters;
import com.azure.security.keyvault.keys.implementation.KeyRestoreRequestParameters;
import com.azure.security.keyvault.keys.implementation.KeyVaultErrorCodeStrings;
import com.azure.security.keyvault.keys.implementation.models.DeletedKeyPage;
import com.azure.security.keyvault.keys.implementation.models.GetRandomBytesRequest;
import com.azure.security.keyvault.keys.implementation.models.KeyPropertiesPage;
import com.azure.security.keyvault.keys.implementation.models.RandomBytes;
import com.azure.security.keyvault.keys.models.CreateEcKeyOptions;
import com.azure.security.keyvault.keys.models.CreateKeyOptions;
import com.azure.security.keyvault.keys.models.CreateOctKeyOptions;
import com.azure.security.keyvault.keys.models.CreateRsaKeyOptions;
import com.azure.security.keyvault.keys.models.DeletedKey;
import com.azure.security.keyvault.keys.models.ImportKeyOptions;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyProperties;
import com.azure.security.keyvault.keys.models.KeyRotationPolicy;
import com.azure.security.keyvault.keys.models.KeyType;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import com.azure.security.keyvault.keys.models.ReleaseKeyOptions;
import com.azure.security.keyvault.keys.models.ReleaseKeyResult;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public class KeyClientImpl {
    static final String ACCEPT_LANGUAGE = "en-US";
    static final int DEFAULT_MAX_PAGE_RESULTS = 25;
    static final String CONTENT_TYPE_HEADER_VALUE = "application/json";
    private static final String KEYVAULT_TRACING_NAMESPACE_VALUE = "Microsoft.KeyVault";
    private static final String HTTP_REST_PROXY_SYNC_PROXY_ENABLE = "com.azure.core.http.restproxy.syncproxy.enable";
    private static final Duration DEFAULT_POLLING_INTERVAL = Duration.ofSeconds(1L);
    private final String vaultUrl;
    private final KeyService service;
    private final ClientLogger logger = new ClientLogger(KeyClientImpl.class);
    private final HttpPipeline pipeline;
    private final KeyServiceVersion keyServiceVersion;

    public KeyClientImpl(String vaultUrl, HttpPipeline pipeline, KeyServiceVersion keyServiceVersion) {
        Objects.requireNonNull(vaultUrl, KeyVaultErrorCodeStrings.getErrorString("vault_endpoint_required"));
        this.vaultUrl = vaultUrl;
        this.service = (KeyService)RestProxy.create(KeyService.class, (HttpPipeline)pipeline);
        this.pipeline = pipeline;
        this.keyServiceVersion = keyServiceVersion;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    public HttpPipeline getHttpPipeline() {
        return this.pipeline;
    }

    public Duration getDefaultPollingInterval() {
        return DEFAULT_POLLING_INTERVAL;
    }

    public KeyServiceVersion getKeyServiceVersion() {
        return this.keyServiceVersion;
    }

    public Mono<Response<KeyVaultKey>> createKeyWithResponseAsync(String name, KeyType keyType, Context context) {
        KeyRequestParameters parameters = new KeyRequestParameters().setKty(keyType);
        return this.service.createKeyAsync(this.vaultUrl, name, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Creating key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Created key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to create key - {}", new Object[]{name, error}));
    }

    public Response<KeyVaultKey> createKeyWithResponse(String name, KeyType keyType, Context context) {
        KeyRequestParameters parameters = new KeyRequestParameters().setKty(keyType);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.createKey(this.vaultUrl, name, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    public Mono<Response<KeyVaultKey>> createKeyWithResponseAsync(CreateKeyOptions createKeyOptions, Context context) {
        KeyRequestParameters parameters = this.validateAndCreateKeyRequestParameters(createKeyOptions);
        return this.service.createKeyAsync(this.vaultUrl, createKeyOptions.getName(), this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Creating key - {}", new Object[]{createKeyOptions.getName()})).doOnSuccess(response -> this.logger.verbose("Created key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to create key - {}", new Object[]{createKeyOptions.getName(), error}));
    }

    public Response<KeyVaultKey> createKeyWithResponse(CreateKeyOptions createKeyOptions, Context context) {
        KeyRequestParameters parameters = this.validateAndCreateKeyRequestParameters(createKeyOptions);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.createKey(this.vaultUrl, createKeyOptions.getName(), this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    private KeyRequestParameters validateAndCreateKeyRequestParameters(CreateKeyOptions createKeyOptions) {
        Objects.requireNonNull(createKeyOptions, "The key create options parameter cannot be null.");
        return new KeyRequestParameters().setKty(createKeyOptions.getKeyType()).setKeyOps(createKeyOptions.getKeyOperations()).setKeyAttributes(new KeyRequestAttributes(createKeyOptions)).setTags(createKeyOptions.getTags()).setReleasePolicy(createKeyOptions.getReleasePolicy());
    }

    public Mono<Response<KeyVaultKey>> createRsaKeyWithResponseAsync(CreateRsaKeyOptions createRsaKeyOptions, Context context) {
        KeyRequestParameters parameters = this.validateAndCreateRsaKeyRequestParameters(createRsaKeyOptions);
        return this.service.createKeyAsync(this.vaultUrl, createRsaKeyOptions.getName(), this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Creating RSA key - {}", new Object[]{createRsaKeyOptions.getName()})).doOnSuccess(response -> this.logger.verbose("Created RSA key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to create RSA key - {}", new Object[]{createRsaKeyOptions.getName(), error}));
    }

    public Response<KeyVaultKey> createRsaKeyWithResponse(CreateRsaKeyOptions createRsaKeyOptions, Context context) {
        KeyRequestParameters parameters = this.validateAndCreateRsaKeyRequestParameters(createRsaKeyOptions);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.createKey(this.vaultUrl, createRsaKeyOptions.getName(), this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    private KeyRequestParameters validateAndCreateRsaKeyRequestParameters(CreateRsaKeyOptions createRsaKeyOptions) {
        Objects.requireNonNull(createRsaKeyOptions, "The RSA key options parameter cannot be null.");
        return new KeyRequestParameters().setKty(createRsaKeyOptions.getKeyType()).setKeySize(createRsaKeyOptions.getKeySize()).setKeyOps(createRsaKeyOptions.getKeyOperations()).setKeyAttributes(new KeyRequestAttributes(createRsaKeyOptions)).setPublicExponent(createRsaKeyOptions.getPublicExponent()).setTags(createRsaKeyOptions.getTags()).setReleasePolicy(createRsaKeyOptions.getReleasePolicy());
    }

    public Mono<Response<KeyVaultKey>> createEcKeyWithResponseAsync(CreateEcKeyOptions createEcKeyOptions, Context context) {
        KeyRequestParameters parameters = this.validateAndCreateEcKeyRequestParameters(createEcKeyOptions);
        return this.service.createKeyAsync(this.vaultUrl, createEcKeyOptions.getName(), this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Creating EC key - {}", new Object[]{createEcKeyOptions.getName()})).doOnSuccess(response -> this.logger.verbose("Created EC key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to create EC key - {}", new Object[]{createEcKeyOptions.getName(), error}));
    }

    public Response<KeyVaultKey> createEcKeyWithResponse(CreateEcKeyOptions createEcKeyOptions, Context context) {
        KeyRequestParameters parameters = this.validateAndCreateEcKeyRequestParameters(createEcKeyOptions);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.createKey(this.vaultUrl, createEcKeyOptions.getName(), this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    private KeyRequestParameters validateAndCreateEcKeyRequestParameters(CreateEcKeyOptions createEcKeyOptions) {
        Objects.requireNonNull(createEcKeyOptions, "The EC key options cannot be null.");
        return new KeyRequestParameters().setKty(createEcKeyOptions.getKeyType()).setCurve(createEcKeyOptions.getCurveName()).setKeyOps(createEcKeyOptions.getKeyOperations()).setKeyAttributes(new KeyRequestAttributes(createEcKeyOptions)).setTags(createEcKeyOptions.getTags()).setReleasePolicy(createEcKeyOptions.getReleasePolicy());
    }

    public Mono<Response<KeyVaultKey>> createOctKeyWithResponseAsync(CreateOctKeyOptions createOctKeyOptions, Context context) {
        KeyRequestParameters parameters = this.validateAndCreateOctKeyRequestParameters(createOctKeyOptions);
        return this.service.createKeyAsync(this.vaultUrl, createOctKeyOptions.getName(), this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Creating symmetric key - {}", new Object[]{createOctKeyOptions.getName()})).doOnSuccess(response -> this.logger.verbose("Created symmetric key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to create symmetric key - {}", new Object[]{createOctKeyOptions.getName(), error}));
    }

    public Response<KeyVaultKey> createOctKeyWithResponse(CreateOctKeyOptions createOctKeyOptions, Context context) {
        KeyRequestParameters parameters = this.validateAndCreateOctKeyRequestParameters(createOctKeyOptions);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.createKey(this.vaultUrl, createOctKeyOptions.getName(), this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    private KeyRequestParameters validateAndCreateOctKeyRequestParameters(CreateOctKeyOptions createOctKeyOptions) {
        Objects.requireNonNull(createOctKeyOptions, "The create key options cannot be null.");
        return new KeyRequestParameters().setKty(createOctKeyOptions.getKeyType()).setKeySize(createOctKeyOptions.getKeySize()).setKeyOps(createOctKeyOptions.getKeyOperations()).setKeyAttributes(new KeyRequestAttributes(createOctKeyOptions)).setTags(createOctKeyOptions.getTags()).setReleasePolicy(createOctKeyOptions.getReleasePolicy());
    }

    public Mono<Response<KeyVaultKey>> importKeyWithResponseAsync(String name, JsonWebKey keyMaterial, Context context) {
        KeyImportRequestParameters parameters = new KeyImportRequestParameters().setKey(keyMaterial);
        return this.service.importKeyAsync(this.vaultUrl, name, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Importing key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Imported key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to import key - {}", new Object[]{name, error}));
    }

    public Response<KeyVaultKey> importKeyWithResponse(String name, JsonWebKey keyMaterial, Context context) {
        KeyImportRequestParameters parameters = new KeyImportRequestParameters().setKey(keyMaterial);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.importKey(this.vaultUrl, name, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    public Mono<Response<KeyVaultKey>> importKeyWithResponseAsync(ImportKeyOptions importKeyOptions, Context context) {
        KeyImportRequestParameters parameters = this.validateAndCreateKeyImportRequestParameters(importKeyOptions);
        return this.service.importKeyAsync(this.vaultUrl, importKeyOptions.getName(), this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Importing key - {}", new Object[]{importKeyOptions.getName()})).doOnSuccess(response -> this.logger.verbose("Imported key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to import key - {}", new Object[]{importKeyOptions.getName(), error}));
    }

    public Response<KeyVaultKey> importKeyWithResponse(ImportKeyOptions importKeyOptions, Context context) {
        KeyImportRequestParameters parameters = this.validateAndCreateKeyImportRequestParameters(importKeyOptions);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.importKey(this.vaultUrl, importKeyOptions.getName(), this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    private KeyImportRequestParameters validateAndCreateKeyImportRequestParameters(ImportKeyOptions importKeyOptions) {
        Objects.requireNonNull(importKeyOptions, "The key import configuration parameter cannot be null.");
        return new KeyImportRequestParameters().setKey(importKeyOptions.getKey()).setHsm(importKeyOptions.isHardwareProtected()).setKeyAttributes(new KeyRequestAttributes(importKeyOptions)).setTags(importKeyOptions.getTags()).setReleasePolicy(importKeyOptions.getReleasePolicy());
    }

    public Mono<Response<KeyVaultKey>> getKeyWithResponseAsync(String name, String version, Context context) {
        return this.service.getKeyAsync(this.vaultUrl, name, version, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Retrieving key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Retrieved key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to retrieve key - {}", new Object[]{name, error}));
    }

    public Response<KeyVaultKey> getKeyWithResponse(String name, String version, Context context) {
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.getKey(this.vaultUrl, name, version, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    public Mono<Response<KeyVaultKey>> updateKeyPropertiesWithResponseAsync(KeyProperties keyProperties, Context context, KeyOperation ... keyOperations) {
        KeyRequestParameters parameters = this.validateAndCreateUpdateKeyRequestParameters(keyProperties, keyOperations);
        return this.service.updateKeyAsync(this.vaultUrl, keyProperties.getName(), keyProperties.getVersion(), this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Updating key - {}", new Object[]{keyProperties.getName()})).doOnSuccess(response -> this.logger.verbose("Updated key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to update key - {}", new Object[]{keyProperties.getName(), error}));
    }

    public Response<KeyVaultKey> updateKeyPropertiesWithResponse(KeyProperties keyProperties, Context context, KeyOperation ... keyOperations) {
        KeyRequestParameters parameters = this.validateAndCreateUpdateKeyRequestParameters(keyProperties, keyOperations);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.updateKey(this.vaultUrl, keyProperties.getName(), keyProperties.getVersion(), this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    private KeyRequestParameters validateAndCreateUpdateKeyRequestParameters(KeyProperties keyProperties, KeyOperation ... keyOperations) {
        Objects.requireNonNull(keyProperties, "The key properties input parameter cannot be null.");
        KeyRequestParameters parameters = new KeyRequestParameters().setTags(keyProperties.getTags()).setKeyAttributes(new KeyRequestAttributes(keyProperties)).setReleasePolicy(keyProperties.getReleasePolicy());
        if (keyOperations.length > 0) {
            parameters.setKeyOps(Arrays.asList(keyOperations));
        }
        return parameters;
    }

    public PollerFlux<DeletedKey, Void> beginDeleteKeyAsync(String name) {
        return new PollerFlux(this.getDefaultPollingInterval(), this.activationOperation(name), this.createPollOperation(name), (context, firstResponse) -> Mono.empty(), context -> Mono.empty());
    }

    private Function<PollingContext<DeletedKey>, Mono<DeletedKey>> activationOperation(String name) {
        return pollingContext -> FluxUtil.withContext(context -> this.deleteKeyWithResponse(name, (Context)context)).flatMap(deletedKeyResponse -> Mono.just((Object)((DeletedKey)deletedKeyResponse.getValue())));
    }

    private Function<PollingContext<DeletedKey>, Mono<PollResponse<DeletedKey>>> createPollOperation(String keyName) {
        return pollingContext -> FluxUtil.withContext(context -> this.service.getDeletedKeyPollerAsync(this.vaultUrl, keyName, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE))).flatMap(deletedKeyResponse -> {
            if (deletedKeyResponse.getStatusCode() == 404) {
                return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((DeletedKey)pollingContext.getLatestResponse().getValue()))));
            }
            return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedKey)deletedKeyResponse.getValue()))));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedKey)pollingContext.getLatestResponse().getValue())));
    }

    private Mono<Response<DeletedKey>> deleteKeyWithResponse(String name, Context context) {
        return this.service.deleteKeyAsync(this.vaultUrl, name, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Deleting key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Deleted key - {}", new Object[]{((DeletedKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to delete key - {}", new Object[]{name, error}));
    }

    public Mono<Response<DeletedKey>> getDeletedKeyWithResponseAsync(String name, Context context) {
        return this.service.getDeletedKeyAsync(this.vaultUrl, name, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Retrieving deleted key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Retrieved deleted key - {}", new Object[]{((DeletedKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to retrieve deleted key - {}", new Object[]{name, error}));
    }

    public Response<DeletedKey> getDeletedKeyWithResponse(String name, Context context) {
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.getDeletedKey(this.vaultUrl, name, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    public Mono<Response<Void>> purgeDeletedKeyWithResponseAsync(String name, Context context) {
        return this.service.purgeDeletedKeyAsync(this.vaultUrl, name, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Purging deleted key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Purged deleted key - {}", new Object[]{name})).doOnError(error -> this.logger.warning("Failed to purge deleted key - {}", new Object[]{name, error}));
    }

    public Response<Void> purgeDeletedKeyWithResponse(String name, Context context) {
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.purgeDeletedKey(this.vaultUrl, name, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    public PollerFlux<KeyVaultKey, Void> beginRecoverDeletedKeyAsync(String name) {
        return new PollerFlux(this.getDefaultPollingInterval(), this.recoverActivationOperation(name), this.createRecoverPollOperation(name), (context, firstResponse) -> Mono.empty(), context -> Mono.empty());
    }

    private Function<PollingContext<KeyVaultKey>, Mono<KeyVaultKey>> recoverActivationOperation(String name) {
        return pollingContext -> FluxUtil.withContext(context -> this.recoverDeletedKeyWithResponse(name, (Context)context)).flatMap(keyResponse -> Mono.just((Object)((KeyVaultKey)keyResponse.getValue())));
    }

    private Function<PollingContext<KeyVaultKey>, Mono<PollResponse<KeyVaultKey>>> createRecoverPollOperation(String keyName) {
        return pollingContext -> FluxUtil.withContext(context -> this.service.getKeyPollerAsync(this.vaultUrl, keyName, "", this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE))).flatMap(keyResponse -> {
            if (keyResponse.getStatusCode() == 404) {
                return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((KeyVaultKey)pollingContext.getLatestResponse().getValue()))));
            }
            return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultKey)keyResponse.getValue()))));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultKey)pollingContext.getLatestResponse().getValue())));
    }

    private Mono<Response<KeyVaultKey>> recoverDeletedKeyWithResponse(String name, Context context) {
        return this.service.recoverDeletedKeyAsync(this.vaultUrl, name, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Recovering deleted key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Recovered deleted key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to recover deleted key - {}", new Object[]{name, error}));
    }

    public Mono<Response<byte[]>> backupKeyWithResponseAsync(String name, Context context) {
        return this.service.backupKeyAsync(this.vaultUrl, name, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Backing up key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Backed up key - {}", new Object[]{name})).doOnError(error -> this.logger.warning("Failed to back up key - {}", new Object[]{name, error})).flatMap(base64URLResponse -> Mono.just((Object)new SimpleResponse(base64URLResponse.getRequest(), base64URLResponse.getStatusCode(), base64URLResponse.getHeaders(), (Object)((KeyBackup)base64URLResponse.getValue()).getValue())));
    }

    public Response<byte[]> backupKeyWithResponse(String name, Context context) {
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        Response<KeyBackup> backupResponse = this.service.backupKey(this.vaultUrl, name, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
        return new SimpleResponse(backupResponse.getRequest(), backupResponse.getStatusCode(), backupResponse.getHeaders(), (Object)((KeyBackup)backupResponse.getValue()).getValue());
    }

    public Mono<Response<KeyVaultKey>> restoreKeyBackupWithResponseAsync(byte[] backup, Context context) {
        KeyRestoreRequestParameters parameters = new KeyRestoreRequestParameters().setKeyBackup(backup);
        return this.service.restoreKeyAsync(this.vaultUrl, this.keyServiceVersion.getVersion(), parameters, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Restoring key")).doOnSuccess(response -> this.logger.verbose("Restored key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to restore key", new Object[]{error}));
    }

    public Response<KeyVaultKey> restoreKeyBackupWithResponse(byte[] backup, Context context) {
        KeyRestoreRequestParameters parameters = new KeyRestoreRequestParameters().setKeyBackup(backup);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.restoreKey(this.vaultUrl, this.keyServiceVersion.getVersion(), parameters, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    public PagedFlux<KeyProperties> listPropertiesOfKeys() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(this::listKeysFirstPage), continuationToken -> FluxUtil.withContext(context -> this.listKeysNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    public PagedFlux<KeyProperties> listPropertiesOfKeys(Context context) {
        return new PagedFlux(() -> this.listKeysFirstPage(context), continuationToken -> this.listKeysNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<KeyProperties>> listKeysFirstPage(Context context) {
        try {
            return this.service.getKeysAsync(this.vaultUrl, 25, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing keys")).doOnSuccess(response -> this.logger.verbose("Listed keys")).doOnError(error -> this.logger.warning("Failed to list keys", new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<KeyProperties>> listKeysNextPage(String continuationToken, Context context) {
        try {
            return this.service.getKeysAsync(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing next keys page - Page {} ", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.verbose("Listed next keys page - Page {} ", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to list next keys page - Page {} ", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public PagedFlux<DeletedKey> listDeletedKeys() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(this::listDeletedKeysFirstPage), continuationToken -> FluxUtil.withContext(context -> this.listDeletedKeysNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    public PagedFlux<DeletedKey> listDeletedKeys(Context context) {
        return new PagedFlux(() -> this.listDeletedKeysFirstPage(context), continuationToken -> this.listDeletedKeysNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<DeletedKey>> listDeletedKeysFirstPage(Context context) {
        try {
            return this.service.getDeletedKeysAsync(this.vaultUrl, 25, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing deleted keys")).doOnSuccess(response -> this.logger.verbose("Listed deleted keys")).doOnError(error -> this.logger.warning("Failed to list deleted keys", new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<DeletedKey>> listDeletedKeysNextPage(String continuationToken, Context context) {
        try {
            return this.service.getDeletedKeysAsync(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing next deleted keys page - Page {} ", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.verbose("Listed next deleted keys page - Page {} ", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to list next deleted keys page - Page {} ", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public PagedFlux<KeyProperties> listPropertiesOfKeyVersions(String name) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listKeyVersionsFirstPage(name, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listKeyVersionsNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    public PagedFlux<KeyProperties> listPropertiesOfKeyVersions(String name, Context context) {
        return new PagedFlux(() -> this.listKeyVersionsFirstPage(name, context), continuationToken -> this.listKeyVersionsNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<KeyProperties>> listKeyVersionsFirstPage(String name, Context context) {
        try {
            return this.service.getKeyVersionsAsync(this.vaultUrl, name, 25, this.keyServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing key versions - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Listed key versions - {}", new Object[]{name})).doOnError(error -> this.logger.warning("Failed to list key versions - {}", new Object[]{name, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<KeyProperties>> listKeyVersionsNextPage(String continuationToken, Context context) {
        try {
            return this.service.getKeysAsync(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing next key versions page - Page {} ", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.verbose("Listed next key versions page - Page {} ", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to list next key versions page - Page {} ", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<byte[]>> getRandomBytesWithResponseAsync(int count, Context context) {
        try {
            return this.service.getRandomBytesAsync(this.vaultUrl, this.keyServiceVersion.getVersion(), new GetRandomBytesRequest().setCount(count), CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Getting {} random bytes.", new Object[]{count})).doOnSuccess(response -> this.logger.verbose("Got {} random bytes.", new Object[]{count})).doOnError(error -> this.logger.warning("Failed to get random bytes - {}", new Object[]{error})).map(response -> new SimpleResponse(response, (Object)((RandomBytes)response.getValue()).getBytes()));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    public Response<byte[]> getRandomBytesWithResponse(int count, Context context) {
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        Response<RandomBytes> randomBytesResponse = this.service.getRandomBytes(this.vaultUrl, this.keyServiceVersion.getVersion(), new GetRandomBytesRequest().setCount(count), CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
        return new SimpleResponse(randomBytesResponse, (Object)((RandomBytes)randomBytesResponse.getValue()).getBytes());
    }

    public Mono<Response<ReleaseKeyResult>> releaseKeyWithResponseAsync(String name, String version, String targetAttestationToken, ReleaseKeyOptions releaseKeyOptions, Context context) {
        try {
            KeyReleaseParameters keyReleaseParameters = this.validateAndCreateKeyReleaseParameters(name, targetAttestationToken, releaseKeyOptions);
            return this.service.releaseAsync(this.vaultUrl, name, version, this.keyServiceVersion.getVersion(), keyReleaseParameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Releasing key with name %s and version %s.", new Object[]{name, version})).doOnSuccess(response -> this.logger.verbose("Released key with name %s and version %s.", new Object[]{name, version})).doOnError(error -> this.logger.warning("Failed to release key - {}", new Object[]{error}));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    public Response<ReleaseKeyResult> releaseKeyWithResponse(String name, String version, String targetAttestationToken, ReleaseKeyOptions releaseKeyOptions, Context context) {
        try {
            KeyReleaseParameters keyReleaseParameters = this.validateAndCreateKeyReleaseParameters(name, targetAttestationToken, releaseKeyOptions);
            context = context == null ? Context.NONE : context;
            context = this.enableSyncRestProxy(context);
            return this.service.release(this.vaultUrl, name, version, this.keyServiceVersion.getVersion(), keyReleaseParameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
        }
        catch (RuntimeException e) {
            throw this.logger.logExceptionAsError(e);
        }
    }

    private KeyReleaseParameters validateAndCreateKeyReleaseParameters(String name, String targetAttestationToken, ReleaseKeyOptions releaseKeyOptions) {
        if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'name' cannot be null or empty"));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)targetAttestationToken)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'targetAttestationToken' cannot be null or empty"));
        }
        releaseKeyOptions = releaseKeyOptions == null ? new ReleaseKeyOptions() : releaseKeyOptions;
        return new KeyReleaseParameters().setTargetAttestationToken(targetAttestationToken).setAlgorithm(releaseKeyOptions.getAlgorithm()).setNonce(releaseKeyOptions.getNonce());
    }

    public Mono<Response<KeyVaultKey>> rotateKeyWithResponseAsync(String name, Context context) {
        try {
            if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'name' cannot be null or empty"));
            }
            return this.service.rotateKeyAsync(this.vaultUrl, name, this.keyServiceVersion.getVersion(), CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Rotating key with name %s.", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Rotated key with name %s.", new Object[]{name})).doOnError(error -> this.logger.warning("Failed to rotate key - {}", new Object[]{error}));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    public Response<KeyVaultKey> rotateKeyWithResponse(String name, Context context) {
        try {
            if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'name' cannot be null or empty"));
            }
            context = context == null ? Context.NONE : context;
            context = this.enableSyncRestProxy(context);
            return this.service.rotateKey(this.vaultUrl, name, this.keyServiceVersion.getVersion(), CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
        }
        catch (RuntimeException e) {
            throw this.logger.logExceptionAsError(e);
        }
    }

    public Mono<Response<KeyRotationPolicy>> getKeyRotationPolicyWithResponseAsync(String keyName, Context context) {
        try {
            if (CoreUtils.isNullOrEmpty((CharSequence)keyName)) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'keyName' cannot be null or empty"));
            }
            return this.service.getKeyRotationPolicyAsync(this.vaultUrl, keyName, this.keyServiceVersion.getVersion(), CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Retrieving key rotation policy for key with name.", new Object[]{keyName})).doOnSuccess(response -> this.logger.verbose("Retrieved key rotation policy for key with name.", new Object[]{keyName})).doOnError(error -> this.logger.warning("Failed to retrieve key rotation policy - {}", new Object[]{error}));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    public Response<KeyRotationPolicy> getKeyRotationPolicyWithResponse(String keyName, Context context) {
        try {
            if (CoreUtils.isNullOrEmpty((CharSequence)keyName)) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'keyName' cannot be null or empty"));
            }
            context = context == null ? Context.NONE : context;
            context = this.enableSyncRestProxy(context);
            return this.service.getKeyRotationPolicy(this.vaultUrl, keyName, this.keyServiceVersion.getVersion(), CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
        }
        catch (RuntimeException e) {
            throw this.logger.logExceptionAsError(e);
        }
    }

    public Mono<Response<KeyRotationPolicy>> updateKeyRotationPolicyWithResponseAsync(String keyName, KeyRotationPolicy keyRotationPolicy, Context context) {
        try {
            if (CoreUtils.isNullOrEmpty((CharSequence)keyName)) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'keyName' cannot be null or empty"));
            }
            return this.service.updateKeyRotationPolicyAsync(this.vaultUrl, keyName, this.keyServiceVersion.getVersion(), keyRotationPolicy, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Updating key rotation policy for key with name.", new Object[]{keyName})).doOnSuccess(response -> this.logger.verbose("Updated key rotation policy for key with name.", new Object[]{keyName})).doOnError(error -> this.logger.warning("Failed to retrieve key rotation policy - {}", new Object[]{error}));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    public Response<KeyRotationPolicy> updateKeyRotationPolicyWithResponse(String keyName, KeyRotationPolicy keyRotationPolicy, Context context) {
        try {
            if (CoreUtils.isNullOrEmpty((CharSequence)keyName)) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'keyName' cannot be null or empty"));
            }
            context = context == null ? Context.NONE : context;
            context = this.enableSyncRestProxy(context);
            return this.service.updateKeyRotationPolicy(this.vaultUrl, keyName, this.keyServiceVersion.getVersion(), keyRotationPolicy, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
        }
        catch (RuntimeException e) {
            throw this.logger.logExceptionAsError(e);
        }
    }

    public CryptographyClientBuilder getCryptographyClientBuilder(String keyName, String keyVersion) {
        if (CoreUtils.isNullOrEmpty((CharSequence)keyName)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'keyName' cannot be null or empty."));
        }
        return new CryptographyClientBuilder().keyIdentifier(this.generateKeyId(keyName, keyVersion)).pipeline(this.getHttpPipeline()).serviceVersion(CryptographyServiceVersion.valueOf(this.keyServiceVersion.name()));
    }

    private String generateKeyId(String keyName, String keyVersion) {
        StringBuilder stringBuilder = new StringBuilder(this.getVaultUrl());
        if (!this.getVaultUrl().endsWith("/")) {
            stringBuilder.append("/");
        }
        stringBuilder.append("keys/").append(keyName);
        if (!CoreUtils.isNullOrEmpty((CharSequence)keyVersion)) {
            stringBuilder.append("/").append(keyVersion);
        }
        return stringBuilder.toString();
    }

    private Context enableSyncRestProxy(Context context) {
        return context.addData((Object)HTTP_REST_PROXY_SYNC_PROXY_ENABLE, (Object)true);
    }

    @Host(value="{url}")
    @ServiceInterface(name="KeyVault")
    public static interface KeyService {
        @Post(value="keys/{key-name}/create")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<KeyVaultKey>> createKeyAsync(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") KeyRequestParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Post(value="keys/{key-name}/create")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<KeyVaultKey> createKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") KeyRequestParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="keys/{key-name}/{key-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<KeyVaultKey>> getKeyAsync(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="keys/{key-name}/{key-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<KeyVaultKey> getKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="keys/{key-name}/{key-version}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<KeyVaultKey>> getKeyPollerAsync(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="keys/{key-name}/{key-version}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<KeyVaultKey> getKeyPoller(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Put(value="keys/{key-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<KeyVaultKey>> importKeyAsync(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") KeyImportRequestParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Put(value="keys/{key-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Response<KeyVaultKey> importKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") KeyImportRequestParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Delete(value="keys/{key-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<DeletedKey>> deleteKeyAsync(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Delete(value="keys/{key-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<DeletedKey> deleteKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Patch(value="keys/{key-name}/{key-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<KeyVaultKey>> updateKeyAsync(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @BodyParam(value="application/json") KeyRequestParameters var6, @HeaderParam(value="Content-Type") String var7, Context var8);

        @Patch(value="keys/{key-name}/{key-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Response<KeyVaultKey> updateKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @BodyParam(value="application/json") KeyRequestParameters var6, @HeaderParam(value="Content-Type") String var7, Context var8);

        @Get(value="keys/{key-name}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        @ReturnValueWireType(value=KeyPropertiesPage.class)
        public Mono<PagedResponse<KeyProperties>> getKeyVersionsAsync(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="maxresults") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="keys/{key-name}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        @ReturnValueWireType(value=KeyPropertiesPage.class)
        public PagedResponse<KeyProperties> getKeyVersions(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="maxresults") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Post(value="keys/{key-name}/backup")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<KeyBackup>> backupKeyAsync(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Post(value="keys/{key-name}/backup")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<KeyBackup> backupKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Post(value="keys/restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<KeyVaultKey>> restoreKeyAsync(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") KeyRestoreRequestParameters var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Post(value="keys/restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<KeyVaultKey> restoreKey(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") KeyRestoreRequestParameters var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="keys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=KeyPropertiesPage.class)
        public Mono<PagedResponse<KeyProperties>> getKeysAsync(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="keys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=KeyPropertiesPage.class)
        public PagedResponse<KeyProperties> getKeys(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="{nextUrl}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=KeyPropertiesPage.class)
        public Mono<PagedResponse<KeyProperties>> getKeysAsync(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

        @Get(value="{nextUrl}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=KeyPropertiesPage.class)
        public PagedResponse<KeyProperties> getKeys(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

        @Get(value="deletedkeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=DeletedKeyPage.class)
        public Mono<PagedResponse<DeletedKey>> getDeletedKeysAsync(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="deletedkeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=DeletedKeyPage.class)
        public PagedResponse<DeletedKey> getDeletedKeys(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="{nextUrl}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=DeletedKeyPage.class)
        public Mono<PagedResponse<DeletedKey>> getDeletedKeysAsync(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

        @Get(value="{nextUrl}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=DeletedKeyPage.class)
        public PagedResponse<DeletedKey> getDeletedKeys(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

        @Get(value="deletedkeys/{key-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<DeletedKey>> getDeletedKeyAsync(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="deletedkeys/{key-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<DeletedKey> getDeletedKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="deletedkeys/{key-name}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<DeletedKey>> getDeletedKeyPollerAsync(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="deletedkeys/{key-name}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Response<DeletedKey> getDeletedKeyPoller(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Delete(value="deletedkeys/{key-name}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> purgeDeletedKeyAsync(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Delete(value="deletedkeys/{key-name}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> purgeDeletedKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Post(value="deletedkeys/{key-name}/recover")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<KeyVaultKey>> recoverDeletedKeyAsync(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Post(value="deletedkeys/{key-name}/recover")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<KeyVaultKey> recoverDeletedKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Post(value="rng")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<RandomBytes>> getRandomBytesAsync(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") GetRandomBytesRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="rng")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Response<RandomBytes> getRandomBytes(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") GetRandomBytesRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="keys/{key-name}/{key-version}/release")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<ReleaseKeyResult>> releaseAsync(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") KeyReleaseParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="keys/{key-name}/{key-version}/release")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<ReleaseKeyResult> release(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") KeyReleaseParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/keys/{key-name}/rotate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<KeyVaultKey>> rotateKeyAsync(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/keys/{key-name}/rotate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<KeyVaultKey> rotateKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/keys/{key-name}/rotationpolicy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<KeyRotationPolicy>> getKeyRotationPolicyAsync(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/keys/{key-name}/rotationpolicy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<KeyRotationPolicy> getKeyRotationPolicy(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Put(value="/keys/{key-name}/rotationpolicy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<KeyRotationPolicy>> updateKeyRotationPolicyAsync(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") KeyRotationPolicy var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Put(value="/keys/{key-name}/rotationpolicy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<KeyRotationPolicy> updateKeyRotationPolicy(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") KeyRotationPolicy var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

