/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.CoreUtils;
import com.azure.resourcemanager.compute.models.CachingTypes;
import com.azure.resourcemanager.compute.models.DeleteOptions;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetParameters;
import com.azure.resourcemanager.compute.models.StorageAccountTypes;

public final class VirtualMachineDiskOptions {
    private StorageAccountTypes storageAccountType;
    private CachingTypes cachingTypes;
    private DeleteOptions deleteOptions;
    private DiskEncryptionSetParameters diskEncryptionSetOptions;

    public StorageAccountTypes storageAccountType() {
        return this.storageAccountType;
    }

    public CachingTypes cachingTypes() {
        return this.cachingTypes;
    }

    public DeleteOptions deleteOptions() {
        return this.deleteOptions;
    }

    public boolean isDiskEncryptionSetConfigured() {
        return this.diskEncryptionSetOptions != null;
    }

    public String diskEncryptionSetId() {
        if (this.diskEncryptionSetOptions == null) {
            return null;
        }
        return this.diskEncryptionSetOptions.id();
    }

    public VirtualMachineDiskOptions withStorageAccountTypes(StorageAccountTypes storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

    public VirtualMachineDiskOptions withCachingTypes(CachingTypes cachingTypes) {
        this.cachingTypes = cachingTypes;
        return this;
    }

    public VirtualMachineDiskOptions withDeleteOptions(DeleteOptions deleteOptions) {
        this.deleteOptions = deleteOptions;
        return this;
    }

    public VirtualMachineDiskOptions withDiskEncryptionSet(String diskEncryptionSetId) {
        if (CoreUtils.isNullOrEmpty((CharSequence)diskEncryptionSetId)) {
            if (this.diskEncryptionSetOptions == null) {
                this.diskEncryptionSetOptions = new DiskEncryptionSetParameters();
            }
            this.diskEncryptionSetOptions.withId(null);
        } else {
            if (this.diskEncryptionSetOptions == null) {
                this.diskEncryptionSetOptions = new DiskEncryptionSetParameters();
            }
            this.diskEncryptionSetOptions.withId(diskEncryptionSetId);
        }
        return this;
    }
}

